        ;;
        ;; BIOS
        ;;
hook_isr0 equ 0xfd9a
hook_isr1 equ 0xfd9b

VDP_RD equ 0x0006
VDP_WR equ 0x0007

          ; Function : write data in the VDP-register
          ; Input    : B  - data to write
          ;      C  - number of the register
          ; Registers: AF, BC
WRTVDP equ 0x0047

          ; load_game_pat_nam+52p ...
          ; Function : Writes data in VRAM
          ; Input    : HL - address write
          ;      A  - value write
          ; Registers: AF
WRTVRM equ 0x004d

          ; CODE XREF: vdp_set_readp
          ; Function : Enable VDP to read
          ; Input    : HL - for VRAM-address
          ; Registers: AF
SETRD equ 0x0050

          ; Function : Enable VDP to write
          ; Input    : HL - Address
          ; Registers: AF
SETWRT equ 0x0053

          ; Function : fill VRAM with value
          ; Input    : A  - data byte
          ;      BC - length of the area to be written
          ;      HL - start address
          ; Registers: AF, BC
FILVRM equ 0x0056

          ; Function : Block transfer to VRAM from memory
          ; Input    : BC - blocklength
          ;      DE - Start address of VRAM
          ;      HL - Start address of memory
LDIRVM equ 0x005c

          ; Function : Writes data to PSG-register
          ; Input    : A  - PSG register number
          ;      E  - data write
WRTPSG equ 0x0093

          ; Function : Reads value from PSG-register
          ; Input    : A  - PSG-register read
          ; Output   : A  - value read
RDPSG equ 0x0096

          ; Function : Alternates the CAP lamp status
          ; Input    : A  - #00 is lamp on
          ;       not #00 is lamp off
          ; Registers: AF
CHGCAP equ 0x0132

          ; Function : Reads VDP status register
          ; Output   : A  - Value which was read
          ; Registers: A
RDVDP equ 0x13e

          ; Function : Returns the value of the specified line from the keyboard matrix
          ; Input    : A  - for the specified line
          ; Output   : A  - for data (the bit corresponding to the pressed key will be 0)
          ; Registers: AF
SNSMAT equ 0x141

        ;;
        ;; RAM
        ;;
        map 0xe000

state # (0xe001-0xe000)
substate # (0xe002-0xe001)
state_flags # (0xe003-0xe002)
frame_count # (0xe004-0xe003)
state_pause # (0xe005-0xe004)
frame_count7 # (0xe006-0xe005)
skip_update # (0xe009-0xe006)
input_key_pressed # (0xe00A-0xe009)
input_key_down # (0xe00c-0xe00A)
unk_E00C # (0xe00d-0xe00c)
konami_count # (0xe00E-0xe00d)
konami_pos # (0xe018-0xe00E)
music_channels # (0xe01A-0xe018)
music_channel0 # (0xe026-0xe01A)
music_channel1 # (0xe032-0xe026)
music_channel2 # (0xe03C-0xe032)
psg_reg7 # (0xe040-0xe03C)
demo_counter # (0xe042-0xe040)
input_unk_E042 # (0xe043-0xe042)
game_word_E043 # (0xe045-0xe043)
game_byte_E045 # (0xe049-0xe045)
unk_E049 # (0xe04B-0xe049)
game_unk_E04B # (0xe050-0xe04B)
byte_E050 # (0xe051-0xe050)
game_unk_E051 # (0xe052-0xe051)
game_byte_E052 # (0xe053-0xe052)
game_ended # (0xe0B0-0xe053)
sprs_attribute # (0xe0B2-0xe0B0)
player_unk_E0B2 # (0xe0B8-0xe0B2)
game_unk_E0B8 # (0xe0C4-0xe0B8)
game_unk_E0C4 # (0xe0D4-0xe0C4)
game_unk_E0D4 # (0xe0D8-0xe0D4)
game_unk_E0D8 # (0xe10C-0xe0D8)
game_unk_E10C # (0xe114-0xe10C)
game_unk_E114 # (0xe140-0xe114)
game_byte_E140 # (0xe141-0xe140)
game_byte_E141 # (0xe143-0xe141)
game_byte_E143 # (0xe144-0xe143)
game_byte_E144 # (0xe145-0xe144)
game_unk_E145 # (0xe146-0xe145)
game_unk_E146 # (0xe150-0xe146)
game_unk_E150 # (0xe154-0xe150)
game_unk_E154 # (0xe180-0xe154)
game_unk_E180 # (0xe181-0xe180)
player_spr_attr # (0xe191-0xe181)
game_byte_E191 # (0xe194-0xe191)
game_byte_E194 # (0xe196-0xe194)
game_byte_E196 # (0xe197-0xe196)
game_byte_E197 # (0xe198-0xe197)
game_byte_E198 # (0xe199-0xe198)
game_byte_E199 # (0xe19A-0xe199)
game_byte_E19A # (0xe1B0-0xe19A)
game_byte_E1B0 # (0xe1B1-0xe1B0)
game_byte_E1B1 # (0xe1B7-0xe1B1)
game_byte_E1B7 # (0xe1B8-0xe1B7)
game_word_E1B8 # (0xe1BA-0xe1B8)
game_byte_E1BA # (0xe1BE-0xe1BA)
game_word_E1BE # (0xe1C1-0xe1BE)
game_byte_E1C1 # (0xe1C2-0xe1C1)
game_word_E1C2 # (0xe1C4-0xe1C2)
game_word_E1C4 # (0xe1C6-0xe1C4)
game_unk_E1C6 # (0xe1CD-0xe1C6)
game_byte_E1CD # (0xe1CE-0xe1CD)
game_byte_E1CE # (0xe1CF-0xe1CE)
game_byte_E1CF # (0xe1D1-0xe1CF)
game_byte_E1D1 # (0xe1D2-0xe1D1)
game_byte_E1D2 # (0xe1D3-0xe1D2)
game_byte_E1D3 # (0xe1D4-0xe1D3)
game_byte_E1D4 # (0xe1D5-0xe1D4)
game_byte_E1D5 # (0xe1D6-0xe1D5)
game_byte_E1D6 # (0xe1D7-0xe1D6)
game_word_E1D7 # (0xe1D9-0xe1D7)
game_byte_E1D9 # (0xe1DA-0xe1D9)
game_byte_E1DA # (0xe1DB-0xe1DA)
game_byte_E1DB # (0xe1DC-0xe1DB)
game_byte_E1DC # (0xe1DD-0xe1DC)
game_byte_E1DD # (0xe1DE-0xe1DD)
game_byte_E1DE # (0xe200-0xe1DE)
game_unk_E200 # (0xe201-0xe200)
game_unk_E201 # (0xe260-0xe201)
game_unk_E260 # (0xe270-0xe260)
game_unk_E270 # (0xe290-0xe270)
game_unk_E290 # (0xe310-0xe290)
game_word_E310 # (0xe312-0xe310)
game_word_E312 # (0xe314-0xe312)
game_word_E314 # (0xe316-0xe314)
game_word_E316 # (0xe318-0xe316)
game_byte_E318 # (0xe320-0xe318)
game_byte_E320 # (0xe321-0xe320)
game_byte_E321 # (0xe400-0xe321)
stack_base # 1

        ;;
        ;; ROM
        ;;
        defpage 0,0x4000,0x4000
    db 41h
    db 42h
    dw start
; ---------------------------------------------------------------------------
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop

; =============== S U B R O U T I N E =======================================


start:          ; DATA XREF: ROM:4002o
    di
    im  1
    ld  a, 0C3h ; ''
    ld  (hook_isr0), a
    ld  hl, isr
    ld  (hook_isr1), hl
    ld  sp, stack_base
    ld  hl, 0E000h  ; clear RAM
    ld  de, 0E001h
    ld  bc, 3FFh
    ld  (hl), 0
    ldir
    ld  a, 1
    ld  (skip_update), a
    call  CHGCAP    ; Function : Alternates the CAP lamp status
          ; Input    : A  - #00 is lamp on
          ;       not #00 is lamp off
          ; Registers: AF
    call  init
    xor a
    ld  (skip_update), a
    call  RDVDP   ; Function : Reads VDP status register
          ; Output   : A  - Value which was read
          ; Registers: A
    ei

loc_4041:       ; CODE XREF: start:loc_4041j
    jr  $
; End of function start


; =============== S U B R O U T I N E =======================================


isr:          ; DATA XREF: start+8o
    call  RDVDP   ; Function : Reads VDP status register
          ; Output   : A  - Value which was read
          ; Registers: A
    di
    call  update_music
    ld  hl, skip_update
    bit 0, (hl)
    jr  nz, skip
    inc (hl)
    ei
    call  read_input
    call  update_state
    xor a
    ld  (skip_update), a

skip:         ; CODE XREF: isr+Cj
    call  RDVDP   ; Function : Reads VDP status register
          ; Output   : A  - Value which was read
          ; Registers: A
    or  a
    di
    call  m, update_music
    ei
    ret
; End of function isr


; =============== S U B R O U T I N E =======================================

; HL=HL+A

add_a_to_hl:        ; CODE XREF: switch_jump+2p
          ; sub_430A+15p  ...
    add a, l
    ld  l, a
    ret nc
    inc h
    ret
; End of function add_a_to_hl


; =============== S U B R O U T I N E =======================================

; DE=DE+A

add_a_to_de:        ; CODE XREF: game_sub_4773+2Fp
          ; game_sub_4773+3Dp ...
    add a, e
    ld  e, a
    ret nc
    inc d
    ret
; End of function add_a_to_de


; =============== S U B R O U T I N E =======================================

; JP (HL+A*2)

switch_jump:        ; CODE XREF: update_state:loc_40C6p
    pop hl
    add a, a
    call  add_a_to_hl ; HL=HL+A
    ld  e, (hl)
    inc hl
    ld  d, (hl)
    ex  de, hl
    jp  (hl)
; End of function switch_jump


; =============== S U B R O U T I N E =======================================


swap_mem:       ; CODE XREF: swap_mem+7j
    ld  c, (hl)
    ld  a, (de)
    ld  (hl), a
    ld  a, c
    ld  (de), a
    inc hl
    inc de
    djnz  swap_mem
    ret
; End of function swap_mem


; =============== S U B R O U T I N E =======================================


unused_sub_4085:
    ld  a, l
    rra
    rra
    rra
    rra
    rr  h
    rra
    rr  h
    rra
    rr  h
    ld  l, h
    and 3
    add a, 38h ; '8'
    ld  h, a
    ret
; End of function unused_sub_4085


; =============== S U B R O U T I N E =======================================


unused_sub_4099:
    add hl, hl
    add hl, hl
    add hl, hl
    ld  a, h
    rla
    rla
    rla
    and 0F8h ; ''
    ld  h, l
    ld  l, a
    ret
; End of function unused_sub_4099


; =============== S U B R O U T I N E =======================================


update_state:       ; CODE XREF: isr+13p
    ld  hl, frame_count
    inc (hl)
    ld  a, (hl)
    and 7
    inc hl
    inc hl
    ld  (hl), a
    ld  a, (state_flags)
    and 1000000b
    ld  hl, state_ret
    jr  nz, loc_40BC
    ld  hl, read_input_state ; read the joystick and keyboard input
          ; and do something else

loc_40BC:       ; CODE XREF: update_state+12j
    ld  bc, (state)
    ld  a, c
    cp  3
    jr  z, loc_40C6
    push  hl

loc_40C6:       ; CODE XREF: update_state+1Ej
    call  switch_jump ; JP (HL+A*2)
; ---------------------------------------------------------------------------
    dw update_state0  ; konami logo
    dw update_state1  ; jaguar logo
    dw update_state2  ; play demo
    dw update_state3
    dw update_state4
    dw update_state5  ; game state
    dw update_state6
    dw update_state7  ; maybe game end state
; End of function update_state


; =============== S U B R O U T I N E =======================================

; konami logo

update_state0:        ; DATA XREF: update_state+24o
    djnz  state0substate1
    ld  a, (frame_count)
    rra
    ret nc
    call  move_konami_up
    ret nz
    ld  de, konami_pat_nam
    call  vpokes
    xor a
    jr  next_substate
; ---------------------------------------------------------------------------

state0substate1:      ; CODE XREF: update_state0j
    djnz  state0substate2
    ld  hl, state_pause
    dec (hl)
    ret nz
    ld  de, konami_pat_nam
    call  clear_vpokes
    call  load_jaguar_pat_gen
    jr  next_substate_
; ---------------------------------------------------------------------------

state0substate2:      ; CODE XREF: update_state0:state0substate1j
    djnz  state0substate3
    call  load_jaguar_pat_nam
    xor a
    jp  next_state_
; ---------------------------------------------------------------------------

state0substate3:      ; CODE XREF: update_state0:state0substate2j
    call  clear
    call  vdp_init
    call  load_konami_logo
    call  setup_konami_vars
    jr  next_substate_
; End of function update_state0


; =============== S U B R O U T I N E =======================================

; jaguar logo

update_state1:        ; DATA XREF: update_state+26o
    ld  hl, state_pause
    dec (hl)
    ret nz
    jr  next_state
; End of function update_state1


; =============== S U B R O U T I N E =======================================

; play demo

update_state2:        ; DATA XREF: update_state+28o
    djnz  state2substate1
    call  update_game
    ld  a, (game_ended)
    or  a
    ret nz

loc_4127:       ; CODE XREF: update_state7+27j
    xor a
    jp  loc_4197
; ---------------------------------------------------------------------------

state2substate1:      ; CODE XREF: update_state2j
    call  clear
    call  init_demo
    ld  a, 18h
; End of function update_state2


; =============== S U B R O U T I N E =======================================


next_substate:        ; CODE XREF: update_state0+12j
          ; update_state4+29j
    ld  (state_pause), a

next_substate_:       ; CODE XREF: update_state0+24j
          ; update_state0+3Bj ...
    ld  hl, substate
    inc (hl)

state_ret:        ; DATA XREF: update_state+Fo
    ret
; End of function next_substate


; =============== S U B R O U T I N E =======================================


update_state3:        ; DATA XREF: update_state+2Ao
    ld  a, 93h ; ''
    call  music_sub_79E5
    call  state3_sub_41E5 ; setup something about state 3
    jp  next_state
; End of function update_state3


; =============== S U B R O U T I N E =======================================


show_jaguar_logo:     ; CODE XREF: update_state7+Ep
          ; read_input_state+2Ej
    call  clear
    call  load_jaguar_logo
    jp  next_substate_
; End of function show_jaguar_logo


; =============== S U B R O U T I N E =======================================


update_state4:        ; DATA XREF: update_state+2Co
    djnz  substate1
    ld  hl, state_pause
    dec (hl)
    ret nz
    call  game_sub_45A6
    ld  hl, game_ended
    ld  (hl), 1

next_state:       ; CODE XREF: update_state1+5j
          ; update_state3+8j ...
    ld  a, 18h

next_state_:        ; CODE XREF: update_state0+2Cj
          ; update_state6+29j
    ld  (state_pause), a

next_state__:       ; CODE XREF: unused_state+5j
    ld  hl, state
    inc (hl)

reset_substate:       ; CODE XREF: update_state6+10j
    xor a
    ld  (substate), a
    ret
; ---------------------------------------------------------------------------

substate1:        ; CODE XREF: update_state4j
    call  clear
    ld  hl, byte_E050
    dec (hl)
    call  load_game_pat_nam
    ld  a, 1
    jp  next_substate
; End of function update_state4


; =============== S U B R O U T I N E =======================================

; game state

update_state5:        ; DATA XREF: update_state+2Eo
    call  update_game
    ld  a, (game_ended)
    or  a
    ret nz
    ld  (game_byte_E1DD), a
    jr  next_state
; End of function update_state5


; =============== S U B R O U T I N E =======================================


unused_state:
    ld  a, 7
    ld  (state), a
    jr  next_state__
; End of function unused_state


; =============== S U B R O U T I N E =======================================


update_state6:        ; DATA XREF: update_state+30o
    ld  a, (byte_E050)
    or  a
    jr  z, loc_41A1
    ld  a, 4

loc_4197:       ; CODE XREF: update_state2+Bj
    ld  (state), a
    ld  a, 18h
    ld  (state_pause), a
    jr  reset_substate
; ---------------------------------------------------------------------------

loc_41A1:       ; CODE XREF: update_state6+4j
    call  clear_sprites2
    call  update_music
    ld  de, word_4B3C ; pattern name data
    call  vpokes
    ld  a, 6
    ld  (state), a
    ld  a, 99h ; ''
    call  music_sub_79E5
    xor a
    jp  next_state_
; End of function update_state6


; =============== S U B R O U T I N E =======================================

; maybe game end state

update_state7:        ; DATA XREF: update_state+32o
    ld  de, state_flags
    ld  a, (input_key_pressed) ; BIT
          ; 0   up
          ; 1   down
          ; 2   left
          ; 3   right
          ; 4   trigger A
          ; 5   trigger B
    and 10000b
    jr  z, loc_41D8
    ld  a, (de)
    and 10111111b
    ld  (de), a
    call  show_jaguar_logo
    pop de
    ld  hl, 1
    ld  (state), hl
    ld  a, 9Dh ; ''
    jp  music_sub_79E5
; ---------------------------------------------------------------------------

loc_41D8:       ; CODE XREF: update_state7+8j
    ld  a, (music_channel0)
    cp  99h ; ''
    ret z
    ld  a, (de)
    and 0BFh ; ''
    ld  (de), a
    jp  loc_4127
; End of function update_state7


; =============== S U B R O U T I N E =======================================

; setup something about state 3

state3_sub_41E5:      ; CODE XREF: update_state3+5p
    ld  hl, unk_E049
    ld  bc, 2F7h
    ld  d, h
    ld  e, l
    inc e
    ld  (hl), 0
    ldir
    ld  hl, byte_4200
    ld  de, byte_E050
    ld  bc, 4
    ldir
    jp  load_game_pat_gen_col
; ---------------------------------------------------------------------------
byte_4200:  db 3      ; DATA XREF: state3_sub_41E5+Do
    db 1
    db 0
    db 2
; End of function state3_sub_41E5


; =============== S U B R O U T I N E =======================================


init_demo:        ; CODE XREF: update_state2+11p
    call  load_game_pat_nam
    call  load_game_pat_gen_col
    xor a
    ld  (game_byte_E140), a
    ld  (unk_E00C), a
    inc a
    ld  (game_ended), a
    ld  hl, demo_counter ; maybe to select the demo stage
    ld  a, (hl)
    inc (hl)
    cp  1
    jr  nz, loc_421F
    inc (hl)

loc_421F:       ; CODE XREF: init_demo+18j
    cp  6
    jr  nz, loc_4225
    ld  (hl), 0

loc_4225:       ; CODE XREF: init_demo+1Dj
    ld  h, a
    ld  l, 0
    ld  (game_word_E1B8), hl
    jp  game_sub_45A6
; End of function init_demo

; ---------------------------------------------------------------------------
; START OF FUNCTION CHUNK FOR clear

clear_sprites:        ; CODE XREF: clear+Aj
    ld  hl, 3B00h
    ld  bc, 128

loc_4234:       ; CODE XREF: clear-137j
    ld  a, 227
    call  FILVRM
    ld  a, (music_channel0)
    cp  147
    ld  a, 157
    jp  nz, music_sub_79E5
    ret
; ---------------------------------------------------------------------------

clear_sprites2:       ; CODE XREF: update_state6:loc_41A1p
    ld  hl, 3B24h
    ld  bc, 92
    jr  loc_4234
; END OF FUNCTION CHUNK FOR clear

; =============== S U B R O U T I N E =======================================


game_sub_424C:        ; CODE XREF: game_sub_69C9-19p
          ; game_sub_69C9-Ep ...
    ld  a, (state_flags)
    add a, a
    ret p
    ld  hl, unk_E049
    ld  a, (hl)
    add a, e
    daa
    ld  (hl), a
    ld  e, a
    inc l
    ld  a, (hl)
    adc a, d
    daa
    ld  (hl), a
    ld  d, a
    inc hl
    jr  nc, loc_4296
    ld  a, (hl)
    add a, 1
    daa
    ld  (hl), a
    jr  nc, loc_4276
    ld  bc, 9999h
    ld  (game_word_E043), bc
    ld  (game_word_E043+1), bc
    jr  loc_42D0
; ---------------------------------------------------------------------------

loc_4276:       ; CODE XREF: game_sub_424C+1Bj
    ld  a, (game_byte_E052)
    cp  (hl)
    jr  nc, loc_4296
    push  de
    push  hl
    add a, 4
    daa
    jr  nc, loc_4285
    ld  a, 0FFh

loc_4285:       ; CODE XREF: game_sub_424C+35j
    ld  (game_byte_E052), a
    ld  hl, byte_E050
    inc (hl)
    call  sub_430A
    ld  a, 0Bh
    call  game_sub_79D8
    pop hl
    pop de

loc_4296:       ; CODE XREF: game_sub_424C+14j
          ; game_sub_424C+2Ej
    ld  a, (game_byte_E045)
    ld  b, (hl)
    sub b
    jr  c, loc_42A6
    jr  nz, loc_42D9
    ld  hl, (game_word_E043)
    sbc hl, de
    jr  nc, loc_42D9

loc_42A6:       ; CODE XREF: game_sub_424C+4Fj
    ld  (game_word_E043), de
    ld  a, b
    ld  (game_byte_E045), a
    jr  loc_42D0
; End of function game_sub_424C


; =============== S U B R O U T I N E =======================================


load_game_pat_nam:      ; CODE XREF: update_state4+24p
          ; init_demop
    ld  de, word_4B00 ; game pattern name data
    call  vpokes
    call  sub_430A
    call  loc_42E3
    ld  de, unk_4B2F
    ld  hl, 3AD8h
    ld  bc, 7
    call  LDIRVM_swaped
    ld  hl, 3AFAh
    ld  c, 5
    call  LDIRVM_swaped

loc_42D0:       ; CODE XREF: game_sub_424C+28j
          ; game_sub_424C+62j
    ld  de, game_byte_E045
    ld  hl, 38B9h
    call  loc_42DF

loc_42D9:       ; CODE XREF: game_sub_424C+51j
          ; game_sub_424C+58j
    ld  hl, 3859h
    ld  de, game_unk_E04B

loc_42DF:       ; CODE XREF: load_game_pat_nam+26p
    ld  b, 3
    jr  loc_42F0
; ---------------------------------------------------------------------------

loc_42E3:       ; CODE XREF: load_game_pat_nam+9p
          ; game_sub_5820+Ap
    ld  hl, 3A3Ch
    ld  a, (state_flags)
    and 40h ; '@'
    ld  de, game_unk_E051
    ld  b, 1

loc_42F0:       ; CODE XREF: load_game_pat_nam+31j
          ; load_game_pat_nam+57j
    ld  a, (de)
    rra
    rra
    rra
    rra
    and 0Fh
    add a, 10h
    call  WRTVRM
    inc hl
    ld  a, (de)
    and 0Fh
    add a, 10h
    call  WRTVRM
    dec de
    inc hl
    djnz  loc_42F0
    ret
; End of function load_game_pat_nam


; =============== S U B R O U T I N E =======================================


sub_430A:       ; CODE XREF: game_sub_424C+40p
          ; load_game_pat_nam+6p
    ld  a, (byte_E050)
    ld  b, 6
    ld  c, a

loc_4310:       ; CODE XREF: sub_430A+25j
    ld  a, 6
    sub b
    ld  hl, 3939h
    cp  3
    jr  c, loc_431E
    ld  l, 79h ; 'y'
    sub 3

loc_431E:       ; CODE XREF: sub_430A+Ej
    add a, a
    call  add_a_to_hl ; HL=HL+A
    ld  e, 0
    dec c
    inc c
    jr  z, loc_432A
    dec c
    dec e

loc_432A:       ; CODE XREF: sub_430A+1Cj
    ld  a, 0A4h ; ''
    call  loc_4332
    djnz  loc_4310
    ret
; ---------------------------------------------------------------------------

loc_4332:       ; CODE XREF: sub_430A+22p
    call  loc_4341
    call  loc_4341
    ex  af, af'
    ld  a, 1Eh
    add a, l
    ld  l, a
    ex  af, af'
    call  loc_4341

loc_4341:       ; CODE XREF: sub_430A:loc_4332p
          ; sub_430A+2Bp  ...
    and e
    call  WRTVRM
    inc a
    inc hl
    ret
; End of function sub_430A


; =============== S U B R O U T I N E =======================================


load_jaguar_logo:     ; CODE XREF: show_jaguar_logo+3p
    call  load_jaguar_pat_gen
    jr  load_jaguar_pat_nam
; End of function load_jaguar_logo


; =============== S U B R O U T I N E =======================================


load_jaguar_pat_gen:      ; CODE XREF: update_state0+21p
          ; load_jaguar_logop
    ld  b, 0E0h ; ''
    call  write_vdp_reg7
    call  clear
    ld  de, byte_4D61 ; pattern generator data
    ld  hl, 2600h
    call  uncompress2vram3blocks
    ld  bc, 0E0h ; ''
    ld  hl, 600h
    ld  a, 0F0h ; ''
    call  FILVRM_3banks
    ld  hl, 6E0h
    ld  bc, 60h ; '`'
    ld  a, 80h ; ''
    jp  FILVRM_3banks
; End of function load_jaguar_pat_gen


; =============== S U B R O U T I N E =======================================


load_jaguar_pat_nam:      ; CODE XREF: update_state0+28p
          ; load_jaguar_logo+3j
    ld  de, byte_4E82 ; pattern name data
    call  uncompress_vram
    ld  de, word_4B1C ; pattern name data
    call  vpokes
    ret
; End of function load_jaguar_pat_nam


; =============== S U B R O U T I N E =======================================


clear:          ; CODE XREF: update_state0:state0substate3p
          ; update_state2:state2substate1p ...

; FUNCTION CHUNK AT 422E SIZE 0000001E BYTES

    ld  bc, 300h  ; clear pattern generation name
    ld  hl, 3800h
    xor a
    call  FILVRM
    jp  clear_sprites
; End of function clear


; =============== S U B R O U T I N E =======================================


LDIRVM_swaped:        ; CODE XREF: load_game_pat_nam+15p
          ; load_game_pat_nam+1Dp ...
    ex  de, hl
    jp  LDIRVM
; End of function LDIRVM_swaped

; ---------------------------------------------------------------------------
    db 0Eh
    db 0
    db 18h
    db 0F8h ; 

; =============== S U B R O U T I N E =======================================


uncompress_vram:      ; CODE XREF: load_jaguar_pat_nam+3p
          ; uncompress_vram+18j ...
    ex  de, hl
    ld  e, (hl)
    inc hl
    ld  d, (hl)
    ex  de, hl
    inc de

uncompress_vram_:     ; CODE XREF: uncompress2vram3blocks+4p
    call  vdp_set_write
    exx
    ld  a, c
    exx
    ld  c, a

loc_43A3:       ; CODE XREF: uncompress_vram+21j
          ; uncompress_vram+2Aj
    ld  a, (de)
    inc de
    ld  b, a
    and a
    ret z
    and 7Fh ; ''
    cp  b
    jr  z, loc_43B9
    and a
    jr  z, uncompress_vram
    ld  b, a

loc_43B1:       ; CODE XREF: uncompress_vram+1Fj
    ld  a, (de)
    inc de
    out (c), a
    djnz  loc_43B1
    jr  loc_43A3
; ---------------------------------------------------------------------------

loc_43B9:       ; CODE XREF: uncompress_vram+15j
    ld  a, (de)
    inc de

loc_43BB:       ; CODE XREF: uncompress_vram+28j
    out (c), a
    nop
    djnz  loc_43BB
    jr  loc_43A3
; End of function uncompress_vram


; =============== S U B R O U T I N E =======================================


vdp_set_write:        ; CODE XREF: uncompress_vram:uncompress_vram_p
          ; vpokes+8p ...
    ex  af, af'
    call  SETWRT
    exx
    ld  a, (VDP_RD)
    ld  c, a
    exx
    ex  af, af'
    ret
; End of function vdp_set_write


; =============== S U B R O U T I N E =======================================


vdp_set_read:
    call  SETRD
    exx
    ld  a, (VDP_WR)
    ld  c, a
    exx
    ret
; End of function vdp_set_read


; =============== S U B R O U T I N E =======================================


vpokes:         ; CODE XREF: update_state0+Ep
          ; update_state6+1Bp ...
    ld  c, 0FFh

loc_43DA:       ; CODE XREF: vpokes+11j
          ; clear_vpokes+2j
    ex  de, hl
    ld  e, (hl)
    inc hl
    ld  d, (hl)
    ex  de, hl
    inc de
    call  vdp_set_write

loc_43E3:       ; CODE XREF: vpokes+19j
    ld  a, (de)
    inc de
    ld  b, a
    inc b
    ret z   ; at 0xff exit
    inc b
    jr  z, loc_43DA ; at 0xfe another address
    and c
    exx
    out (c), a
    exx
    inc hl
    jr  loc_43E3
; End of function vpokes


; =============== S U B R O U T I N E =======================================


clear_vpokes:       ; CODE XREF: update_state0+1Ep
    ld  c, 0
    jr  loc_43DA
; End of function clear_vpokes


; =============== S U B R O U T I N E =======================================


FILVRM_3banks:        ; CODE XREF: load_jaguar_pat_gen+19p
          ; load_jaguar_pat_gen+24j ...
    ld  d, 3

loc_43F9:       ; CODE XREF: FILVRM_3banks+Ej
    push  bc
    push  de
    call  FILVRM
    ld  de, 800h
    add hl, de
    pop de
    pop bc
    dec d
    jr  nz, loc_43F9
    ret
; End of function FILVRM_3banks


; =============== S U B R O U T I N E =======================================


uncompress2vram3blocks:     ; CODE XREF: load_jaguar_pat_gen+Ep
          ; load_konami_logo+2Cp  ...
    ld  b, 3

loc_440A:       ; CODE XREF: uncompress2vram3blocks+Dj
    push  bc
    push  de
    call  uncompress_vram_
    ld  de, 800h
    add hl, de
    pop de
    pop bc
    djnz  loc_440A
    ret
; End of function uncompress2vram3blocks


; =============== S U B R O U T I N E =======================================


init:         ; CODE XREF: start+26p
    ld  a, 10111000b  ; initialize psg channels
    call  write_psg_reg7
    ld  a, 9Dh ; ''
    call  music_sub_79E5
    ld  de, 0   ; clear VRAM
    ld  bc, 4000h
    xor a
    call  FILVRM
; End of function init


; =============== S U B R O U T I N E =======================================


vdp_init:       ; CODE XREF: update_state0+32p
    ld  hl, vdp_init_data
    ld  d, 8
    ld  c, 0

loc_4433:       ; CODE XREF: vdp_init+Ej
    ld  b, (hl)
    call  WRTVDP
    inc hl
    inc c
    dec d
    jr  nz, loc_4433
    ret
; ---------------------------------------------------------------------------
vdp_init_data:  dw 0E202h   ; DATA XREF: vdp_inito
    dw 7F0Eh
    dw 7607h
    dw 0E003h
; End of function vdp_init


; =============== S U B R O U T I N E =======================================


write_vdp_reg7:       ; CODE XREF: load_jaguar_pat_gen+2p
          ; setup_konami_vars+Dj  ...
    ld  c, 7
    jp  WRTVDP
; End of function write_vdp_reg7


; =============== S U B R O U T I N E =======================================


read_joystick:        ; CODE XREF: read_inputp
    ld  e, 10001111b

read_joystick_:       ; CODE XREF: read_input_state+2p
    ld  a, 15
    call  WRTPSG
    ld  a, 14
    di
    call  RDPSG
    ei
    cpl
    and 111111b
    ret
; End of function read_joystick


; =============== S U B R O U T I N E =======================================


read_input:       ; CODE XREF: isr+10p
    call  read_joystick
    push  af
    call  read_keyboard
    pop hl
    or  h
    ld  hl, state_flags
    bit 6, (hl)
    call  z, input_sub_449E
    ld  hl, input_key_down ; BIT
          ; 0   up
          ; 1   down
          ; 2   left
          ; 3   right
          ; 4   trigger A
          ; 5   trigger B
    ld  c, (hl)
    ld  (hl), a
    xor c
    and (hl)
    dec hl
    ld  (hl), a
    inc hl
    ld  a, (hl)
    ret
; End of function read_input


; =============== S U B R O U T I N E =======================================


read_keyboard:        ; CODE XREF: read_input+4p
          ; read_input_state+6p
    ld  a, 7
    call  SNSMAT
    cpl
    rrca
    and 100000b
    ld  e, a
    ld  a, 8
    call  SNSMAT
    cpl
    rrca
    rrca
    ld  b, a
    and 4
    or  e
    ld  c, a
    ld  a, b
    rrca
    rrca
    ld  b, a
    and 18h
    or  c
    ld  c, a
    ld  a, b
    rrca
    and 3
    or  c
    ret
; End of function read_keyboard


; =============== S U B R O U T I N E =======================================


input_sub_449E:       ; CODE XREF: read_input+Ep
    ld  hl, unk_E00C
    ld  a, (frame_count)
    and 1Fh
    ld  a, (hl)
    jr  nz, loc_44AA
    inc (hl)

loc_44AA:       ; CODE XREF: input_sub_449E+9j
    ld  hl, byte_4B5F
    call  add_a_to_hl ; HL=HL+A
    ld  a, (hl)
    ld  l, a
    ld  a, (frame_count)
    and 7
    jr  nz, loc_44BB
    set 4, l

loc_44BB:       ; CODE XREF: input_sub_449E+19j
    ld  a, l
    cp  0FFh
    ret nz
    xor a
    ld  (unk_E00C), a
    ret
; End of function input_sub_449E


; =============== S U B R O U T I N E =======================================

; read the joystick and keyboard input
; and do something else

read_input_state:     ; DATA XREF: update_state+14o
    ld  e, 10001111b
    call  read_joystick_
    ld  d, a
    call  read_keyboard
    or  d
    ld  hl, input_unk_E042
    ld  b, (hl)
    ld  (hl), a
    xor b
    and (hl)
    and 11111b
    ret z
    ld  hl, state
    ld  b, (hl)
    djnz  loc_44EC
    and 10000b
    ret z
    ld  a, 40h ; '@'
    ld  (state_flags), a
    ld  (hl), 3
    inc hl
    ld  (hl), 0
    ret
; ---------------------------------------------------------------------------

loc_44EC:       ; CODE XREF: read_input_state+18j
    xor a
    ld  (state_pause), a
    ld  (hl), 1
    jp  show_jaguar_logo
; End of function read_input_state


; =============== S U B R O U T I N E =======================================


setup_konami_vars:      ; CODE XREF: update_state0+38p
    ld  a, 11h
    ld  (konami_count), a
    ld  hl, 3AAAh
    ld  (konami_pos), hl
    ld  b, 0E4h ; ''
    jp  write_vdp_reg7
; End of function setup_konami_vars


; =============== S U B R O U T I N E =======================================


move_konami_up:       ; CODE XREF: update_state0+7p
    ld  hl, (konami_pos)
    ld  de, -32
    add hl, de
    ld  (konami_pos), hl
    ld  a, 40h ; '@'
    ld  b, 3
    call  loc_4529
    ld  bc, 0B0Ch
    call  loc_4529
    ld  b, c
    call  loc_4529
    xor a
    call  FILVRM
    ld  hl, konami_count
    dec (hl)
    ret
; ---------------------------------------------------------------------------

loc_4529:       ; CODE XREF: move_konami_up+Ep
          ; move_konami_up+14p ...
    push  hl

loc_452A:       ; CODE XREF: move_konami_up+2Aj
    call  WRTVRM
    inc hl
    inc a
    djnz  loc_452A
    pop de
    ld  hl, 20h ; ' '
    add hl, de
    ret
; End of function move_konami_up


; =============== S U B R O U T I N E =======================================


update_game:        ; CODE XREF: update_state2+2p
          ; update_state5p
    ld  hl, game_byte_E1DC
    ld  a, (hl)
    and a
    jr  z, loc_4540
    dec (hl)
    ret nz

loc_4540:       ; CODE XREF: update_game+5j
    ld  a, (music_channel0)
    cp  93h ; ''
    ret z
    call  load_sprs_attribute
    call  game_sub_5837
    call  move_player_spr
    call  game_sub_4773
    call  loc_5334
    call  game_sub_499C
    ld  a, (game_byte_E1B0)
    cp  7
    call  z, game_sub_6670
    call  game_sub_6745
    call  game_sub_65E0
    call  game_sub_6641
    call  game_sub_46B4
    call  game_sub_46F3
    call  game_sub_6A9C
    call  game_sub_6A34
    call  game_sub_6AFC
    call  game_sub_7766
    ld  a, (game_byte_E140)
    and 3
    jr  z, loc_45A0
    cp  2
    call  z, game_sub_474E
    call  game_sub_6733
    call  game_sub_7834
    ld  a, (game_byte_E140)
    cp  2
    jr  nz, loc_459A
    call  game_sub_7928
    call  game_sub_7942

loc_459A:       ; CODE XREF: update_game+5Bj
    call  game_sub_7870
    call  game_sub_69CE

loc_45A0:       ; CODE XREF: update_game+49j
    call  update_game_pat_gen
    jp  loc_7527
; End of function update_game


; =============== S U B R O U T I N E =======================================


game_sub_45A6:        ; CODE XREF: update_state4+7p
          ; init_demo+27j

; FUNCTION CHUNK AT 5830 SIZE 00000007 BYTES

    ld  b, 0E0h ; ''
    call  write_vdp_reg7
    call  clear_sprs_attribute
    ld  hl, game_unk_E200
    ld  de, game_unk_E201
    ld  bc, 13Fh
    ld  (hl), 0
    ldir
    ld  de, game_unk_E180
    ld  hl, game_byte_4625
    ld  bc, 7
    ldir
    ld  hl, game_word_E1B8
    ld  a, 0C0h ; ''
    and (hl)
    ld  (hl), a
    inc hl
    inc hl
    ld  (hl), 0
    xor a
    ld  (game_byte_E1D9), a
    ld  (game_byte_E196), a
    ld  (game_byte_E1CF), a
    ld  (game_byte_E194), a
    ld  (game_byte_E1D4), a
    ld  (game_byte_E1D5), a
    ld  (game_byte_E198), a
    ld  (game_byte_E1DD), a
    call  game_sub_7522
    ld  hl, game_byte_E140
    ld  a, (hl)
    ld  c, (hl)
    and 3
    jr  z, loc_4607
    inc hl
    dec a
    ld  a, 8
    jr  nz, loc_45FE
    xor a
    ld  c, a

loc_45FE:       ; CODE XREF: game_sub_45A6+54j
    ld  (hl), a
    dec hl
    ld  (hl), c
    call  game_sub_7834
    call  game_sub_7870

loc_4607:       ; CODE XREF: game_sub_45A6+4Ej
    ld  hl, game_unk_E145
    ld  de, game_unk_E146
    ld  bc, 5
    ld  (hl), 0
    ldir
    ld  a, 60h ; '`'
    ld  (game_byte_E1DC), a
    call  setup_spr_pat_gen
    call  update_player_spr_attr
    call  load_sprs_attribute
    jp  loc_5830
; End of function game_sub_45A6

; ---------------------------------------------------------------------------
game_byte_4625: db 0      ; DATA XREF: game_sub_45A6+18o
    db 0A0h
    db 5Ch
    db 0
    db 4
    db 4
    db 0Fh
; ---------------------------------------------------------------------------
; START OF FUNCTION CHUNK FOR move_player_spr

loc_462C:       ; CODE XREF: move_player_spr+5j
    inc hl
    dec (hl)
    jr  z, loc_4651
    ld  a, (hl)
    cp  60h ; '`'
    ld  c, 94h ; ''
    jr  nc, loc_4639
    ld  c, 9Ch ; ''

loc_4639:       ; CODE XREF: move_player_spr-2Ej
    cp  40h ; '@'
    jr  nc, loc_463F
    ld  c, 0F8h ; ''

loc_463F:       ; CODE XREF: move_player_spr-28j
    ld  hl, player_unk_E0B2
    ld  (hl), c
    inc hl
    ld  (hl), 6
    inc hl
    inc hl
    inc hl
    ld  a, c
    add a, 4
    ld  (hl), a
    inc hl
    ld  (hl), 0Fh
    ret
; ---------------------------------------------------------------------------

loc_4651:       ; CODE XREF: move_player_spr-35j
    inc (hl)
    ex  de, hl
    ld  hl, game_unk_E145
    xor a
    ld  b, 6

loc_4659:       ; CODE XREF: move_player_spr-8j
    or  (hl)
    inc hl
    djnz  loc_4659
    ret nz
    ex  de, hl
    ld  (game_ended), a
    ret
; END OF FUNCTION CHUNK FOR move_player_spr

; =============== S U B R O U T I N E =======================================


move_player_spr:      ; CODE XREF: update_game+15p

; FUNCTION CHUNK AT 462C SIZE 00000037 BYTES

    ld  hl, game_byte_E1CF
    ld  a, (hl)
    and a
    jr  nz, loc_462C
    ld  a, (input_key_down) ; BIT
          ; 0   up
          ; 1   down
          ; 2   left
          ; 3   right
          ; 4   trigger A
          ; 5   trigger B
    ld  hl, (player_spr_attr)
    ld  e, l
    ld  d, h
    ld  bc, 0
    rra
    jr  nc, loc_4679
    dec c

loc_4679:       ; CODE XREF: move_player_spr+13j
    rra
    jr  nc, loc_467D
    inc c

loc_467D:       ; CODE XREF: move_player_spr+17j
    rra
    jr  nc, loc_4681
    dec b

loc_4681:       ; CODE XREF: move_player_spr+1Bj
    rra
    jr  nc, loc_4685
    inc b

loc_4685:       ; CODE XREF: move_player_spr+1Fj
    ld  a, h
    add a, b
    ld  h, a
    sub 0Ah
    cp  0A4h ; ''
    jr  c, loc_468F
    ld  h, d

loc_468F:       ; CODE XREF: move_player_spr+29j
    ld  a, l
    add a, c
    ld  l, a
    sub 40h ; '@'
    cp  70h ; 'p'
    jr  c, loc_4699
    ld  l, e

loc_4699:       ; CODE XREF: move_player_spr+33j
    ld  (player_spr_attr), hl
; End of function move_player_spr


; =============== S U B R O U T I N E =======================================


update_player_spr_attr:     ; CODE XREF: game_sub_45A6+76p
    ld  de, sprs_attribute
    ld  hl, player_spr_attr
    push  hl
    ld  bc, 4
    ldir
    pop hl
    ld  c, 2
    ldir
    inc hl
    inc hl
    ld  c, 2
    ldir
    ret
; End of function update_player_spr_attr


; =============== S U B R O U T I N E =======================================


game_sub_46B4:        ; CODE XREF: update_game+32p
    ld  a, (game_byte_E1CF)
    and a
    ret nz
    ld  a, (input_key_pressed) ; BIT
          ; 0   up
          ; 1   down
          ; 2   left
          ; 3   right
          ; 4   trigger A
          ; 5   trigger B
    and 10h
    ret z
    ld  b, 2
    ld  a, (game_byte_E1D5)
    cp  2
    jr  c, loc_46C9
    inc b

loc_46C9:       ; CODE XREF: game_sub_46B4+12j
    ld  hl, game_unk_E0B8

loc_46CC:       ; CODE XREF: game_sub_46B4+21j
    ld  a, (hl)
    cp  0E0h ; ''
    jr  z, loc_46D8
    ld  a, 4
    add a, l
    ld  l, a
    djnz  loc_46CC
    ret
; ---------------------------------------------------------------------------

loc_46D8:       ; CODE XREF: game_sub_46B4+1Bj
    ld  de, (player_spr_attr)
    ld  (hl), e
    inc hl
    ld  (hl), d
    inc hl
    ld  a, (game_byte_E1D5)
    and a
    ld  a, 8
    jr  z, loc_46EA
    ld  a, 0Ch

loc_46EA:       ; CODE XREF: game_sub_46B4+32j
    ld  (hl), a
    inc hl
    ld  (hl), 0Fh
    ld  a, 0Ch
    jp  game_sub_79D8
; End of function game_sub_46B4


; =============== S U B R O U T I N E =======================================


game_sub_46F3:        ; CODE XREF: update_game+35p
    ld  b, 3
    ld  hl, game_unk_E0B8

loc_46F8:       ; CODE XREF: game_sub_46F3+15j
    ld  a, (hl)
    cp  0E0h ; ''
    jr  z, loc_4704
    sub 6
    jr  nc, loc_4703
    ld  a, 0E0h ; ''

loc_4703:       ; CODE XREF: game_sub_46F3+Cj
    ld  (hl), a

loc_4704:       ; CODE XREF: game_sub_46F3+8j
    inc hl
    inc hl
    inc hl
    inc hl
    djnz  loc_46F8
    ret
; End of function game_sub_46F3

; ---------------------------------------------------------------------------
; START OF FUNCTION CHUNK FOR game_sub_4773

loc_470B:       ; CODE XREF: game_sub_4773+Aj
    dec hl
    dec hl
    dec hl
    dec (hl)
    ret nz
    ld  a, (game_byte_E1DB)
    ld  (game_byte_E1B0), a
    ld  a, 8
    ld  (hl), a
    dec hl
    ld  a, (hl)
    ld  (game_byte_E198), a
    dec hl
    dec (hl)
    jr  nz, loc_4792
    ld  l, 95h ; ''
    xor a
    ld  (hl), a
    inc hl
    ld  (hl), a
    ld  a, (game_byte_E1B1)
    ld  (game_byte_E197), a
    jr  loc_4792
; ---------------------------------------------------------------------------

loc_4730:       ; CODE XREF: game_sub_4773+18j
    ld  (game_byte_E1DB), a
    ld  hl, game_byte_E194
    ld  c, 5
    ld  a, (hl)
    and a
    ret nz
    ld  (game_byte_E1DA), a
    dec hl
    ld  (hl), 8
    dec hl
    inc (hl)
    dec hl
    ld  (hl), c
    ld  l, 95h ; ''
    inc (hl)
    ld  a, 1
    ld  (game_byte_E196), a
    ret
; END OF FUNCTION CHUNK FOR game_sub_4773

; =============== S U B R O U T I N E =======================================


game_sub_474E:        ; CODE XREF: update_game+4Dp
    ld  a, (frame_count)
    and 7Fh ; ''
    jr  nz, loc_4759
    ld  a, 5
    jr  loc_476E
; ---------------------------------------------------------------------------

loc_4759:       ; CODE XREF: game_sub_474E+5j
    ld  a, (game_word_E1D7)
    cp  2
    ret nz
    ld  hl, game_byte_E144
    dec (hl)
    ret nz
    ld  a, (game_byte_E1B1)
    ld  (hl), a
    ld  hl, game_byte_E198
    inc (hl)
    ld  a, 4

loc_476E:       ; CODE XREF: game_sub_474E+9j
    ld  (game_byte_E1B0), a
    jr  loc_4792
; End of function game_sub_474E


; =============== S U B R O U T I N E =======================================


game_sub_4773:        ; CODE XREF: update_game+18p

; FUNCTION CHUNK AT 470B SIZE 00000043 BYTES

    ld  a, (game_byte_E140)
    and a
    ret nz
    ld  hl, game_byte_E196
    ld  a, (hl)
    and a
    jr  nz, loc_470B
    call  game_sub_7632
    ret c
    ld  a, (game_byte_E1B0)
    cp  10h
    ret nc
    cp  0Dh
    jp  nc, loc_4730
    ld  hl, game_byte_E198
    inc (hl)

loc_4792:       ; CODE XREF: game_sub_4773-53j
          ; game_sub_4773-45j ...
    ld  hl, game_byte_E198
    ld  a, (game_byte_E1B0)
    add a, a
    ret z
    bit 0, (hl)
    jr  z, loc_479F
    inc a

loc_479F:       ; CODE XREF: game_sub_4773+29j
    ld  de, loc_48C8
    call  add_a_to_de ; DE=DE+A
    ld  a, (de)
    ld  (game_byte_E199), a
    ld  c, a
    inc hl
    ld  (hl), c
    inc hl
    ld  de, unk_48E8
    call  add_a_to_de ; DE=DE+A
    ld  a, (de)
    ld  (hl), a
    ld  de, -16
    ld  hl, game_unk_E260
    ld  a, (game_byte_E321)
    ld  b, 7
    cp  0Ah
    jr  nz, loc_47C6
    ld  b, 4

loc_47C6:       ; CODE XREF: game_sub_4773+4Fj
          ; game_sub_4773+58j
    ld  a, (hl)
    and a
    jr  z, loc_47CE
    add hl, de
    djnz  loc_47C6
    ret
; ---------------------------------------------------------------------------

loc_47CE:       ; CODE XREF: game_sub_4773+55j
    ld  (game_word_E310), hl
    ld  a, (game_byte_E1B0)
    ld  (hl), a
    inc hl
    ld  (hl), c
    inc hl
    ld  a, 3
    ld  (hl), a
    ld  a, (game_byte_E1B0)
    cp  9
    jr  nz, loc_47F1
    ex  af, af'
    ld  a, (game_byte_E198)
    and 3
    ld  de, byte_4975
    call  add_a_to_de ; DE=DE+A
    ld  a, (de)
    ld  (hl), a
    ex  af, af'

loc_47F1:       ; CODE XREF: game_sub_4773+6Dj
    cp  5
    jr  nz, loc_4817
    ex  de, hl
    ld  hl, game_byte_E1D4
    inc (hl)
    ld  a, (hl)
    and 1Fh
    ld  b, 0
    cp  18h
    jr  nz, loc_4804
    inc b

loc_4804:       ; CODE XREF: game_sub_4773+8Ej
    and 0Fh
    cp  6
    jr  nz, loc_4815
    ld  b, 2
    ld  a, (game_byte_E1D5)
    cp  2
    jr  c, loc_4815
    ld  b, 0

loc_4815:       ; CODE XREF: game_sub_4773+95j
          ; game_sub_4773+9Ej
    ex  de, hl
    ld  (hl), b

loc_4817:       ; CODE XREF: game_sub_4773+80j
    inc hl
    ld  a, (game_byte_E1B7)
    ld  (hl), a
    inc hl
    ld  a, (game_byte_E199)
    ld  c, a
    ex  de, hl
    ld  hl, byte_48FB
    call  add_a_to_hl ; HL=HL+A
    ld  l, (hl)
    ld  h, 0
    add hl, hl
    add hl, hl
    ex  de, hl
    ld  (hl), e
    inc hl
    ld  (hl), d
    inc hl
    ld  a, c
    add a, a
    ld  de, byte_490D
    push  hl
    ex  de, hl
    call  get_hl_a_ptr  ; DE=(HL+A)
    ld  a, (game_byte_E1B0)
    cp  8
    jr  nz, loc_4855
    ld  a, (game_byte_E198)
    and 7
    add a, a
    ld  hl, byte_4979
    call  add_a_to_hl ; HL=HL+A
    ld  c, (hl)
    inc hl
    ld  h, (hl)
    ld  l, c
    add hl, de
    ex  de, hl

loc_4855:       ; CODE XREF: game_sub_4773+CEj
    pop hl
    ld  (hl), e
    inc hl
    ld  (hl), d
    inc hl
    inc hl
    ld  a, (game_byte_E1B0)
    cp  5
    jr  z, loc_4869
    ld  a, (game_byte_E140)
    cp  2
    jr  z, loc_48C2

loc_4869:       ; CODE XREF: game_sub_4773+EDj
    ld  a, (game_byte_E1B0)
    cp  0Ch
    ld  a, 0E0h ; ''
    jr  z, loc_4874
    ld  a, 0F0h ; ''

loc_4874:       ; CODE XREF: game_sub_4773+FDj
    ld  (hl), a
    inc hl
    inc hl
    ld  a, (game_byte_E19A)
    ld  c, a
    ld  a, (game_byte_E198)
    and 7
    add a, c
    ld  de, byte_4931
    call  add_a_to_de ; DE=DE+A
    ld  a, (de)
    ld  (hl), a

loc_4889:       ; CODE XREF: ROM:loc_48C8j
    inc hl
    ld  a, (game_byte_E1B0)
    ld  de, byte_4945
    cp  0Dh
    jr  c, loc_4896
    sub 0Ch

loc_4896:       ; CODE XREF: game_sub_4773+11Fj
    add a, a
    add a, a
    call  add_a_to_de ; DE=DE+A
    ex  de, hl
    ld  bc, 4
    ldir
    ld  hl, game_byte_E194
    inc (hl)
    ld  a, (game_byte_E199)
    cp  5
    ret nc
    cp  2
    ret z
    ld  a, 2
    call  game_sub_79D8
    ld  a, (game_byte_E140)
    cp  2
    ret nz
    ld  hl, (game_word_E310)
    inc l
    ld  a, (hl)
    xor 3
    ld  (hl), a
    ret
; ---------------------------------------------------------------------------

loc_48C2:       ; CODE XREF: game_sub_4773+F4j
    ld  (hl), 1Ch
    inc l
    inc l
    ld  (hl), 5Ch ; '\'
; End of function game_sub_4773


loc_48C8:       ; DATA XREF: game_sub_4773:loc_479Fo
    jr  loc_4889
; ---------------------------------------------------------------------------
    db    0
    db    1
    db    2
    db    2
    db    3
    db    4
    db    5
    db    6
    db    7
    db    7
    db    8
    db    9
    db  0Ah
    db  0Bh
    db  0Ch
    db  0Dh
    db  0Eh
    db  0Fh
    db  10h
    db  10h
    db  11h
    db  11h
    db  12h
    db  12h
    db    0
    db    1
    db    2
    db    2
    db    3
    db    4
unk_48E8: db    0     ; DATA XREF: game_sub_4773+3Ao
    db    0
    db    0
    db    0
    db    0
    db    8
    db    8
    db    0
    db    8
    db    8
    db    8
    db    8
    db    0
    db    0
    db    0
    db    0
    db  10h
    db    0
    db  10h
byte_48FB:  db 60h      ; DATA XREF: game_sub_4773+AFo
    db 60h
    db 40h
    db 60h
    db 60h
    db 3Bh
    db 3Bh
    db 1Ch
    db 28h
    db 28h
    db 28h
    db 28h
    db 38h
    db 38h
    db 1Ch
    db 1Ch
    db 40h
    db 40h
byte_490D:  db 0      ; DATA XREF: game_sub_4773+C1o
    db 0
    db 0
    db 0
    db 0
    db 0
    db 60h
    db 0
    db 0A0h
    db 0FFh
    db 61h
    db 0
    db 0A0h
    db 0FFh
    db 0
    db 0
    db 90h
    db 0
    db 70h
    db 0FFh
    db 0
    db 0
    db 0
    db 0
    db 0
    db 0
    db 0
    db 0
    db 0
    db 0
    db 0
    db 0
    db 0
    db 0
    db 0
    db 0
byte_4931:  db 10h      ; DATA XREF: game_sub_4773+10Eo
    db 0AAh
    db 3Ch
    db 68h
    db 26h
    db 7Eh
    db 52h
    db 94h
    db 10h
    db 0AAh
    db 10h
    db 0AAh
    db 10h
    db 0AAh
    db 10h
    db 0AAh
    db 10h
    db 52h
    db 3Ch
    db 68h
byte_4945:  db 10h      ; DATA XREF: game_sub_4773+11Ao
    db 26h
    db 58h
    db 68h
    db 10h
    db 1
    db 14h
    db 0Fh
    db 10h
    db 1
    db 14h
    db 0Fh
    db 10h
    db 1
    db 14h
    db 0Fh
    db 30h
    db 0Fh
    db 34h
    db 1
    db 50h
    db 0Fh
    db 54h
    db 1
    db 58h
    db 0Fh
    db 5Ch
    db 0Fh
    db 68h
    db 1
    db 0
    db 0
    db 6Ch
    db 3
    db 70h
    db 0Fh
    db 7Ch
    db 1
    db 80h
    db 0Fh
    db 84h
    db 0Fh
    db 0B8h
    db 0Fh
    db 8Ch
    db 0Bh
    db 90h
    db 0Bh
byte_4975:  db 20h      ; DATA XREF: game_sub_4773+75o
    db 18h
    db 28h
    db 10h
byte_4979:  db 0C0h     ; DATA XREF: game_sub_4773+D6o
    db 0
    db 40h
    db 0FFh
    db 60h
    db 0
    db 0
    db 0
    db 90h
    db 0
    db 0A0h
    db 0FFh
    db 0
    db 0
    db 70h
    db 0FFh

; =============== S U B R O U T I N E =======================================


game_sub_4989:        ; CODE XREF: game_sub_6D36+7p
    push  hl
    ld  a, l
    and 0F0h ; ''
    add a, 90h ; ''
    ld  l, a
    ld  a, (hl)
    inc a
    jr  nz, loc_4995
    ld  (hl), a

loc_4995:       ; CODE XREF: game_sub_4989+9j
    pop hl
    ret
; End of function game_sub_4989

; ---------------------------------------------------------------------------
; START OF FUNCTION CHUNK FOR game_sub_499C

loc_4997:       ; CODE XREF: game_sub_499C+29j
          ; game_sub_499C+37j
    call  game_sub_6D36
    jr  loc_49D6
; END OF FUNCTION CHUNK FOR game_sub_499C

; =============== S U B R O U T I N E =======================================


game_sub_499C:        ; CODE XREF: update_game+1Ep

; FUNCTION CHUNK AT 4997 SIZE 00000005 BYTES

    ld  hl, game_unk_E200
    ld  b, 7

loc_49A1:       ; CODE XREF: game_sub_499C+42j
    push  bc
    ld  a, (hl)
    and a
    ld  (game_word_E310), hl
    jr  z, loc_49D6
    inc hl
    ld  a, (hl)
    cp  13h
    jr  z, loc_49D6
    inc hl
    inc hl
    inc hl
    ld  e, l
    ld  d, h
    inc de
    inc de
    inc de
    inc de
    ld  a, (de)
    add a, (hl)
    ld  (de), a
    inc hl
    inc de
    ld  a, (de)
    adc a, (hl)
    cp  0C0h ; ''
    jr  c, loc_49C7
    cp  0D0h ; ''
    jr  c, loc_4997

loc_49C7:       ; CODE XREF: game_sub_499C+25j
    ld  (de), a
    inc hl
    inc de
    ld  a, (de)
    add a, (hl)
    ld  (de), a
    inc hl
    inc de
    ld  a, (de)
    adc a, (hl)
    cp  0B0h ; ''
    jr  nc, loc_4997
    ld  (de), a

loc_49D6:       ; CODE XREF: game_sub_499C-2j
          ; game_sub_499C+Bj ...
    ld  hl, (game_word_E310)
    ld  de, 10h
    add hl, de
    pop bc
    djnz  loc_49A1
    ld  b, 7
    exx
    ld  de, game_unk_E0D4
    ld  hl, game_unk_E200
    exx

loc_49EA:       ; CODE XREF: game_sub_499C+A2j
    exx
    ld  (game_word_E310), hl
    ld  (game_word_E312), de
    ld  a, (hl)
    and a
    jp  z, loc_4A2D
    cp  6
    jp  z, loc_4AD8
    inc hl
    ld  a, (hl)
    cp  13h
    jp  z, loc_4A4B
    cp  10h
    jp  z, loc_4A7C
    ld  a, 8
    add a, l
    ld  l, a
    ld  a, (hl)
    ld  (de), a
    ex  af, af'
    inc hl
    inc hl
    inc de
    ld  c, (hl)
    ex  de, hl
    ld  (hl), c
    ex  de, hl
    inc de
    inc hl
    ld  a, (hl)
    ld  (de), a
    inc hl
    inc de
    ld  a, (hl)
    ld  (de), a
    inc de
    ex  af, af'
    ld  (de), a
    inc de
    ex  de, hl
    ld  (hl), c
    ex  de, hl
    inc de
    inc hl
    ld  a, (hl)
    ld  (de), a
    inc hl
    inc de
    ld  a, (hl)
    ld  (de), a

loc_4A2D:       ; CODE XREF: game_sub_499C+58j
          ; game_sub_499C+CBj ...
    ld  hl, (game_word_E310)
    ld  de, (game_word_E312)
    ld  a, 10h
    add a, l
    ld  l, a
    ld  a, 8
    call  add_a_to_de ; DE=DE+A
    exx
    djnz  loc_49EA
    ret
; ---------------------------------------------------------------------------

loc_4A41:       ; CODE XREF: game_sub_499C+B2j
    inc de
    inc de
    inc de
    inc de
    ld  a, 9
    add a, l
    ld  l, a
    jr  loc_4A65
; ---------------------------------------------------------------------------

loc_4A4B:       ; CODE XREF: game_sub_499C+64j
    inc l
    ld  a, (hl)
    and a
    jr  z, loc_4A41
    inc l
    ld  a, (hl)
    ld  (de), a
    inc l
    inc l
    inc l
    inc l
    inc de
    ld  a, (hl)
    ld  (de), a
    inc l
    inc de
    ld  a, (hl)
    ld  (de), a
    inc l
    inc de
    ld  a, (hl)
    ld  (de), a
    inc l
    inc l
    inc de

loc_4A65:       ; CODE XREF: game_sub_499C+ADj
    ld  a, (hl)
    and a
    jp  z, loc_4A2D
    inc l
    ld  a, (hl)
    ld  (de), a
    inc l
    inc de
    ld  a, (hl)
    ld  (de), a
    inc l
    inc de
    ld  a, (hl)
    ld  (de), a
    inc l
    inc de
    ld  a, (hl)
    ld  (de), a
    jp  loc_4A2D
; ---------------------------------------------------------------------------

loc_4A7C:       ; CODE XREF: game_sub_499C+69j
    inc l
    ld  a, (hl)
    push  af
    ld  a, 7
    add a, l
    ld  l, a
    ld  c, (hl)
    inc hl
    inc hl
    ld  b, (hl)
    inc hl
    ex  de, hl
    ld  (hl), c
    inc hl
    ld  (hl), b
    inc hl
    ld  a, (de)
    ld  (hl), a
    inc de
    inc hl
    ld  a, (de)
    ld  (hl), a
    inc de
    inc hl
    ld  (hl), c
    inc hl
    ld  a, b
    add a, 40h ; '@'
    ld  (hl), a
    inc hl
    ld  a, (de)
    ld  (hl), a
    inc de
    inc hl
    ld  a, (de)
    ld  (hl), a
    pop af
    and 3
    cp  3
    jp  nz, loc_4A2D
    ld  a, (game_word_E310)
    and 0F0h ; ''
    ld  hl, game_unk_E290
    add a, l
    ld  l, a
    ld  (hl), 0FFh
    ld  de, 6
    add hl, de
    ld  (hl), c
    inc hl
    inc hl
    ld  a, (frame_count)
    and 0Fh
    add a, a
    add a, a
    add a, a
    cp  40h ; '@'
    jr  c, loc_4ACD
    sub 80h ; ''
    neg

loc_4ACD:       ; CODE XREF: game_sub_499C+12Bj
    add a, b
    ld  (hl), a
    inc hl
    ld  (hl), 88h ; ''
    inc hl
    ld  (hl), 0Fh
    jp  loc_4A2D
; ---------------------------------------------------------------------------

loc_4AD8:       ; CODE XREF: game_sub_499C+5Dj
    ld  a, 9
    add a, l
    ld  l, a
    ld  a, (hl)
    ld  c, a
    ld  (de), a
    inc hl
    inc hl
    inc de
    ld  a, (hl)
    ld  b, a
    ld  (de), a
    inc hl
    inc de
    ld  a, (hl)
    ld  (de), a
    inc hl
    inc de
    ld  a, (hl)
    ld  (de), a
    inc hl
    inc de
    ex  de, hl
    ld  (hl), c
    inc hl
    ld  a, 10h
    add a, b
    ld  (hl), a
    inc hl
    ld  a, (de)
    ld  (hl), a
    inc de
    inc hl
    ld  a, (de)
    ld  (hl), a
    jp  loc_4A2D
; End of function game_sub_499C

; ---------------------------------------------------------------------------
word_4B00:  dw 3899h    ; DATA XREF: load_game_pat_namo
          ; game pattern name data
    db  28h ; (
    db  29h ; )
    db 0FEh ; 
    dw 3A19h
    db  33h ; 3
    db  23h ; #
    db  25h ; %
    db  2Eh ; .
    db  25h ; %
    db 0FEh ; 
    dw 3839h
    db  33h ; 3
    db  23h ; #
    db  2Fh ; /
    db  32h ; 2
    db  25h ; %
    db 0FEh ; 
    dw 3919h
    db  32h ; 2
    db  25h ; %
    db  33h ; 3
    db  34h ; 4
    db 0FFh
word_4B1C:  dw 3A29h    ; DATA XREF: load_jaguar_pat_nam+6o
          ; pattern name data
    db  30h ; 0
    db  35h ; 5
    db  33h ; 3
    db  28h ; (
    db    0
    db  33h ; 3
    db  30h ; 0
    db  21h ; !
    db  23h ; #
    db  25h ; %
    db    0
    db  2Bh ; +
    db  25h ; %
    db  39h ; 9
    db 0FEh ; 
    dw 394Ah
unk_4B2F: db  1Ah     ; DATA XREF: load_game_pat_nam+Co
    db  2Bh ; +
    db  2Fh ; /
    db  2Eh ; .
    db  21h ; !
    db  2Dh ; -
    db  29h ; )
    db    0
    db  11h
    db  19h
    db  18h
    db  14h
    db 0FFh
word_4B3C:  dw 3968h    ; DATA XREF: update_state6+18o
          ; pattern name data
    db 27h
    db 21h
    db 2Dh
    db 25h
    db 0
    db 0
    db 2Fh
    db 36h
    db 25h
    db 32h
    db 0FFh
konami_pat_nam: dw 3966h    ; DATA XREF: update_state0+Bo
          ; update_state0+1Bo
    db 20h
    db 0
    db 36h
    db 29h
    db 24h
    db 25h
    db 2Fh
    db 0
    db 23h
    db 21h
    db 32h
    db 34h
    db 32h
    db 29h
    db 24h
    db 27h
    db 25h
    db 0
    db 20h
    db 0FFh
byte_4B5F:  db 4      ; DATA XREF: input_sub_449E:loc_44AAo
    db 5
    db 8
    db 8
    db 0Ah
    db 8
    db 1
    db 4
    db 6
    db 6
    db 5
    db 9
    db 8
    db 0Ah
    db 2
    db 4
    db 0FFh
    db 0FFh

; =============== S U B R O U T I N E =======================================


load_konami_logo:     ; CODE XREF: update_state0+35p
    ld  hl, 0
    call  load_konami_pat_nam
    ld  hl, 800h
    call  load_konami_pat_nam
    ld  hl, 1000h
    call  load_konami_pat_nam
    jp  load_konami_pat_gen
; ---------------------------------------------------------------------------

load_konami_pat_nam:      ; CODE XREF: load_konami_logo+3p
          ; load_konami_logo+9p ...
    xor a
    ld  c, 16

loc_4B89:       ; CODE XREF: load_konami_logo+23j
    ld  b, 8

loc_4B8B:       ; CODE XREF: load_konami_logo+1Ej
    call  WRTVRM
    inc hl
    djnz  loc_4B8B
    add a, 17
    dec c
    jr  nz, loc_4B89
    ret
; ---------------------------------------------------------------------------

load_konami_pat_gen:      ; CODE XREF: load_konami_logo+12j
    ld  de, byte_4BAB ; konami pattern generator data
    ld  hl, 2080h
    call  uncompress2vram3blocks
    ld  hl, 80h ; ''
    ld  a, 0F0h ; ''
    ld  bc, 250h
    jp  FILVRM_3banks
; End of function load_konami_logo

; ---------------------------------------------------------------------------
byte_4BAB:  db 8Bh, 0, 1Ch, 22h, 63h, 63h, 63h, 22h, 1Ch, 0, 18h, 38h
          ; DATA XREF: load_konami_logo:load_konami_pat_geno
    db 4, 18h, 0C9h, 7Eh, 0, 3Eh, 63h, 3, 0Eh, 3Ch, 70h, 7Fh ; konami pattern generator data
    db 0, 3Eh, 63h, 3, 0Eh, 3, 63h, 3Eh, 0, 0Eh, 1Eh, 36h
    db 66h, 66h, 7Fh, 6, 0, 7Fh, 60h, 7Eh, 63h, 3, 63h, 3Eh
    db 0, 3Eh, 63h, 60h, 7Eh, 63h, 63h, 3Eh, 0, 7Fh, 63h, 6
    db 0Ch, 18h, 18h, 18h, 0, 3Eh, 63h, 63h, 3Eh, 63h, 63h
    db 3Eh, 0, 3Eh, 63h, 63h, 3Fh, 3, 63h, 3Eh, 3Ch, 42h, 99h
    db 0A1h, 0A1h, 99h, 42h, 3Ch, 2Bh, 0, 1, 7Eh, 4, 0, 0C2h
    db 0, 1Ch, 36h, 63h, 63h, 7Fh, 63h, 63h, 0, 7Eh, 63h, 63h
    db 7Eh, 63h, 63h, 7Eh, 0, 3Eh, 63h, 60h, 60h, 60h, 63h
    db 3Eh, 0, 7Ch, 66h, 63h, 63h, 63h, 66h, 7Ch, 0, 7Fh, 60h
    db 60h, 7Eh, 60h, 60h, 7Fh, 0, 7Fh, 60h, 60h, 7Eh, 60h
    db 60h, 60h, 0, 3Eh, 63h, 60h, 67h, 63h, 63h, 3Fh, 0, 63h
    db 63h, 63h, 7Fh, 63h, 63h, 63h, 0, 3Ch, 5, 18h, 83h, 3Ch
    db 0, 1Fh, 4, 6, 8Bh, 66h, 3Ch, 0, 63h, 66h, 6Ch, 78h
    db 7Ch, 6Eh, 67h, 0, 6, 60h, 93h, 7Fh, 0, 63h, 77h, 7Fh
    db 7Fh, 6Bh, 63h, 63h, 0, 63h, 73h, 7Bh, 7Fh, 6Fh, 67h
    db 63h, 0, 3Eh, 5, 63h, 0A3h, 3Eh, 0, 7Eh, 63h, 63h, 63h
    db 7Eh, 60h, 60h, 0, 3Eh, 63h, 63h, 63h, 6Fh, 66h, 3Dh
    db 0, 7Eh, 63h, 63h, 62h, 7Ch, 66h, 63h, 0, 3Eh, 63h, 60h
    db 3Eh, 3, 63h, 3Eh, 0, 7Eh, 6, 18h, 1, 0, 6, 63h, 82h
    db 3Eh, 0, 4, 63h, 93h, 36h, 1Ch, 8, 0, 63h, 63h, 6Bh
    db 6Bh, 7Fh, 77h, 22h, 0, 63h, 76h, 3Ch, 1Ch, 1Eh, 37h
    db 63h, 90h, 0, 66h, 66h, 7Eh, 3Ch, 18h, 18h, 18h, 0, 7Fh
    db 7, 0Eh, 1Ch, 38h, 70h, 7Fh, 28h, 0, 0Eh, 0, 82h, 7
    db 0Fh, 6, 0, 82h, 0F8h, 0F0h, 4, 3Eh, 4, 3Fh, 8Bh, 1Fh
    db 3Fh, 7Fh, 0FFh, 0FEh, 0FCh, 0F8h, 0F0h, 0E0h, 0C0h
    db 80h, 3, 0, 2, 3Eh, 5, 0, 83h, 1Fh, 7Fh, 0FBh, 5, 0
    db 83h, 0Fh, 0CFh, 0EFh, 5, 0, 83h, 78h, 0FCh, 0BCh, 5
    db 0, 83h, 3Fh, 7Fh, 0F3h, 5, 0, 83h, 87h, 0C7h, 0C7h
    db 5, 0, 83h, 0BCh, 0FEh, 0DFh, 5, 0, 88h, 78h, 0FCh, 0BCh
    db 60h, 0F0h, 0F0h, 60h, 0, 3, 0F0h, 2, 3Fh, 6, 3Eh, 88h
    db 0F8h, 0FCh, 0FEh, 7Fh, 3Fh, 1Fh, 0Fh, 7, 3, 3Eh, 85h
    db 7Eh, 0FCh, 0FCh, 0F8h, 0E0h, 5, 0F1h, 83h, 0FBh, 7Fh
    db 1Fh, 6, 0EFh, 82h, 0CFh, 0Fh, 8, 1Eh, 88h, 0E1h, 3
    db 3Fh, 0F1h, 0E1h, 0F3h, 7Fh, 1Eh, 7, 0E7h, 81h, 0F7h
    db 8, 8Fh, 8, 1Eh, 82h, 0F1h, 0F2h, 4, 0F5h, 8Ah, 0F2h
    db 0F1h, 0E0h, 10h, 0C8h, 68h, 0C8h, 28h, 10h, 0E0h, 0
byte_4D61:  db 0A9h, 0Fh, 10h, 20h, 60h, 61h, 61h, 60h, 70h, 0E7h
          ; DATA XREF: load_jaguar_pat_gen+8o
    db 14h, 4, 4, 86h, 0FEh, 3Eh, 6, 0F7h, 18h, 18h, 10h, 0 ; pattern generator data
    db 0, 1, 0, 0BFh, 20h, 20h, 20h, 0F0h, 0B0h, 0B0h, 98h
    db 7Fh, 0C1h, 0C1h, 0C1h, 0C2h, 2, 2, 4, 3Fh, 3, 30h, 4
    db 18h, 8Bh, 87h, 58h, 70h, 60h, 61h, 61h, 60h, 60h, 0E0h
    db 11h, 0Bh, 5, 6, 94h, 0FFh, 80h, 0, 0, 18h, 1Fh, 10h
    db 10h, 0BEh, 41h, 41h, 41h, 61h, 0E1h, 61h, 61h, 0FEh
    db 82h, 83h, 82h, 4, 86h, 8Ch, 7Eh, 81h, 0, 0, 18h, 18h
    db 0, 0, 3Fh, 20h, 0A0h, 60h, 4, 70h, 8Bh, 0F8h, 4, 2
    db 2, 0C2h, 0C2h, 4, 8, 1Eh, 21h, 61h, 4, 60h, 8Ah, 7Fh
    db 6, 86h, 86h, 6, 0Ch, 1Ch, 2Ch, 0EFh, 0, 6, 18h, 84h
    db 0FFh, 4Ch, 46h, 46h, 4, 2Ch, 84h, 0EFh, 0Fh, 16h, 16h
    db 4, 0Eh, 0B2h, 0FFh, 0F8h, 18h, 18h, 0, 0, 0, 1, 0FEh
    db 60h, 61h, 61h, 41h, 41h, 0C1h, 0C1h, 0FFh, 6, 86h, 86h
    db 86h, 87h, 83h, 81h, 0FCh, 10h, 18h, 18h, 0, 0, 80h
    db 0C0h, 0FFh, 61h, 61h, 61h, 60h, 60h, 70h, 38h, 1Fh
    db 86h, 86h, 86h, 4, 4, 0Ch, 14h, 0E7h, 0, 6, 18h, 81h
    db 0EFh, 3, 70h, 4, 20h, 8Ch, 0BFh, 4, 0C2h, 0C2h, 0C3h
    db 0C1h, 0C1h, 0C1h, 0FEh, 0, 3Fh, 7, 6, 0, 83h, 0FFh
    db 0FFh, 0, 0A7h, 3Fh, 7, 0, 0, 0, 0FFh, 0FFh, 0, 0FFh
    db 0FFh, 0, 3Fh, 0, 0FFh, 0FFh, 0, 0FFh, 0FFh, 0, 0FFh
    db 0, 0FFh, 0FFh, 0, 0FFh, 0FFh, 0, 0FCh, 0, 0FFh, 0FFh
    db 0, 0FCh, 0E0h, 0, 0, 0, 0FCh, 0E0h, 5, 0, 81h, 7, 7
    db 0, 84h, 0FFh, 0, 1Fh, 3, 4, 0, 84h, 0FFh, 0, 0FFh, 0FFh
    db 4, 0, 84h, 0FFh, 0, 0F8h, 0C0h, 4, 0, 81h, 0E0h, 7
    db 0, 0
byte_4E82:  db 0C9h, 38h, 8Eh, 0C0h, 0C1h, 0C2h, 0C3h, 0C4h, 0C5h
          ; DATA XREF: load_jaguar_pat_namo
    db 0C6h, 0C7h, 0C8h, 0C9h, 0CAh, 0CBh, 0CCh, 0CDh, 80h ; pattern name data
    db 0E9h, 38h, 8Eh, 0CEh, 0CFh, 0D0h, 0D1h, 0D2h, 0D3h
    db 0D4h, 0D5h, 0D6h, 0D7h, 0D8h, 0D9h, 0DAh, 0DBh, 80h
    db 9, 39h, 83h, 0DCh, 0DDh, 0DEh, 8, 0DFh, 83h, 0E0h, 0E1h
    db 0E2h, 80h, 2Bh, 39h, 82h, 0E3h, 0E4h, 6, 0E5h, 82h
    db 0E6h, 0E7h, 0

; =============== S U B R O U T I N E =======================================


clear_sprs_attribute:     ; CODE XREF: game_sub_45A6+5p
    ld  hl, sprs_attribute
    ld  b, 128

loc_4EC3:       ; CODE XREF: clear_sprs_attribute+8j
    ld  (hl), 224
    inc hl
    djnz  loc_4EC3
    ret
; End of function clear_sprs_attribute


; =============== S U B R O U T I N E =======================================


load_sprs_attribute:      ; CODE XREF: update_game+Fp
          ; game_sub_45A6+79p
    ld  hl, 3B00h
    ld  de, sprs_attribute
    ld  bc, 24h ; '$'
    call  LDIRVM_swaped
    ld  hl, 3B24h
    call  vdp_set_write
    ld  a, (frame_count)
    and 3
    ld  b, a
    add a, a
    add a, b
    ld  c, 4
    ld  hl, byte_4EFD
    call  add_a_to_hl ; HL=HL+A

loc_4EEB:       ; CODE XREF: load_sprs_attribute+31j
    ld  b, (hl)
    inc hl
    ld  e, (hl)
    inc hl
    ld  d, (hl)
    inc hl

loc_4EF1:       ; CODE XREF: load_sprs_attribute+2Ej
    ld  a, (de)
    inc de
    exx
    out (c), a
    exx
    djnz  loc_4EF1
    dec c
    jr  nz, loc_4EEB
    ret
; ---------------------------------------------------------------------------
byte_4EFD:  db 18h, 0D4h, 0E0h, 18h, 0ECh, 0E0h, 18h, 4, 0E1h, 14h
          ; DATA XREF: load_sprs_attribute+1Co
    db 1Ch, 0E1h, 18h, 0D4h, 0E0h, 18h, 0ECh, 0E0h, 18h, 4
    db 0E1h
; End of function load_sprs_attribute


; =============== S U B R O U T I N E =======================================


setup_spr_pat_gen:      ; CODE XREF: game_sub_45A6+73p
    ld  hl, 1800h
    ld  de, spr_pat_gen ; sprite pattern generation
    jp  uncompress_vram
; End of function setup_spr_pat_gen

; ---------------------------------------------------------------------------
spr_pat_gen:  db 0, 18h, 2, 1, 3, 0, 2, 1, 8Bh, 4, 0Ch, 1Ch, 3Ch, 7Dh
          ; DATA XREF: setup_spr_pat_gen+3o
    db 7Dh, 6Dh, 1, 1, 80h, 80h, 3, 0, 2, 80h, 89h, 20h, 30h ; sprite pattern generation
    db 38h, 3Ch, 0BEh, 0BEh, 0B6h, 80h, 80h, 3, 1, 3, 3, 84h
    db 17h, 1Fh, 0DFh, 0BFh, 4, 0FFh, 82h, 3, 1, 3, 80h, 3
    db 0C0h, 84h, 0E8h, 0F8h, 0F9h, 0FDh, 4, 0FFh, 84h, 0C0h
    db 80h, 1, 1, 0Eh, 0, 2, 80h, 0Eh, 0, 2, 0Ch, 0Eh, 0, 2
    db 30h, 0Eh, 0, 2, 1, 81h, 5, 4, 65h, 2, 44h, 84h, 4, 6
    db 2, 2, 5, 0, 81h, 40h, 4, 4Ch, 2, 44h, 84h, 40h, 0C0h
    db 80h, 80h, 3, 0, 83h, 1, 3, 3, 5, 1Fh, 3, 0Fh, 81h, 7
    db 4, 1, 83h, 0, 80h, 80h, 5, 0F0h, 3, 0E0h, 81h, 0C0h
    db 6, 0, 8Dh, 1Fh, 1Eh, 0, 0, 3Fh, 0, 0FEh, 0, 3Fh, 0
    db 0, 1Eh, 1Fh, 3, 0, 81h, 80h, 3, 0, 85h, 0E0h, 38h, 0
    db 38h, 0E0h, 3, 0, 81h, 80h, 5, 0, 3, 1Fh, 3, 7Fh, 3
    db 1Fh, 8, 0, 87h, 0E0h, 0F0h, 0F0h, 0FFh, 0F0h, 0F0h
    db 0E0h, 7, 0, 2, 1, 84h, 3, 2, 22h, 22h, 4, 32h, 81h
    db 2, 5, 0, 2, 40h, 84h, 50h, 20h, 22h, 22h, 4, 0A5h, 83h
    db 0A0h, 80h, 80h, 4, 0, 81h, 2, 3, 7, 5, 0Fh, 2, 1, 81h
    db 0, 4, 80h, 81h, 0A0h, 3, 0F0h, 5, 0F8h, 2, 0C0h, 2
    db 0, 81h, 1, 3, 0, 85h, 7, 1Ch, 0, 1Ch, 7, 3, 0, 81h
    db 1, 3, 0, 8Dh, 0F8h, 78h, 0, 0, 0FCh, 0, 7Fh, 0, 0FCh
    db 0, 0, 78h, 0F8h, 6, 0, 87h, 7, 0Fh, 0Fh, 0FFh, 0Fh
    db 0Fh, 7, 8, 0, 3, 0F8h, 3, 0FEh, 3, 0F8h, 5, 0, 2, 1
    db 0Ah, 0, 2, 1, 2, 0, 2, 80h, 0Ah, 0, 2, 80h, 86h, 0
    db 3, 6, 6, 7, 3, 6, 1, 8Ah, 3, 7, 6, 6, 3, 0C0h, 60h
    db 60h, 0E0h, 0C0h, 6, 80h, 85h, 0C0h, 0E0h, 60h, 60h
    db 0C0h, 3, 0, 82h, 18h, 10h, 17h, 0, 82h, 4, 0Ch, 4, 0
    db 87h, 1Ch, 26h, 2Eh, 3Eh, 1Dh, 3, 8, 0Eh, 0, 88h, 80h
    db 0C0h, 0E0h, 5Ch, 3Eh, 3Ah, 32h, 1Ch, 8, 0, 2, 60h, 0Eh
    db 0, 2, 6, 0Ch, 0, 86h, 70h, 0F8h, 9Fh, 9Fh, 0F8h, 70h
    db 0Ah, 0, 86h, 0Eh, 1Fh, 0F9h, 0F9h, 1Fh, 0Eh, 11h, 0
    db 82h, 20h, 30h, 5, 0, 82h, 18h, 8, 12h, 0, 88h, 1, 3
    db 7, 3Ah, 7Ch, 5Ch, 4Ch, 38h, 3, 0, 87h, 38h, 64h, 74h
    db 7Ch, 0B8h, 0C0h, 80h, 0Dh, 0, 84h, 2, 1, 1, 2, 0Ch
    db 0, 84h, 40h, 80h, 80h, 40h, 0Ah, 0, 88h, 9, 7, 5, 0Eh
    db 0Eh, 5, 7, 9, 8, 0, 88h, 90h, 0E0h, 0A0h, 70h, 70h
    db 0A0h, 0E0h, 90h, 4, 0, 88h, 80h, 0BCh, 0B7h, 0B6h, 0B6h
    db 0F2h, 1Ch, 3, 9, 0, 83h, 3, 0C3h, 0FBh, 3, 0DBh, 86h
    db 1Bh, 0C3h, 7Bh, 0Bh, 3, 3, 3, 1, 84h, 0, 0C0h, 0C3h
    db 0DFh, 3, 0DBh, 86h, 0D8h, 0C3h, 0DEh, 0D0h, 0C0h, 0C0h
    db 3, 80h, 89h, 1, 3Dh, 0EDh, 6Dh, 6Dh, 61h, 4Fh, 38h
    db 0C0h, 0Ch, 0, 82h, 3, 1Eh, 3, 0B6h, 84h, 0B0h, 87h
    db 0FCh, 0C0h, 3, 0, 2, 3, 82h, 0Bh, 7Bh, 3, 0DBh, 85h
    db 0C3h, 1Bh, 0FBh, 0C3h, 3, 3, 1, 85h, 0, 0C0h, 0C0h
    db 0D0h, 0DEh, 3, 0DBh, 85h, 0C3h, 0D8h, 0DFh, 0C3h, 0C0h
    db 3, 80h, 5, 0, 82h, 0C0h, 78h, 3, 6Dh, 0B1h, 0Dh, 0E1h
    db 3Fh, 3, 0, 0, 46h, 67h, 78h, 5Eh, 5Eh, 62h, 62h, 5Eh
    db 5Eh, 62h, 62h, 36h, 1Ah, 0Fh, 6, 3, 0C4h, 0CCh, 3Ch
    db 0F4h, 0F4h, 8Ch, 8Ch, 0D8h, 0F4h, 8Ch, 8Ch, 0D8h, 0B0h
    db 0E0h, 0C0h, 80h, 0, 0, 20h, 33h, 3Dh, 21h, 1, 0Dh, 1Dh
    db 0Dh, 5, 4, 1, 3, 0, 89h, 4, 0CCh, 9Ch, 84h, 80h, 0B0h
    db 0B8h, 0B0h, 0A0h, 4, 80h, 4, 0, 2, 7, 5, 3Fh, 2, 1Fh
    db 82h, 0Fh, 3, 5, 0, 81h, 20h, 6, 0FCh, 2, 0F8h, 82h
    db 0F0h, 0C0h, 8, 0, 4, 3, 81h, 1, 0Ah, 0, 81h, 80h, 4
    db 0C0h, 81h, 80h, 6, 0, 9Eh, 0Ch, 1Ch, 34h, 64h, 4Ch
    db 0FCh, 0ECh, 0ECh, 0FCh, 4Ch, 64h, 34h, 1Ch, 0Ch, 0
    db 0, 30h, 38h, 2Ch, 26h, 32h, 3Fh, 37h, 37h, 3Fh, 32h
    db 26h, 2Ch, 38h, 30h, 6, 0, 6, 1, 16h, 0, 9Eh, 6, 0Eh
    db 1Ah, 32h, 26h, 6Eh, 7Ah, 7Ah, 6Eh, 26h, 32h, 1Ah, 0Eh
    db 6, 0, 0, 0C0h, 0E0h, 0B0h, 98h, 0C8h, 0ECh, 0BCh, 0BCh
    db 0ECh, 0C8h, 98h, 0B0h, 0E0h, 0C0h, 7, 0, 84h, 3, 0Fh
    db 0Fh, 3, 0Ah, 0, 88h, 10h, 0F0h, 0D0h, 50h, 50h, 0D0h
    db 0F0h, 10h, 0Ah, 0, 84h, 1, 3, 3, 1, 0Ch, 0, 84h, 80h
    db 0C0h, 0C0h, 80h, 6, 0, 85h, 82h, 0D6h, 0BAh, 0BAh, 7Ch
    db 9, 38h, 81h, 10h, 21h, 0, 85h, 82h, 0D5h, 0BAh, 0BAh
    db 7Ch, 9, 38h, 0C4h, 10h, 0, 0, 40h, 31h, 18h, 0Fh, 16h
    db 0Bh, 7, 3, 0Dh, 33h, 6, 8, 14h, 8, 0, 0, 42h, 4, 9Ch
    db 0B0h, 0F4h, 0B8h, 0F0h, 58h, 0E5h, 60h, 30h, 18h, 88h
    db 4, 42h, 80h, 44h, 32h, 3Fh, 1Eh, 0Bh, 13h, 24h, 1Eh
    db 22h, 44h, 9, 6, 18h, 30h, 40h, 82h, 84h, 0C8h, 5Ch
    db 58h, 30h, 9Ch, 0Fh, 7Ch, 30h, 0DCh, 0C8h, 0D4h, 45h
    db 42h, 1, 0, 80h, 3, 0, 87h, 1, 4, 11h, 2, 0, 1, 8, 8
    db 0, 0ABh, 80h, 4, 0, 40h, 68h, 0C0h, 0, 4, 0, 80h, 0
    db 0, 1, 18h, 30h, 0, 46h, 4, 0C0h, 80h, 4, 0Eh, 6, 42h
    db 0C8h, 60h, 3, 87h, 1, 18h, 0Ch, 44h, 0, 60h, 31h, 3
    db 0, 18h, 30h, 0, 4, 0Ch, 18h, 6, 0, 81h, 0C4h, 5, 4Ah
    db 81h, 44h, 9, 0, 81h, 44h, 5, 0AAh, 81h, 44h, 4, 0, 9Eh
    db 3, 0Fh, 1Fh, 34h, 12h, 0Ah, 5, 0, 0, 2, 5, 6, 0, 1
    db 0, 0, 0C0h, 0F0h, 0F8h, 2Ch, 48h, 50h, 0A0h, 0, 0, 40h
    db 0A0h, 60h, 0, 80h, 9, 0, 82h, 1Bh, 7, 5, 0Fh, 82h, 7
    db 1Eh, 7, 0, 82h, 0D8h, 0E0h, 5, 0F0h, 82h, 0E0h, 78h
    db 3, 0, 8Bh, 4, 1Ah, 12h, 12h, 6, 1Ch, 11h, 15h, 15h
    db 11h, 3Fh, 0Bh, 0, 3, 54h, 82h, 24h, 0DCh, 5, 0, 81h
    db 3Ch, 3, 36h, 2, 3Ch, 5, 3Fh, 0Bh, 0, 5, 0FCh, 6, 0
    db 88h, 8, 0Fh, 0Bh, 0Ah, 0Ah, 0Bh, 0Fh, 8, 0Ah, 0, 84h
    db 0C0h, 0F0h, 0F0h, 0C0h, 0Ah, 0, 88h, 3, 7, 0Dh, 0Bh
    db 0Fh, 0Fh, 7, 3, 8, 0, 82h, 0C0h, 60h, 4, 0F0h, 82h
    db 0E0h, 0C0h, 4, 0, 0
; ---------------------------------------------------------------------------

loc_5334:       ; CODE XREF: update_game+1Bp
    ld  b, 7
    ld  hl, game_unk_E200

loc_5339:       ; CODE XREF: ROM:534Cj
    ld  (game_word_E310), hl
    ld  a, (hl)
    and a
    jr  z, loc_5345
    push  bc
    call  loc_534F
    pop bc

loc_5345:       ; CODE XREF: ROM:533Ej
    ld  hl, (game_word_E310)
    ld  de, 10h
    add hl, de
    djnz  loc_5339
    ret
; ---------------------------------------------------------------------------

loc_534F:       ; CODE XREF: ROM:5341p
    inc l
    ld  a, (hl)
    ld  de, off_535F
    add a, a
    call  add_a_to_de ; DE=DE+A
    ex  de, hl
    ld  c, (hl)
    inc hl
    ld  b, (hl)
    ex  de, hl
    push  bc
    ret
; ---------------------------------------------------------------------------
off_535F: dw loc_5389   ; DATA XREF: ROM:5351o
    dw loc_5390
    dw loc_53E2
    dw loc_5441
    dw loc_5423
    dw loc_5461
    dw loc_5465
    dw locret_5504
    dw loc_5505
    dw loc_5505
    dw loc_5594
    dw loc_5594
    dw loc_5599
    dw loc_5599
    dw loc_55C7
    dw loc_55C7
    dw loc_5612
    dw loc_5669
    dw locret_5504
    dw loc_56B1
    dw loc_57E1
; ---------------------------------------------------------------------------

loc_5389:       ; DATA XREF: ROM:off_535Fo
    ld  b, 0
    ld  de, byte_53CA
    jr  loc_5395
; ---------------------------------------------------------------------------

loc_5390:       ; DATA XREF: ROM:5361o
    ld  b, 0FFh
    ld  de, byte_53D6

loc_5395:       ; CODE XREF: ROM:538Ej
    inc l
    inc (hl)
    ld  a, (hl)
    cp  10h
    ret c
    dec l

loc_539C:       ; CODE XREF: ROM:5434j
    ld  a, 0Ah
    add a, l
    ld  l, a
    ld  a, (player_spr_attr+1)
    sub (hl)
    jr  nc, loc_53A8
    neg

loc_53A8:       ; CODE XREF: ROM:53A4j
    rra
    rra
    rra
    rra
    and 0Fh
    call  add_a_to_de ; DE=DE+A
    ex  de, hl
    ld  c, (hl)
    ex  de, hl
    ld  a, 0FBh ; ''
    add a, l
    ld  l, a

loc_53B8:       ; CODE XREF: ROM:543Ej
    ld  a, (hl)
    add a, c
    ld  (hl), a
    ld  c, a
    inc l
    ld  a, (hl)
    adc a, b
    ld  b, a
    rl  c
    adc a, a
    add a, 5
    cp  0Ah
    ret nc
    ld  (hl), b
    ret
; ---------------------------------------------------------------------------
byte_53CA:  db 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6 ; DATA XREF: ROM:538Bo
byte_53D6:  db 0FFh, 0FFh, 0FEh, 0FEh, 0FDh, 0FDh, 0FCh, 0FCh, 0FBh
          ; DATA XREF: ROM:5392o
    db 0FBh, 0FAh, 0FAh
; ---------------------------------------------------------------------------

loc_53E2:       ; DATA XREF: ROM:5363o
    ld  a, 0Ah
    add a, l
    ld  l, a
    ld  a, (player_spr_attr+1)
    sub (hl)
    ld  bc, 80h ; ''
    jr  nc, loc_53F2
    ld  bc, -128

loc_53F2:       ; CODE XREF: ROM:53EDj
    dec l
    dec l
    dec l
    dec l
    add a, 0Ah
    cp  14h
    jr  c, loc_540A
    ld  (hl), b
    dec l
    ld  (hl), c
    ld  a, 6
    add a, l
    ld  l, a
    ld  c, 10h
    ld  b, 84h ; ''
    jp  loc_54B2
; ---------------------------------------------------------------------------

loc_540A:       ; CODE XREF: ROM:53FAj
    xor a
    ld  (hl), a
    dec l
    ld  (hl), a
    dec l
    ld  (hl), 3
    dec l
    ld  (hl), a
    dec l
    dec l
    dec l
    ld  (hl), 12h
    ld  a, 0Bh
    add a, l
    ld  l, a
    ld  (hl), 10h
    inc hl
    inc hl
    ld  (hl), 14h
    ret
; ---------------------------------------------------------------------------

loc_5423:       ; DATA XREF: ROM:5367o
    ld  bc, -244
    ld  de, byte_5449

loc_5429:       ; CODE XREF: ROM:5447j
    inc l
    inc (hl)
    ld  a, (hl)
    cp  8
    ret c
    cp  40h ; '@'
    jr  nc, loc_5437
    dec l
    jp  loc_539C
; ---------------------------------------------------------------------------

loc_5437:       ; CODE XREF: ROM:5431j
    ld  a, b
    cpl
    ld  b, a
    inc l
    inc l
    inc l
    inc l
    jp  loc_53B8
; ---------------------------------------------------------------------------

loc_5441:       ; DATA XREF: ROM:5365o
    ld  de, byte_5455
    ld  bc, 0F4h ; ''
    jr  loc_5429
; ---------------------------------------------------------------------------
byte_5449:  db 0FEh, 0FCh, 0FAh, 0F8h, 0F6h, 0F4h, 0F2h, 0F0h, 0EEh
          ; DATA XREF: ROM:5426o
    db 0EEh, 0EEh, 0EEh
byte_5455:  db 2, 4, 6, 8, 0Ah, 0Ch, 0Eh, 10h, 12h, 12h, 12h, 12h
          ; DATA XREF: ROM:loc_5441o
; ---------------------------------------------------------------------------

loc_5461:       ; DATA XREF: ROM:5369o
    ld  c, 0
    jr  loc_5467
; ---------------------------------------------------------------------------

loc_5465:       ; DATA XREF: ROM:536Bo
    ld  c, 6

loc_5467:       ; CODE XREF: ROM:5463j
    ld  b, 8
    ld  a, (game_byte_E140)
    cp  2
    jr  nz, loc_5474
    ld  b, 6
    set 3, c

loc_5474:       ; CODE XREF: ROM:546Ej
    inc l
    ld  a, (frame_count)
    and 0Fh
    jr  nz, loc_547D
    inc (hl)

loc_547D:       ; CODE XREF: ROM:547Aj
    ld  a, (hl)
    sub b
    cp  0Eh
    jr  nc, loc_54A7
    ld  b, a
    ld  a, c
    dec a
    cp  0Dh
    ld  a, b
    jr  nc, loc_548D
    neg

loc_548D:       ; CODE XREF: ROM:5489j
    add a, c
    and 0Fh
    add a, a
    add a, a
    ld  de, byte_54C4
    call  add_a_to_de ; DE=DE+A
    ld  b, 2
    inc l

loc_549B:       ; CODE XREF: ROM:54A5j
    inc l
    ld  a, (de)
    add a, (hl)
    ld  (hl), a
    inc l
    inc de
    ld  a, (de)
    adc a, (hl)
    ld  (hl), a
    inc de
    djnz  loc_549B

loc_54A7:       ; CODE XREF: ROM:5481j
    ld  hl, (game_word_E310)
    ld  de, 0Ch
    add hl, de
    ld  c, 30h ; '0'
    ld  b, 3

loc_54B2:       ; CODE XREF: ROM:5407j
    ld  a, (frame_count)
    and 6
    add a, a
    add a, a
    add a, c
    ld  (hl), a
    inc l
    inc l
    add a, 4
    ld  (hl), a
    ld  a, b
    jp  loc_560A
; ---------------------------------------------------------------------------
byte_54C4:  db 0FEh, 0FFh, 5, 0, 0FCh, 0FFh, 4, 0, 0FBh, 0FFh, 2, 0
          ; DATA XREF: ROM:5492o
    db 0FAh, 0FFh, 0, 0, 0FBh, 0FFh, 0FEh, 0FFh, 0FCh, 0FFh
    db 0FCh, 0FFh, 0FEh, 0FFh, 0FBh, 0FFh, 0, 0, 0FAh, 0FFh
    db 2, 0, 0FBh, 0FFh, 4, 0, 0FCh, 0FFh, 5, 0, 0FEh, 0FFh
    db 6, 0, 0, 0, 5, 0, 2, 0, 4, 0, 4, 0, 2, 0, 5, 0, 0, 0
    db 6, 0
; ---------------------------------------------------------------------------

locret_5504:        ; DATA XREF: ROM:536Do  ROM:5383o
    ret
; ---------------------------------------------------------------------------

loc_5505:       ; DATA XREF: ROM:536Fo  ROM:5371o
    ld  a, 5
    call  get_hl_a_ptr  ; DE=(HL+A)
    inc l
    inc l
    inc l
    inc l
    ld  a, (hl)
    cp  10h
    jr  nc, loc_5516
    ld  de, 0A0h ; ''

loc_5516:       ; CODE XREF: ROM:5511j
    cp  0A0h ; ''
    jr  c, loc_551D
    ld  de, 0FF60h

loc_551D:       ; CODE XREF: ROM:5518j
    dec l
    dec l
    dec l
    dec l
    ld  (hl), d
    dec l
    ld  (hl), e
    ld  de, 6
    add hl, de
    ld  a, (frame_count)
    bit 3, a
    ld  de, byte_5C58
    jr  nz, loc_5535
    ld  de, byte_6460

loc_5535:       ; CODE XREF: ROM:5530j
    ld  (hl), e
    inc l
    inc l
    ld  (hl), d
    ld  de, -12
    add hl, de
    ld  a, (hl)
    ld  c, a
    and 0Ch
    ld  a, 47h ; 'G'
    jp  z, loc_560A
    ld  a, l
    rra
    rra
    rra
    rra
    and 0Fh
    exx
    ld  hl, game_unk_E1C6
    call  add_a_to_hl ; HL=HL+A
    dec (hl)
    ld  a, (hl)
    exx
    ld  de, 0Ah
    add hl, de
    cp  8
    ld  de, 694h
    jr  nc, loc_5565
    ld  de, 0FA0h

loc_5565:       ; CODE XREF: ROM:5560j
    bit 2, c
    jr  z, loc_556D
    ld  (hl), e
    inc l
    ld  (hl), d
    dec l

loc_556D:       ; CODE XREF: ROM:5567j
    inc l
    inc l
    bit 3, c
    jr  z, loc_5577
    ld  (hl), e
    inc l
    ld  (hl), d
    dec l

loc_5577:       ; CODE XREF: ROM:5571j
    inc l
    and a
    ret nz
    bit 3, c
    jr  z, loc_5580
    ld  (hl), 0

loc_5580:       ; CODE XREF: ROM:557Cj
    dec l
    dec l
    bit 2, c
    jr  z, loc_5588
    ld  (hl), 0

loc_5588:       ; CODE XREF: ROM:5584j
    ld  a, 3
    and c
    jp  z, game_sub_6D36
    ld  de, -11
    add hl, de
    ld  (hl), a
    ret
; ---------------------------------------------------------------------------

loc_5594:       ; DATA XREF: ROM:5373o  ROM:5375o
    ld  a, 81h ; ''
    jp  loc_560A
; ---------------------------------------------------------------------------

loc_5599:       ; DATA XREF: ROM:5377o  ROM:5379o
    ld  a, (frame_count)
    bit 0, a
    ld  c, 0
    jr  nz, loc_55A3
    dec c

loc_55A3:       ; CODE XREF: ROM:55A0j
    ld  a, 8
    add a, l
    ld  l, a
    ld  a, (hl)
    sub 28h ; '('
    sub 38h ; '8'
    jr  nc, loc_55B0
    ld  c, 0

loc_55B0:       ; CODE XREF: ROM:55ACj
    sub 18h
    sub 88h ; ''
    jr  nc, loc_55B8
    ld  c, 0FFh

loc_55B8:       ; CODE XREF: ROM:55B4j
    ld  a, 4
    add a, l
    ld  l, a
    ld  a, 1
    and c
    ld  (hl), a
    inc l
    inc l
    ld  a, 0Fh
    and c
    ld  (hl), a
    ret
; ---------------------------------------------------------------------------

loc_55C7:       ; DATA XREF: ROM:537Bo  ROM:537Do
    ld  a, (frame_count)
    and 3
    ret nz
    ld  e, a
    inc l
    ld  a, (hl)
    inc (hl)
    ex  de, hl
    rra
    rra
    rra
    rra
    rra
    and 0Eh
    ld  hl, off_55FC
    call  add_a_to_hl ; HL=HL+A
    ld  c, (hl)
    inc hl
    ld  b, (hl)
    ld  a, (game_byte_E321)
    cp  9
    jr  z, loc_55EC
    ld  bc, byte_7C80

loc_55EC:       ; CODE XREF: ROM:55E7j
    ex  de, hl
    inc l
    inc l
    ld  (hl), c
    ld  a, 8
    add a, l
    ld  l, a
    ld  (hl), b
    inc l
    inc l
    ld  a, b
    add a, 4
    ld  (hl), a
    ret
; ---------------------------------------------------------------------------
off_55FC: dw byte_7C80    ; DATA XREF: ROM:55D9o
    dw byte_7400
    dw byte_7C80
    dw byte_7400
; ---------------------------------------------------------------------------

loc_5604:       ; CODE XREF: ROM:5617j
    ld  a, b
    cp  3
    ret nz
    ld  a, 85h ; ''

loc_560A:       ; CODE XREF: ROM:54C1j  ROM:5543j ...
    ld  hl, music_channel2
    cp  (hl)
    ret z
    jp  game_sub_79D8
; ---------------------------------------------------------------------------

loc_5612:       ; DATA XREF: ROM:537Fo
    inc l
    ld  a, (hl)
    ld  b, a
    and 0Ch
    jr  z, loc_5604
    ld  de, 0Ah
    add hl, de
    ex  de, hl
    ld  a, e
    rra
    rra
    rra
    rra
    and 0Fh
    ld  hl, game_unk_E1C6
    call  add_a_to_hl ; HL=HL+A
    dec (hl)
    ld  a, (hl)
    ex  de, hl
    push  af
    cp  8
    ld  c, 98h ; ''
    jr  nc, loc_5637
    ld  c, 0A0h ; ''

loc_5637:       ; CODE XREF: ROM:5633j
    bit 2, b
    jr  z, loc_5640
    ld  (hl), c
    inc hl
    ld  (hl), 0Fh
    dec hl

loc_5640:       ; CODE XREF: ROM:5639j
    inc hl
    inc hl
    bit 3, b
    jr  z, loc_564B
    ld  (hl), c
    inc hl
    ld  (hl), 0Fh
    dec hl

loc_564B:       ; CODE XREF: ROM:5644j
    pop af
    and a
    ret nz
    inc hl
    bit 3, b
    jr  z, loc_5655
    ld  (hl), 0

loc_5655:       ; CODE XREF: ROM:5651j
    dec hl
    dec hl
    bit 2, b
    jr  z, loc_565D
    ld  (hl), 0

loc_565D:       ; CODE XREF: ROM:5659j
    ld  a, b
    and 3
    jp  z, game_sub_6D36
    ld  de, -11
    add hl, de
    ld  (hl), a
    ret
; ---------------------------------------------------------------------------

loc_5669:       ; DATA XREF: ROM:5381o
    dec hl
    push  hl
    pop ix
    inc l
    inc l
    inc (hl)
    ld  a, (hl)
    cp  40h ; '@'
    ret nz
    dec l
    ld  (hl), 13h
    ld  a, (player_spr_attr+1)
    sub (ix+0Bh)
    ld  bc, 140h
    jr  nc, loc_5685
    ld  bc, 0FEC0h

loc_5685:       ; CODE XREF: ROM:5680j
    inc l
    ld  (hl), 1
    inc l
    ld  e, (ix+9)
    ld  (hl), e
    inc l
    ld  (hl), c
    inc l
    ld  (hl), b
    inc l
    inc l
    ld  d, (ix+0Bh)
    ld  a, 8
    add a, d
    ld  (hl), a
    inc l
    ld  (hl), 8Ch ; ''
    inc l
    ld  (hl), 0Bh
    inc l
    ld  a, (game_byte_E1B7)
    ld  (hl), a
    inc l
    ld  (hl), 0Bh
    inc l
    ld  (hl), e
    inc l
    ld  (hl), d
    ld  a, 6
    jp  game_sub_79D8
; ---------------------------------------------------------------------------

loc_56B1:       ; DATA XREF: ROM:5385o
    ld  de,  player_spr_attr+1
    push  de
    call  game_sub_56D4
    pop de
    call  game_sub_576E
    ld  hl, (game_word_E310)
    xor a
    inc l
    inc l
    or  (hl)
    ld  de, 9
    add hl, de
    or  (hl)
    ret nz
    ld  de, -11
    add hl, de
    ld  (hl), 0
    ld  hl, game_byte_E194
    dec (hl)
    ret

; =============== S U B R O U T I N E =======================================


game_sub_56D4:        ; CODE XREF: ROM:56B5p
    inc l
    ld  a, (hl)
    and a
    ret z
    exx
    ld  b, a
    exx
    inc l
    inc (hl)
    inc (hl)
    ld  a, (hl)
    cp  0C0h ; ''
    exx
    ld  c, 0
    jr  c, loc_56E8
    ld  c, 1

loc_56E8:       ; CODE XREF: game_sub_56D4+10j
    exx
    inc l
    inc l
    inc l
    inc l
    ld  a, (de)
    ld  bc, 0Ah
    sub (hl)
    jr  nc, loc_56F7
    ld  bc, -10

loc_56F7:       ; CODE XREF: game_sub_56D4+1Ej
    dec l
    dec l
    dec l
    ld  a, c
    add a, (hl)
    ld  (hl), a
    ld  c, a
    inc l
    ld  a, b
    adc a, (hl)
    ld  b, (hl)
    add a, 4
    cp  8
    jr  nc, loc_570C
    sub 4
    ld  b, a
    ld  (hl), a

loc_570C:       ; CODE XREF: game_sub_56D4+32j
    inc l
    ld  a, c
    add a, (hl)
    ld  (hl), a
    inc l
    ld  a, b
    adc a, (hl)
    ld  (hl), a
    sub 8
    inc l
    inc l
    cp  0A8h ; ''
    ld  a, 0Bh
    jr  c, loc_571F
    xor a

loc_571F:       ; CODE XREF: game_sub_56D4+48j
    ld  (hl), a
    ex  af, af'
    dec l
    dec l
    exx
    ld  a, b
    exx
    cp  2
    jr  nz, loc_5755
    ld  a, l
    ex  de, hl
    rra
    rra
    rra
    rra
    and 0Fh
    ld  hl, game_unk_E1C6
    call  add_a_to_hl ; HL=HL+A
    dec (hl)
    jr  nz, loc_5741
    exx
    ld  c, 1
    exx
    ld  (hl), 1

loc_5741:       ; CODE XREF: game_sub_56D4+65j
    ld  a, (hl)
    cp  8
    ld  c, 98h ; ''
    jr  nc, loc_574A
    ld  c, 0A0h ; ''

loc_574A:       ; CODE XREF: game_sub_56D4+72j
    ex  de, hl
    inc l
    ld  (hl), c
    inc l
    ex  af, af'
    and a
    jr  z, loc_5754
    ld  a, 0Fh

loc_5754:       ; CODE XREF: game_sub_56D4+7Cj
    ld  (hl), a

loc_5755:       ; CODE XREF: game_sub_56D4+54j
    exx
    ld  a, c
    exx
    and a
    ret z
    ld  hl, (game_word_E310)
    inc l
    inc l
    ld  (hl), 0
    ld  a, l
    and 0F0h ; ''
    rra
    ld  hl, game_unk_E0D4
    call  add_a_to_hl ; HL=HL+A
    ld  (hl), 0C3h ; ''
    ret
; End of function game_sub_56D4


; =============== S U B R O U T I N E =======================================


game_sub_576E:        ; CODE XREF: ROM:56B9p
    ld  hl, (game_word_E310)
    ld  a, 0Bh
    add a, l
    ld  l, a
    ld  a, (hl)
    and a
    ret z
    exx
    ld  c, 0
    ld  b, a
    exx
    inc l
    inc (hl)
    inc (hl)
    ld  a, (hl)
    cp  0C0h ; ''
    jr  c, loc_5789
    exx
    ld  c, 1
    exx

loc_5789:       ; CODE XREF: game_sub_576E+15j
    inc l
    ld  a, (frame_count)
    rra
    jr  c, loc_579A
    ld  a, (de)
    sub (hl)
    ld  a, 1
    jr  nc, loc_5798
    ld  a, 0FFh

loc_5798:       ; CODE XREF: game_sub_576E+26j
    add a, (hl)
    ld  (hl), a

loc_579A:       ; CODE XREF: game_sub_576E+20j
    exx
    ld  a, b
    cp  2
    exx
    jr  nz, loc_57C7
    inc l
    ld  a, l
    ex  de, hl
    rra
    rra
    rra
    rra
    and 0Fh
    ld  hl, game_unk_E1C6
    call  add_a_to_hl ; HL=HL+A
    dec (hl)
    jr  nz, loc_57B9
    exx
    ld  c, 1
    exx
    ld  (hl), 1

loc_57B9:       ; CODE XREF: game_sub_576E+43j
    ld  a, (hl)
    cp  8
    ld  c, 98h ; ''
    jr  nc, loc_57C2
    ld  c, 0A0h ; ''

loc_57C2:       ; CODE XREF: game_sub_576E+50j
    ex  de, hl
    ld  (hl), c
    inc l
    ld  (hl), 0Fh

loc_57C7:       ; CODE XREF: game_sub_576E+31j
    exx
    ld  a, c
    and a
    ret z
    ld  hl, (game_word_E310)
    ld  de, 0Bh
    add hl, de
    ld  (hl), 0
    ld  a, l
    and 0F0h ; ''
    rra
    ld  hl, game_unk_E0D8
    call  add_a_to_hl ; HL=HL+A
    ld  (hl), 0C3h ; ''
    ret
; ---------------------------------------------------------------------------

loc_57E1:       ; DATA XREF: ROM:5387o
    ld  a, l
    exx
    rra
    rra
    rra
    rra
    and 0Fh
    ld  hl, game_unk_E1C6
    call  add_a_to_hl ; HL=HL+A
    dec (hl)
    jp  z, game_sub_6D36
    ld  a, (hl)
    exx
    dec l
    ld  c, (hl)
    ld  de, 9
    add hl, de
    cp  8
    ld  de, 9894h
    jr  nc, loc_5805
    ld  de, 0A09Ch

loc_5805:       ; CODE XREF: game_sub_576E+92j
    ld  a, c
    sub 10h
    jr  c, loc_5812
    ld  de, 0FCFCh
    jr  nz, loc_5812
    ld  de, 0A4FCh

loc_5812:       ; CODE XREF: game_sub_576E+9Aj
          ; game_sub_576E+9Fj
    ld  a, 3
    add a, l
    ld  l, a
    ld  (hl), e
    inc hl
    ld  (hl), 6
    inc hl
    ld  (hl), d
    inc hl
    ld  (hl), 0Fh
    ret
; End of function game_sub_576E


; =============== S U B R O U T I N E =======================================


game_sub_5820:        ; CODE XREF: game_sub_5837+16p
          ; game_sub_5837+35p
    push  hl
    push  de
    ld  hl, game_unk_E051
    ld  a, (hl)
    add a, 1
    daa
    ld  (hl), a
    call  loc_42E3
    pop de
    pop hl
    ret
; End of function game_sub_5820

; ---------------------------------------------------------------------------
; START OF FUNCTION CHUNK FOR game_sub_45A6

loc_5830:       ; CODE XREF: game_sub_45A6+7Cj
    ld  de, (game_word_E1B8)
    ld  a, e
    jr  loc_5881
; END OF FUNCTION CHUNK FOR game_sub_45A6

; =============== S U B R O U T I N E =======================================


game_sub_5837:        ; CODE XREF: update_game+12p
    ld  a, (game_byte_E140)
    and 3
    cp  2
    ret z
    ld  a, (frame_count)
    and 0Fh
    ret nz
    ld  hl,  game_word_E1B8+1
    ld  d, (hl)
    dec hl
    ld  e, (hl)
    ld  a, e
    inc a
    call  z, game_sub_5820
    inc de
    ex  de, hl
    ld  bc, 780h
    and a
    push  hl
    sbc hl, bc
    pop hl
    jr  c, loc_586F
    ld  hl, 0
    ld  a, (game_byte_E1D3)
    inc a
    cp  2
    jr  c, loc_5869
    ld  a, 2

loc_5869:       ; CODE XREF: game_sub_5837+2Ej
    ld  (game_byte_E1D3), a
    call  game_sub_5820

loc_586F:       ; CODE XREF: game_sub_5837+23j
    ex  de, hl
    ld  (hl), e
    inc hl
    ld  (hl), d
    inc hl
    ld  a, (hl)
    add a, 2
    cp  10h
    jr  c, loc_587C
    xor a

loc_587C:       ; CODE XREF: game_sub_5837+42j
    ld  (hl), a
    dec hl
    ld  d, (hl)
    dec hl
    ld  a, (hl)

loc_5881:       ; CODE XREF: game_sub_45A6+128Fj
    srl d
    rra
    srl d
    rra
    srl d
    rra
    ld  (game_byte_E1D1), a
    ld  e, a
    ld  hl, byte_58FF
    add hl, de
    ld  de, game_word_E1BE
    ld  (game_word_E310), de
    ld  b, 4

loc_589B:       ; CODE XREF: game_sub_5837+68j
    ld  a, (hl)
    ld  (de), a
    inc hl
    dec de
    djnz  loc_589B
    call  game_sub_58EE
    exx
    ld  b, 18h
    exx
    ld  a, (game_byte_E1BA)
    call  get_hl_a_ptr  ; DE=(HL+A)
    ld  hl, 3AE1h
    ld  a, (VDP_RD)
    ld  c, a

loc_58B5:       ; CODE XREF: game_sub_5837+A8j
          ; game_sub_5837+ABj
    call  vdp_set_write

loc_58B8:       ; CODE XREF: game_sub_5837+93j
          ; game_sub_5837+9Ej
    ld  a, (de)
    inc de
    ld  b, a
    and a
    jp  p, loc_58CC
    inc a
    jr  z, loc_58E4
    res 7, b

loc_58C4:       ; CODE XREF: game_sub_5837+91j
    ld  a, (de)
    out (c), a
    inc de
    djnz  loc_58C4
    jr  loc_58B8
; ---------------------------------------------------------------------------

loc_58CC:       ; CODE XREF: game_sub_5837+85j
    jr  z, loc_58D7
    ld  a, (de)
    inc de

loc_58D0:       ; CODE XREF: game_sub_5837+9Cj
    out (c), a
    nop
    djnz  loc_58D0
    jr  loc_58B8
; ---------------------------------------------------------------------------

loc_58D7:       ; CODE XREF: game_sub_5837:loc_58CCj
          ; game_sub_5837+B5j
    exx
    dec b
    ret z
    exx
    ld  a, l
    sub 20h ; ' '
    ld  l, a
    jr  nc, loc_58B5
    dec h
    jr  loc_58B5
; ---------------------------------------------------------------------------

loc_58E4:       ; CODE XREF: game_sub_5837+89j
    push  hl
    call  game_sub_58EE
    ld  e, (hl)
    inc hl
    ld  d, (hl)
    pop hl
    jr  loc_58D7
; End of function game_sub_5837


; =============== S U B R O U T I N E =======================================


game_sub_58EE:        ; CODE XREF: game_sub_5837+6Ap
          ; game_sub_5837+AEp
    ld  hl, (game_word_E310)
    ld  a, (hl)
    dec hl
    ld  (game_word_E310), hl
    add a, a
    ld  hl, byte_59F3
    call  get_hl_a_ptr  ; DE=(HL+A)
    ex  de, hl
    ret
; End of function game_sub_58EE

; ---------------------------------------------------------------------------
byte_58FF:  db 11h, 0Dh, 0Ch, 9, 9, 0Ah, 9, 9, 0Ah, 9, 0Ah, 9, 0Ah
          ; DATA XREF: game_sub_5837+57o
    db 9, 9, 0Ah, 9, 0Ah, 9, 9, 0Ah, 9, 0Ah, 9, 9, 0Ah, 9
    db 0Ah, 9, 9, 0Bh, 3, 5, 4, 3, 5, 4, 3, 4, 5, 4, 3, 5
    db 4, 3, 5, 4, 3, 4, 3, 5, 4, 3, 5, 4, 3, 4, 3, 5, 4, 3
    db 4, 5, 0Eh, 11h, 11h, 11h, 11h, 11h, 11h, 11h, 11h, 11h
    db 11h, 12h, 11h, 11h, 11h, 11h, 11h, 0Dh, 0Ch, 9, 0Ah
    db 9, 9, 0Ah, 9, 0Ah, 9, 9, 0Ah, 9, 0Ah, 9, 9, 0Ah, 9
    db 0Ah, 9, 9, 0Ah, 9, 9, 0Ah, 9, 0Ah, 9, 9, 0Ah, 9, 0Ah
    db 9, 9, 0Ah, 9, 0Ah, 9, 0Bh, 0Fh, 11h, 11h, 11h, 11h
    db 11h, 11h, 11h, 11h, 11h, 11h, 11h, 11h, 11h, 11h, 11h
    db 11h, 11h, 6, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7
    db 8, 7, 8, 7, 8, 7, 8, 10h, 11h, 11h, 11h
byte_59A1:  db 11h, 11h, 11h, 11h, 11h, 11h, 11h, 11h, 11h, 11h, 11h
    db 11h, 11h, 11h, 11h, 11h, 11h, 11h, 11h, 11h, 11h, 11h
    db 11h, 11h, 11h, 11h, 11h, 11h, 11h, 11h, 0, 1, 1, 1
    db 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
    db 1, 1, 1, 1, 1, 1, 1, 2, 11h, 11h, 11h, 11h, 11h, 11h
    db 11h, 11h, 11h, 11h, 11h, 11h, 13h, 11h, 11h, 11h, 11h
    db 11h, 11h, 0Dh, 0Ch, 9
byte_59F3:  db 1Bh, 5Ah, 2Bh, 5Ah, 3Bh, 5Ah, 4Bh, 5Ah, 5Bh, 5Ah, 6Bh
          ; DATA XREF: game_sub_58EE+9o
    db 5Ah, 7Bh, 5Ah, 8Bh, 5Ah, 9Bh, 5Ah, 0ABh, 5Ah, 0BBh
    db 5Ah, 0CBh, 5Ah, 0DBh, 5Ah, 0EBh, 5Ah, 0FBh, 5Ah, 0Bh
    db 5Bh, 1Bh, 5Bh, 2Bh, 5Bh, 3Bh, 5Bh, 4Bh, 5Bh, 5Bh, 5Bh
    db 69h, 5Bh, 74h, 5Bh, 87h, 5Bh, 98h, 5Bh, 0B0h, 5Bh, 0C6h
    db 5Bh, 0DFh, 5Bh, 0F8h, 5Bh, 11h, 5Ch, 2Ah, 5Ch, 43h
    db 5Ch, 5Ch, 5Ch, 75h, 5Ch, 8Eh, 5Ch, 0A7h, 5Ch, 0C0h
    db 5Ch, 0D9h, 5Ch, 0F2h, 5Ch, 0Bh, 5Dh, 24h, 5Dh, 3Dh
    db 5Dh, 4Ah, 5Dh, 54h, 5Dh, 57h, 5Dh, 65h, 5Dh, 73h, 5Dh
    db 87h, 5Dh, 96h, 5Dh, 0A3h, 5Dh, 0B0h, 5Dh, 0C1h, 5Dh
    db 0D2h, 5Dh, 0DFh, 5Dh, 0EDh, 5Dh, 0FCh, 5Dh, 9, 5Eh
    db 1Bh, 5Eh, 2Ch, 5Eh, 39h, 5Eh, 49h, 5Eh, 57h, 5Eh, 67h
    db 5Eh, 77h, 5Eh, 8Ch, 5Eh, 9Dh, 5Eh, 0B0h, 5Eh, 0C0h
    db 5Eh, 0CFh, 5Eh, 0D6h, 5Eh, 0DDh, 5Eh, 0ECh, 5Eh, 0FFh
    db 5Eh, 0Ch, 5Fh, 21h, 5Fh, 30h, 5Fh, 45h, 5Fh, 57h, 5Fh
    db 6Ch, 5Fh, 78h, 5Fh, 89h, 5Fh, 99h, 5Fh, 0A5h, 5Fh, 0AFh
    db 5Fh, 0BAh, 5Fh, 0C5h, 5Fh, 0DEh, 5Fh, 0EFh, 5Fh, 6
    db 60h, 1Ah, 60h, 31h, 60h, 3Fh, 60h, 42h, 60h, 50h, 60h
    db 69h, 60h, 82h, 60h, 9Bh, 60h, 0B4h, 60h, 0CDh, 60h
    db 0E6h, 60h, 0FFh, 60h, 0Fh, 61h, 28h, 61h, 41h, 61h
    db 5Ah, 61h, 73h, 61h, 8Ch, 61h, 0A5h, 61h, 0BAh, 61h
    db 0C5h, 61h, 0DEh, 61h, 0F7h, 61h, 0Dh, 62h, 24h, 62h
    db 3Dh, 62h, 52h, 62h, 5Dh, 62h, 64h, 62h, 6Bh, 62h, 73h
    db 62h, 80h, 62h, 94h, 62h, 0A9h, 62h, 0BFh, 62h, 0D8h
    db 62h, 0E1h, 62h, 0ECh, 62h, 0F6h, 62h, 1, 63h, 0Fh, 63h
    db 1Ch, 63h, 28h, 63h, 2Dh, 63h, 3Fh, 63h, 4Fh, 63h, 63h
    db 63h, 75h, 63h, 8Ah, 63h, 9Dh, 63h, 0A7h, 63h, 0AFh
    db 63h, 0B2h, 63h, 0B5h, 63h, 0B8h, 63h, 0C3h, 63h, 0CCh
    db 63h, 0D9h, 63h, 0DCh, 63h, 0DFh, 63h, 0E6h, 63h, 0F5h
    db 63h, 0FCh, 63h, 0Bh, 64h, 14h, 64h, 21h, 64h, 24h, 64h
    db 27h, 64h, 32h, 64h, 40h, 64h, 4Bh, 64h, 57h, 64h, 64h
    db 64h, 6Eh, 64h, 79h, 64h, 89h, 64h, 96h, 64h, 0AFh, 64h
    db 0C2h, 64h, 0D8h, 64h, 0F0h, 64h, 3, 65h, 14h, 65h, 27h
    db 65h, 3Bh, 65h, 54h, 65h, 6Dh, 65h, 86h, 65h, 9Fh, 65h
    db 0B8h, 65h, 0D1h, 65h, 82h, 0Bh, 4Ch, 4, 5, 83h, 4Ah
    db 0Bh, 4Ch, 0Dh, 5, 1, 4Ah, 0, 0Ch, 0Bh, 81h, 4Ch, 5
    db 5, 81h, 4Ah, 4, 0Bh, 0, 5, 0Bh, 83h, 46h, 0Ch, 48h
    db 5, 0Bh, 84h, 4Ch, 5, 5, 4Ah, 4, 0Bh, 82h, 46h, 0Ch
    db 0, 4, 0Bh, 86h, 46h, 0Ch, 43h, 45h, 0Ch, 48h, 9, 0Bh
    db 84h, 46h, 0Ch, 44h, 45h, 0, 8Eh, 0Bh, 0Bh, 46h, 0Ch
    db 42h, 41h, 45h, 40h, 0Ch, 42h, 41h, 43h, 0Ch, 48h, 4
    db 0Bh, 85h, 46h, 0Ch, 45h, 41h, 42h, 0, 8Dh, 0Bh, 0Bh
    db 0Ch, 44h, 45h, 43h, 40h, 44h, 45h, 41h, 44h, 45h, 41h
    db 6, 0Ch, 84h, 43h, 41h, 45h, 41h, 0, 97h, 0Bh, 46h, 0Ch
    db 45h, 0Ch, 45h, 42h, 44h, 45h, 41h, 45h, 40h, 0Ch, 40h
    db 0Ch, 44h, 43h, 41h, 0Ch, 40h, 0Ch, 40h, 42h, 0, 97h
    db 46h, 0Ch, 42h, 43h, 44h, 0Ch, 41h, 40h, 40h, 45h, 41h
    db 44h, 45h, 41h, 41h, 43h, 40h, 45h, 41h, 45h, 41h, 45h
    db 41h, 0FFh, 97h, 41h, 43h, 41h, 43h, 45h, 40h, 43h, 40h
    db 45h, 40h, 0Ch, 40h, 40h, 45h, 40h, 42h, 45h, 40h, 40h
    db 45h, 40h, 42h, 41h, 0, 97h, 0Ch, 44h, 43h, 40h, 40h
    db 41h, 44h, 43h, 41h, 41h, 45h, 41h, 41h, 44h, 43h, 44h
    db 42h, 44h, 41h, 43h, 41h, 44h, 45h, 0
byte_5C2A:  db 97h, 40h, 45h, 40h, 41h, 41h, 44h, 43h, 45h, 40h, 41h
    db 40h, 42h, 44h, 43h, 45h, 44h, 0Ch, 42h, 45h, 41h, 44h
    db 45h, 41h, 0, 97h, 41h, 41h, 40h, 43h, 42h, 41h, 45h
    db 0Ch, 41h, 45h, 41h, 44h, 43h, 45h, 42h, 44h, 45h, 41h
    db 43h, 45h
byte_5C58:  db 41h, 45h, 42h, 0, 97h, 40h, 0Ch, 43h, 41h, 44h, 45h
          ; DATA XREF: ROM:552Do
    db 41h, 45h, 40h, 41h, 44h, 45h, 40h, 41h, 45h, 41h, 45h
    db 40h, 45h, 41h, 45h, 41h, 44h, 0, 97h, 45h, 40h, 45h
    db 43h, 44h, 0Ch, 42h, 45h, 41h, 44h, 41h, 45h, 40h, 42h
    db 0Ch, 45h, 41h, 44h, 41h, 40h, 40h, 42h, 42h, 0, 97h
    db 41h, 45h, 0Ch, 42h, 44h, 45h, 41h, 43h, 45h, 41h, 45h
    db 41h, 45h, 40h, 0Ch, 40h, 42h, 41h, 0Ch, 43h, 41h, 41h
    db 40h, 0, 97h, 0Ch, 40h, 41h, 45h, 41h, 45h, 40h, 45h
    db 41h, 45h, 40h, 42h, 41h, 45h, 45h, 41h, 41h, 44h, 45h
    db 44h, 45h, 41h, 45h, 0FFh, 97h, 0Bh, 47h, 40h, 41h, 45h
    db 41h, 44h, 41h, 40h, 40h, 45h, 42h, 44h, 0Ch, 42h, 45h
    db 41h, 42h, 45h, 44h, 0Ch, 42h, 45h, 0, 97h, 4Bh, 0Bh
    db 0Ch, 40h, 40h, 42h, 41h, 0Ch, 43h, 41h, 45h, 41h, 44h
    db 45h, 41h, 43h, 40h, 45h, 41h, 44h, 45h, 41h, 43h, 0
    db 97h, 5, 0Bh, 47h, 0Ch, 40h, 41h, 44h, 45h, 44h, 0Ch
    db 0Ch, 0Ch, 40h, 45h, 40h, 45h, 41h, 41h, 45h, 41h, 45h
    db 40h, 44h, 0, 97h, 5, 4Bh, 0Bh, 0Bh, 47h, 0Ch, 0Ch, 0Ch
    db 49h, 0Bh, 0Bh, 0Bh, 47h, 0Ch, 44h, 41h, 40h, 42h, 44h
    db 45h, 41h, 43h, 0Ch, 0, 97h, 5, 5, 5, 4Bh, 0Bh, 0Bh
    db 0Bh, 0Bh, 0Bh, 4Dh, 5, 5, 4Bh, 0Bh, 0Bh, 47h, 0Ch, 0Ch
    db 40h, 45h, 43h, 0Ch, 49h, 0, 0Eh, 5, 89h, 4Bh, 0Bh, 0Bh
    db 47h, 0Ch, 0Ch, 49h, 0Bh, 0Bh, 0, 0Fh, 5, 81h, 4Bh, 5
    db 0Bh, 82h, 4Dh, 5, 0, 17h, 5, 0FFh, 5, 9, 88h, 4Fh, 8
    db 6, 60h, 6, 6, 57h, 8, 0Ah, 9, 0, 5, 9, 88h, 8, 53h
    db 6, 56h, 6, 57h, 8, 51h, 0Ah, 9, 0, 8Ch, 9, 9, 52h, 9
    db 4Fh, 8, 6, 56h, 6, 57h, 8, 51h, 5, 9, 81h, 52h, 5, 9
    db 0, 4, 9, 87h, 8, 53h, 5Dh, 5Ah, 6, 55h, 51h, 0Bh, 9
    db 81h, 52h, 0, 4, 9, 87h, 8, 6, 5Eh, 5Ah, 6, 55h, 50h
    db 0Ch, 9, 0, 4, 9, 87h, 4Eh, 54h, 5Eh, 59h, 6, 61h, 8
    db 0Ch, 9, 0, 5, 9, 87h, 8, 6, 5Eh, 5Ah, 6, 61h, 50h, 4
    db 9, 81h, 52h, 6, 9, 0, 8Dh, 9, 9, 52h, 9, 9, 4Eh, 54h
    db 5Ch, 5Ah, 6, 6, 61h, 50h, 0Ah, 9, 0FFh, 6, 9, 87h, 8
    db 6, 5Eh, 59h, 6, 57h, 8, 0Ah, 9, 0, 6, 9, 88h, 4Eh, 54h
    db 6, 5Fh, 59h, 61h, 8, 50h, 9, 9, 0, 5, 9, 89h, 52h, 9
    db 8, 54h, 5Eh, 5Eh, 5Ah, 61h, 8, 9, 9, 0, 7, 9, 87h, 4Eh
    db 8, 6, 5Eh, 5Ah, 6, 55h, 9, 9, 0, 7, 9, 87h, 4Fh, 53h
    db 6, 60h, 5Ah, 57h, 51h, 5, 9, 84h, 52h, 9, 9, 9, 0, 8Dh
    db 9, 9, 9, 52h, 9, 9, 4Fh, 8, 6, 56h, 6, 57h, 8, 0Ah
    db 9, 0, 6, 9, 87h, 8, 53h, 6, 56h, 6, 55h, 51h, 0Ah, 9
    db 0, 6, 9, 8Ah, 8, 6, 56h, 6, 6, 61h, 50h, 9, 9, 52h
    db 7, 9, 0FFh, 5, 9, 88h, 4Fh, 53h, 60h, 5Ah, 6, 6, 57h
    db 51h, 0Ah, 9, 0, 8Ch, 9, 9, 9, 4Fh, 8, 53h, 60h, 6, 6
    db 6, 57h, 51h, 0Bh, 9, 0, 8Ch, 9, 9, 4Fh, 53h, 6, 5Dh
    db 6, 6, 6, 6, 61h, 50h, 0Bh, 9, 0, 8Ch, 9, 9, 4Eh, 54h
    db 5Eh, 59h, 6, 6, 6, 6, 6, 55h, 7, 9, 84h, 52h, 9, 9
    db 9, 0, 8Dh, 9, 9, 9, 4Eh, 54h, 5Ch, 59h, 5Bh, 6, 6, 6
    db 61h, 50h, 0Ah, 9, 0, 4, 9, 8Dh, 8, 54h, 5Fh, 5Eh, 5Ah
    db 6, 6, 6, 55h, 9, 9, 9, 52h, 6, 9, 0, 4, 9, 8Ah, 4Eh
    db 8, 54h, 5Dh, 59h, 6, 6, 6, 61h, 50h, 9, 9, 0, 5, 9
    db 89h, 4Eh, 8, 6, 5Ch, 58h, 6, 6, 57h, 51h, 9, 9, 0FFh
    db 12h, 5, 81h, 0A1h, 4, 0Ah, 0, 0Eh, 5, 81h, 0A1h, 8
    db 0Ah, 0, 4, 0Ah, 81h, 0A2h, 7, 5, 81h, 0A1h, 4, 0Ah
    db 4, 6Dh, 2, 0Ah, 0, 6, 0Ah, 85h, 0A2h, 5, 5, 5, 0A1h
    db 5, 0Ah, 87h, 62h, 71h, 69h, 69h, 70h, 6Eh, 0Ah, 0, 81h
    db 6Fh, 0Fh, 0Ah, 87h, 62h, 66h, 71h, 70h, 65h, 6Eh, 0Ah
    db 0, 89h, 0Ah, 0Ah, 6Bh, 0Ah, 0Ah, 6Fh, 0Ah, 0Ah, 6Bh
    db 7, 0Ah, 87h, 62h, 66h, 64h, 67h, 65h, 6Eh, 0Ah, 0, 0Ah
    db 0Ah, 81h, 6Fh, 5, 0Ah, 87h, 62h, 64h, 68h, 68h, 67h
    db 6Eh, 0Ah, 0, 8Ch, 6Fh, 0Ah, 6Fh, 0Ah, 0Ah, 6Fh, 0Ah
    db 6Bh, 0Ah, 0Ah, 0Ah, 6Bh, 5, 0Ah, 4, 63h, 82h, 0Ah, 0Ah
    db 0FFh, 8Ah, 0Ah, 0Ah, 0Ah, 6Fh, 0Ah, 0Ah, 0Ah, 6Fh, 0Ah
    db 6Fh, 4, 0Ah, 2, 6Fh, 7, 0Ah, 0, 5, 0Ah, 85h, 6Fh, 0Ah
    db 0Ah, 0Ah, 6Fh, 4, 0Ah, 89h, 6Fh, 0Ah, 0Ah, 0Ah, 6Fh
    db 0Ah, 0Ah, 0Ah, 6Fh, 0, 83h, 0Ah, 0Ah, 6Fh, 5, 0Ah, 82h
    db 6Dh, 6Dh, 0Dh, 0Ah, 0, 7, 0Ah, 84h, 62h, 71h, 70h, 6Eh
    db 5, 0Ah, 81h, 6Ch, 4, 0Ah, 82h, 6Fh, 0Ah, 0, 4, 0Ah
    db 8Ah, 6Fh, 0Ah, 0Ah, 62h, 64h, 67h, 6Eh, 0Ah, 0Ah, 6Ch
    db 9, 0Ah, 0, 8, 0Ah, 82h, 63h, 63h, 7, 0Ah, 81h, 6Ch
    db 5, 0Ah, 0, 86h, 0Ah, 6Fh, 0Ah, 0Ah, 0Ah, 6Fh, 11h, 0Ah
    db 0, 10h, 0Ah, 87h, 6Ch, 0Ah, 0Ah, 0Ah, 6Fh, 0Ah, 0Ah
    db 0FFh, 2, 0Ah, 4, 6Dh, 6, 0Ah, 81h, 6Fh, 0Ah, 0Ah, 0
    db 97h, 0Ah, 62h, 71h, 69h, 69h, 70h, 6Eh, 0Ah, 0Ah, 0Ah
    db 0Ah, 6Fh, 0Ah, 0Ah, 6Ch, 0Ah, 6Fh, 0Ah, 6Fh, 0Ah, 0Ah
    db 6Fh, 0Ah, 0, 87h, 0Ah, 62h, 66h, 71h, 70h, 65h, 6Eh
    db 0Bh, 0Ah, 85h, 6Fh, 0Ah, 0Ah, 0Ah, 6Fh, 0, 87h, 0Ah
    db 62h, 66h, 64h, 67h, 65h, 6Eh, 5, 0Ah, 8Bh, 6Dh, 6Dh
    db 0Ah, 0Ah, 6Ch, 0Ah, 6Ch, 0Ah, 6Fh, 0Ah, 6Fh, 0, 90h
    db 0Ah, 62h, 64h, 68h, 68h, 67h, 6Eh, 0Ah, 0Ah, 6Fh, 0Ah
    db 62h, 71h, 70h, 6Eh, 6Fh, 7, 0Ah, 0, 2, 0Ah, 4, 63h
    db 91h, 0Ah, 0Ah, 6Fh, 0Ah, 0Ah, 62h, 64h, 67h, 6Eh, 0Ah
    db 6Fh, 0Ah, 0Ah, 6Fh, 0Ah, 6Fh, 0Ah, 0
byte_6031:  db 0Ch, 0Ah, 2, 63h, 3, 0Ah, 86h, 6Fh, 0Ah, 0Ah, 6Fh, 0Ah
    db 6Fh, 0, 17h, 0Ah, 0FFh, 85h, 5, 7, 88h, 89h, 86h, 0Eh
    db 7, 84h, 8Eh, 7, 7, 7, 0, 97h, 86h, 7, 88h, 89h, 86h
    db 7, 87h, 88h, 89h, 8Ch, 89h, 5, 89h, 86h, 89h, 5, 7
    db 8Dh, 5, 88h, 88h, 89h, 5, 0, 97h, 7, 7, 8Eh, 7, 7, 7
    db 87h, 88h, 89h, 8Ah, 87h, 87h, 89h, 5, 89h, 86h, 8Fh
    db 8Dh, 8Ch, 8Ch, 8Ch, 87h, 87h, 0, 97h, 89h, 7, 86h, 86h
    db 87h, 7, 5, 88h, 89h, 86h, 8Dh, 86h, 5, 86h, 89h, 5
    db 7, 86h, 8Ah, 8Ah, 8Ah, 87h, 86h, 0, 97h, 8Dh, 7, 86h
    db 8Ch, 86h, 7, 86h, 87h, 87h, 87h, 8Dh, 8Dh, 86h, 8Dh
    db 8Dh, 5, 7, 86h, 89h, 86h, 89h, 5, 89h, 0, 97h, 5, 7
    db 8Dh, 8Ah, 86h, 7, 88h, 89h, 86h, 86h, 5, 8Dh, 87h, 87h
    db 89h, 86h, 7, 5, 88h, 88h, 89h, 5, 86h, 0, 97h, 87h
    db 7, 88h, 89h, 86h, 8Fh, 5, 88h, 88h, 89h, 86h, 87h, 87h
    db 87h, 89h, 5, 7, 86h, 88h, 88h, 89h, 86h, 5, 0, 97h
    db 8Dh, 7, 8Dh, 88h, 89h, 7, 86h, 5, 88h, 88h, 89h, 5
    db 86h, 5, 86h, 86h, 7, 86h, 89h, 86h, 86h, 89h, 86h, 0FFh
    db 85h, 8Dh, 7, 8Dh, 88h, 89h, 7, 7, 81h, 8Eh, 8, 7, 82h
    db 8Eh, 7, 0, 97h, 87h, 7, 8Ch, 8Ch, 8Ch, 7, 82h, 83h
    db 89h, 87h, 8Ch, 86h, 88h, 89h, 86h, 7, 86h, 87h, 87h
    db 87h, 5, 87h, 87h, 0, 97h, 87h, 8Fh, 8Bh, 8Bh, 8Bh, 7
    db 86h, 82h, 83h, 89h, 8Ah, 5, 88h, 89h, 86h, 7, 86h, 89h
    db 86h, 8Dh, 8Dh, 5, 89h, 0, 97h, 5, 7, 8Bh, 8Bh, 8Bh
    db 7, 89h, 86h, 82h, 83h, 89h, 87h, 87h, 8Dh, 86h, 7, 86h
    db 86h, 86h, 5, 8Dh, 86h, 89h, 0, 97h, 86h, 7, 8Ah, 8Ah
    db 8Ah, 7, 89h, 5, 89h, 82h, 83h, 86h, 86h, 8Dh, 86h, 7
    db 7, 7, 83h, 86h, 5, 8Dh, 5, 0, 97h, 5, 7, 86h, 8Dh, 86h
    db 7, 86h, 89h, 8Dh, 8Dh, 82h, 7, 7, 83h, 86h, 7, 86h
    db 89h, 82h, 83h, 86h, 88h, 89h, 0, 97h, 86h, 7, 5, 8Dh
    db 86h, 8Fh, 86h, 89h, 8Dh, 87h, 87h, 87h, 86h, 82h, 83h
    db 8Fh, 86h, 89h, 8Dh, 7, 86h, 88h, 89h, 0, 6, 7, 91h
    db 5, 86h, 86h, 87h, 87h, 8Dh, 8Dh, 86h, 82h, 7, 86h, 87h
    db 8Dh, 7, 8Dh, 87h, 87h, 0FFh, 5, 7, 81h, 8Eh, 0Ah, 7
    db 81h, 8Eh, 6, 7, 0, 97h, 88h, 89h, 86h, 86h, 86h, 8Dh
    db 87h, 7, 5, 86h, 8Dh, 87h, 89h, 86h, 7, 8Dh, 5, 89h
    db 86h, 8Dh, 84h, 85h, 8Dh, 0, 97h, 88h, 88h, 89h, 87h
    db 87h, 8Dh, 8Dh, 7, 87h, 87h, 87h, 86h, 86h, 86h, 7, 86h
    db 87h, 8Dh, 86h, 84h, 85h, 8Dh, 8Dh, 0, 8Ch, 88h, 88h
    db 89h, 86h, 8Dh, 86h, 7, 7, 8Dh, 7, 7, 8Eh, 6, 7, 85h
    db 84h, 85h, 8Dh, 87h, 87h, 0, 82h, 7, 8Eh, 5, 7, 90h
    db 82h, 83h, 7, 8Dh, 89h, 86h, 7, 86h, 92h, 5, 7, 8Eh
    db 7, 7, 7, 86h, 0, 97h, 7, 5, 92h, 92h, 92h, 5, 7, 8Dh
    db 82h, 7, 86h, 89h, 87h, 7, 94h, 9, 90h, 92h, 92h, 92h
    db 5, 7, 7, 0, 88h, 92h, 93h, 9, 9, 9, 91h, 7, 8Eh, 6
    db 7, 82h, 94h, 9, 4, 9, 83h, 90h, 92h, 92h, 0, 5, 9, 81h
    db 90h, 8, 92h, 81h, 93h, 8, 9, 0FFh, 0Eh, 0Bh, 81h, 98h
    db 8, 0Bh, 0, 0Bh, 0Bh, 81h, 99h, 0Bh, 0Bh, 0, 13h, 0Bh
    db 84h, 98h, 0Bh, 0Bh, 0Bh, 0, 85h, 95h, 95h, 96h, 0Bh
    db 97h, 9, 95h, 81h, 96h, 8, 0Bh, 0, 88h, 7, 7, 5, 95h
    db 5, 7, 7, 8Eh, 6, 7, 81h, 94h, 5, 0Bh, 83h, 97h, 95h
    db 95h, 0, 81h, 8Dh, 5, 7, 89h, 86h, 89h, 8Dh, 8Dh, 5
    db 86h, 86h, 7, 5, 5, 95h, 83h, 86h, 7, 7, 0, 90h, 86h
    db 7, 8Dh, 8Dh, 86h, 8Fh, 86h, 89h, 8Dh, 87h, 87h, 87h
    db 86h, 7, 7, 8Eh, 6, 7, 81h, 89h, 0, 97h, 8Dh, 7, 87h
    db 87h, 87h, 7, 5, 86h, 86h, 87h, 87h, 8Dh, 8Dh, 7, 87h
    db 87h, 86h, 8Dh, 8Dh, 86h, 86h, 87h, 87h, 0FFh, 85h, 5
    db 5, 4Ah, 0Bh, 4Ch, 12h, 5, 0, 87h, 5, 4Ah, 0Bh, 0Bh
    db 0Bh, 0Bh, 4Ch, 10h, 5, 0, 0Ah, 0Bh, 81h, 4Ch, 0Ah, 5
    db 82h, 4Ah, 0Bh, 0, 0Ch, 0Bh, 81h, 4Ch, 7, 5, 83h, 4Ah
    db 0Bh, 0Bh, 0, 83h, 0Bh, 97h, 96h, 0Bh, 0Bh, 84h, 4Ch
    db 5, 5, 4Ah, 5, 0Bh, 0, 89h, 0Bh, 91h, 8Dh, 96h, 0Bh
    db 0Bh, 98h, 0Bh, 99h, 0Eh, 0Bh, 0, 88h, 99h, 90h, 92h
    db 93h, 0Bh, 98h, 0Bh, 99h, 0Fh, 0Bh, 0, 4, 99h, 13h, 0Bh
    db 0FFh, 6, 9, 88h, 8, 53h, 6, 60h, 6, 60h, 59h, 9Ch, 4
    db 9, 81h, 52h, 4, 9, 0, 6, 9, 8Ah, 8, 6, 5Eh, 58h, 57h
    db 54h, 60h, 59h, 9Ch, 9, 7, 9, 0, 6, 9, 8Bh, 8, 6, 5Ch
    db 58h, 55h, 8, 54h, 5Ch, 5Eh, 59h, 9Ch, 4, 9, 82h, 52h
    db 9, 0, 6, 9, 8Ch
byte_6366:  db 4Eh, 54h, 6, 5Eh, 61h, 50h, 4Eh, 8, 54h, 5Eh, 59h, 9Ch
    db 5, 9, 0, 4, 9, 8Fh, 52h, 9, 9, 4Eh, 54h, 5Dh, 59h, 51h
    db 9, 9, 4Eh, 54h, 60h, 5, 9Ah, 4, 9, 0, 8, 9, 8Fh, 4Eh
    db 54h, 60h, 9Ah, 9, 52h, 9, 9Bh, 5, 5, 5, 9Ah, 9, 9, 9
    db 0, 6, 9, 81h, 9Bh, 0Eh, 5, 82h, 9Ah, 9, 0, 82h, 9, 9Bh
    db 14h, 5, 81h, 9Ah, 0FFh, 17h, 9, 0, 17h, 9, 0, 17h, 9
    db 0, 83h, 9, 9, 9Eh, 4, 5, 81h, 9Dh, 0Fh, 9, 0, 81h, 9Eh
    db 8, 5, 81h, 9Dh, 0Dh, 9, 0, 0Ch, 5, 81h, 9Dh, 5, 9, 85h
    db 9Eh, 5, 5, 9Dh, 9, 0, 17h, 5, 0, 17h, 5, 0FFh, 0Eh
    db 0Ah, 81h, 6Fh, 8, 0Ah, 0, 82h, 0Ah, 6Fh, 6, 0Ah, 81h
    db 6Fh, 0Ah, 0Ah, 84h, 6Fh, 0Ah, 0Ah, 0Ah, 0, 11h, 0Ah
    db 81h, 6Fh, 5, 0Ah, 0, 83h, 0Ah, 0Ah, 0A0h, 4, 5, 81h
    db 9Fh, 4, 0Ah, 81h, 6Fh, 0Ah, 0Ah, 0, 81h, 0A0h, 8, 5
    db 81h, 9Fh, 0Dh, 0Ah, 0, 0Ch, 5, 81h, 9Fh, 5, 0Ah, 85h
    db 0A0h, 5, 5, 9Fh, 0Ah, 0, 17h, 5, 0, 17h, 5, 0FFh, 6
    db 5, 81h, 0A3h, 7, 5, 81h, 0A3h, 8, 5, 0, 9, 5, 81h, 0A3h
    db 7, 5, 86h, 0A3h, 5, 5, 5, 0A3h, 5, 0, 81h, 0A3h, 0Bh
    db 5, 81h, 0A3h, 9, 5, 81h, 0A3h, 0, 9, 5, 81h, 0A3h, 9
    db 5, 84h, 0A3h, 5, 5, 5, 0, 85h, 0A3h, 5, 5, 5, 0A3h
    db 9, 5, 81h
byte_6460:  db 0A3h, 8, 5, 0, 0Dh, 5, 81h, 0A3h, 7, 5, 82h, 0A3h, 5
          ; DATA XREF: ROM:5532o
    db 0, 6, 5, 81h, 0A3h, 0Bh, 5, 81h, 0A3h, 4, 5, 0, 84h
    db 5, 5, 5, 0A3h, 7, 5, 85h, 0A3h, 5, 5, 5, 0A3h, 7, 5
    db 0FFh, 8, 5, 87h, 0B1h, 0D9h, 0D5h, 0D6h, 0D9h, 0ECh
    db 0B4h, 8, 5, 0, 97h, 5, 5, 0A3h, 5, 5, 5, 5, 0B1h, 0B6h
    db 0C1h, 0DDh, 0DEh, 0C2h, 0BDh, 0ECh, 0B4h, 5, 0A3h, 5
    db 5, 0A3h, 5, 5, 0, 5, 5, 8Bh, 0A3h, 5, 0Fh, 0B9h, 0B2h
    db 0E5h, 0E6h, 0B2h, 0C0h, 0DAh, 4, 6, 5, 81h, 0A3h, 0
    db 81h, 0A3h, 6, 5, 90h, 0D3h, 0E0h, 0BBh, 0C7h, 0C8h
    db 0E4h, 0E1h, 0D7h, 4, 5, 5, 5, 0A3h, 5, 5, 5, 0, 90h
    db 5, 5, 5, 0A3h, 5, 5, 5, 0D4h, 0DFh, 0E3h, 0C5h, 0C6h
    db 0C3h, 0C4h, 0D8h, 4, 4, 5, 83h, 0A3h, 5, 5, 0, 7, 5
    db 89h, 0Fh, 0B8h, 0B2h, 0E2h, 0BAh, 0B2h, 0BFh, 0DAh
    db 4, 4, 5, 83h, 0A3h, 5, 5, 0, 5, 5, 8Bh, 0A3h, 5, 0B0h
    db 0B5h, 0BEh, 0DBh, 0DCh, 0B7h, 0BCh, 0EBh, 0B3h, 7, 5
    db 0, 8Fh, 5, 5, 0A3h, 5, 5, 5, 5, 5, 0B0h, 0Fh, 0D1h
    db 0D2h, 0Fh, 0EBh, 0B3h, 8, 5, 0FFh, 88h, 5, 5, 0B6h
    db 0B7h, 1, 0BFh, 0C1h, 0DAh, 8, 5, 87h, 0B6h, 0B7h, 1
    db 0BFh, 0C1h, 0DAh, 5, 0, 97h, 5, 0B5h, 0D1h, 0D3h, 1
    db 0D4h, 0D2h, 0C0h, 0DCh, 5, 5, 0A3h, 5, 0A3h, 5, 0B5h
    db 0D1h, 0D3h, 1, 0D4h, 0D2h, 0C0h, 0DCh, 0, 97h, 5, 0B3h
    db 0CFh, 0C6h, 0B9h, 0C7h, 0D0h, 0B4h, 0D9h, 0EAh, 0EBh
    db 0EBh, 0EBh, 0EAh, 0E6h, 0B3h, 0CFh, 0C6h, 0B9h, 0C7h
    db 0D0h, 0B4h, 0E8h, 0, 97h, 5, 1, 1, 0BAh, 0DEh, 0BBh
    db 1, 1, 1, 0DFh, 0E2h, 0E9h, 0E2h, 0E0h, 1, 1, 1, 0BAh
    db 0DEh, 0BBh, 1, 1, 4, 0, 97h, 5, 0B2h, 0CDh, 0C4h, 0B8h
    db 0C5h, 0CEh, 0BEh, 0D7h, 0D6h, 0D6h, 0D6h, 0D6h, 0D6h
    db 0D8h, 0B2h, 0CDh, 0C4h, 0B8h, 0C5h, 0CEh, 0BEh, 0E7h
    db 0, 97h, 5, 0B1h, 0C9h, 0CAh, 1, 0CBh, 0CCh, 0BDh, 0DDh
    db 0A3h, 5, 5, 5, 5, 5, 0B1h, 0C9h, 0CAh, 1, 0CBh, 0CCh
    db 0BDh, 0DDh, 0, 97h, 5, 5, 0B0h, 0C2h, 0C8h, 0C3h, 0BCh
    db 0DBh, 5, 5, 5, 5, 5, 5, 5, 5, 0B0h, 0C2h, 0C8h, 0C3h
    db 0BCh, 0DBh, 5, 0, 83h, 5, 5, 0A3h, 7, 5, 85h, 0A3h
    db 5, 5, 5, 0A3h, 8, 5, 0FFh

; =============== S U B R O U T I N E =======================================


game_sub_65E0:        ; CODE XREF: update_game+2Cp
    ld  hl, game_unk_E270
    ld  b, 9

loc_65E5:       ; CODE XREF: game_sub_65E0+47j
    ld  (game_word_E310), hl
    ld  a, (hl)
    and a
    jr  z, loc_6620
    exx
    ld  bc, 8A8h
    cp  2
    jr  nz, loc_65F7
    ld  bc, 1490h

loc_65F7:       ; CODE XREF: game_sub_65E0+12j
    exx
    inc a
    jr  z, loc_6620
    inc l
    ld  e, l
    ld  d, h
    inc e
    inc e
    inc e
    inc e
    ld  a, (de)
    add a, (hl)
    ld  (de), a
    inc l
    inc e
    ld  a, (de)
    adc a, (hl)
    ld  (de), a
    cp  0C0h ; ''
    call  nc, game_sub_662A
    inc l
    inc e
    ld  a, (de)
    add a, (hl)
    ld  (de), a
    inc l
    inc de
    ld  a, (de)
    adc a, (hl)
    ld  (de), a
    exx
    sub b
    cp  c
    exx
    call  nc, game_sub_662A

loc_6620:       ; CODE XREF: game_sub_65E0+Aj
          ; game_sub_65E0+19j
    ld  hl, (game_word_E310)
    ld  de, 10h
    add hl, de
    djnz  loc_65E5
    ret
; End of function game_sub_65E0


; =============== S U B R O U T I N E =======================================


game_sub_662A:        ; CODE XREF: game_sub_65E0+2Cp
          ; game_sub_65E0+3Dp ...
    exx
    ld  hl, (game_word_E310)
    ld  (hl), 0
    ld  a, l
    sub 70h ; 'p'
    rra
    rra
    and 3Ch ; '<'
    ld  hl, game_unk_E10C
    call  add_a_to_hl ; HL=HL+A
    ld  (hl), 0C3h ; ''
    exx
    ret
; End of function game_sub_662A


; =============== S U B R O U T I N E =======================================


game_sub_6641:        ; CODE XREF: update_game+2Fp
    ld  hl, game_unk_E270
    ld  de, game_unk_E10C
    ld  b, 9

loc_6649:       ; CODE XREF: game_sub_6641+24j
    ld  a, (hl)
    and a
    jr  z, loc_6668
    ld  a, 6
    add a, l
    ld  l, a
    ld  a, (hl)
    ld  (de), a
    inc l
    inc l
    inc de
    ld  a, (hl)
    ld  (de), a
    inc l
    inc de
    ld  a, (hl)
    ld  (de), a
    inc l
    inc de
    ld  a, (hl)
    ld  (de), a
    inc de
    ld  a, 6

loc_6663:       ; CODE XREF: game_sub_6641+2Dj
    add a, l
    ld  l, a
    djnz  loc_6649
    ret
; ---------------------------------------------------------------------------

loc_6668:       ; CODE XREF: game_sub_6641+Aj
    inc de
    inc de
    inc de
    inc de
    ld  a, 10h
    jr  loc_6663
; End of function game_sub_6641


; =============== S U B R O U T I N E =======================================


game_sub_6670:        ; CODE XREF: update_game+26p
    ld  hl, game_byte_E1C1
    dec (hl)
    ret nz
    ld  (hl), 3Ch ; '<'
    exx
    ld  hl, game_byte_E1D2
    inc (hl)
    ld  a, (hl)
    cp  13h
    ret nc
    rra
    ld  bc, -512
    jr  c, loc_6686+2

loc_6686:       ; CODE XREF: game_sub_6670+14j
    ld  bc, 300h
    exx
    ld  hl, game_unk_E200
    ld  b, 7

loc_668F:       ; CODE XREF: game_sub_6670+30j
    push  bc
    ld  a, (hl)
    and a
    ld  (game_word_E310), hl
    call  nz, game_sub_66A3
    ld  hl, (game_word_E310)
    ld  de, 10h
    add hl, de
    pop bc
    djnz  loc_668F
    ret
; End of function game_sub_6670


; =============== S U B R O U T I N E =======================================


game_sub_66A3:        ; CODE XREF: game_sub_6670+25p
    inc hl
    ld  de, 800h
    ld  a, (hl)
    cp  0Bh
    jr  nz, loc_66AF
    ld  de, 0F800h

loc_66AF:       ; CODE XREF: game_sub_66A3+7j
    ld  a, 8
    add a, l
    ld  l, a
    ld  c, (hl)
    inc hl
    inc hl
    ld  b, (hl)
    ld  a, l
    and 0F0h ; ''
    ld  hl, game_unk_E270
    add a, l
    ld  l, a
    ld  (hl), 2
    inc hl
    exx
    ld  a, c
    exx
    ld  (hl), a
    inc hl
    exx
    ld  a, b
    exx
    ld  (hl), a
    inc hl
    ld  (hl), e
    inc hl
    ld  (hl), d
    inc hl
    inc hl
    ld  (hl), c
    inc hl
    inc hl
    ld  (hl), b
    inc hl
    ld  (hl), 88h ; ''
    inc hl
    ld  (hl), 0Fh
    ret
; End of function game_sub_66A3


; =============== S U B R O U T I N E =======================================


game_sub_66DC:        ; CODE XREF: game_sub_6745:loc_677Ep
    ld  de, (game_word_E310)
    ld  a, (de)
    cp  12h
    jr  c, game_sub_66F8
    ld  a, (game_byte_E1D6)
    dec a
    ld  b, 20h ; ' '
    jr  z, loc_66EF
    ld  b, 18h

loc_66EF:       ; CODE XREF: game_sub_66DC+Fj
    ld  a, (game_byte_E1D3)
    add a, a
    sub b
    neg
    ld  (hl), a
    ret
; End of function game_sub_66DC


; =============== S U B R O U T I N E =======================================


game_sub_66F8:        ; CODE XREF: game_sub_66DC+7j
          ; game_sub_7632+43p
    ex  de, hl
    ld  hl, game_byte_E321
    ld  b, 2

loc_66FE:       ; CODE XREF: game_sub_66F8+Fj
    cp  (hl)
    jr  z, loc_670D
    ex  af, af'
    ld  a, 6
    add a, l
    ld  l, a
    ex  af, af'
    djnz  loc_66FE
    xor a
    ex  de, hl
    ld  (hl), a
    ret
; ---------------------------------------------------------------------------

loc_670D:       ; CODE XREF: game_sub_66F8+7j
    push  de
    ld  a, 4
    add a, l
    ld  l, a
    ld  a, (game_byte_E1D3)
    add a, (hl)
    add a, a
    ld  de, byte_770F
    push  hl
    ex  de, hl
    call  get_hl_a_ptr  ; DE=(HL+A)
    pop hl
    inc l
    ld  a, (hl)
    ex  de, hl
    ld  c, (hl)
    call  add_a_to_hl ; HL=HL+A
    ld  a, (hl)
    ex  de, hl
    cp  0FFh
    jr  nz, loc_6730
    ld  a, c
    ld  (hl), 0

loc_6730:       ; CODE XREF: game_sub_66F8+33j
    pop hl
    ld  (hl), a
    ret
; End of function game_sub_66F8


; =============== S U B R O U T I N E =======================================


game_sub_6733:        ; CODE XREF: update_game+50p
    ld  b, 4
    ld  a, (game_byte_E1D6)
    dec a
    jr  z, loc_673D
    ld  b, 2

loc_673D:       ; CODE XREF: game_sub_6733+6j
    ld  hl, game_unk_E150
    ld  de, 8
    jr  loc_674D
; End of function game_sub_6733


; =============== S U B R O U T I N E =======================================


game_sub_6745:        ; CODE XREF: update_game+29p
    ld  b, 7
    ld  de, 10h
    ld  hl, game_unk_E200

loc_674D:       ; CODE XREF: game_sub_6733+10j
          ; game_sub_6745+36j
    ld  (game_word_E310), hl
    ld  a, (hl)
    ld  (game_byte_E318), a
    and a
    jr  z, loc_6777
    cp  10h
    jr  z, loc_6777
    cp  11h
    jr  z, loc_6777
    cp  0Bh
    ld  c, 3
    jr  nz, loc_6767
    ld  c, 0Ah

loc_6767:       ; CODE XREF: game_sub_6745+1Ej
    cp  12h
    jr  c, loc_676D
    ld  c, 1

loc_676D:       ; CODE XREF: game_sub_6745+24j
    ld  a, c
    add a, l
    ld  l, a
    ld  a, (hl)
    and a
    jr  z, loc_6777
    dec (hl)
    jr  z, loc_677E

loc_6777:       ; CODE XREF: game_sub_6745+10j
          ; game_sub_6745+14j ...
    ld  hl, (game_word_E310)
    add hl, de
    djnz  loc_674D
    ret
; ---------------------------------------------------------------------------

loc_677E:       ; CODE XREF: game_sub_6745+30j
    call  game_sub_66DC
    call  game_sub_6866
    ld  a, e
    sub 9
    cp  9Fh ; ''
    ret nc
    ld  hl, 0
    ld  (game_word_E316), hl
    ld  hl, (player_spr_attr)
    ld  a, l
    sub e
    jr  nc, loc_67A0
    neg
    ld  c, a
    ld  a, 1
    ld  (game_word_E316), a
    ld  a, c

loc_67A0:       ; CODE XREF: game_sub_6745+50j
    rra
    rra
    rra
    rra
    rra
    and 7
    ld  b, a
    ld  a, h
    sub d
    jr  nc, loc_67B5
    neg
    ld  e, a
    ld  a, 1
    ld  (game_word_E316+1), a
    ld  a, e

loc_67B5:       ; CODE XREF: game_sub_6745+65j
    rra
    rra
    rra
    rra
    rra
    and 7
    ld  c, a
    ld  hl, game_unk_E270
    ld  e, 9
    ld  a, (game_byte_E321)
    ld  hl, game_unk_E270
    cp  0Ah
    jr  nz, loc_67CE
    ld  e, 5

loc_67CE:       ; CODE XREF: game_sub_6745+85j
          ; game_sub_6745+92j
    ld  a, (hl)
    and a
    jr  z, loc_67DA
    ld  a, 10h
    add a, l
    ld  l, a
    dec e
    jr  nz, loc_67CE
    ret
; ---------------------------------------------------------------------------

loc_67DA:       ; CODE XREF: game_sub_6745+8Bj
    ld  (game_word_E314), hl
    ld  a, b
    add a, a
    add a, a
    add a, b
    add a, b
    add a, c
    ld  de, byte_68F3
    call  add_a_to_de ; DE=DE+A
    ld  a, (de)
    cp  9
    ret nc
    ld  c, a
    ld  a, r
    and 3
    rra
    jr  nc, loc_67FC
    ld  a, 1
    rra
    jr  nc, loc_67FA+1

loc_67FA:       ; CODE XREF: game_sub_6745+B3j
    ld  a, 0FFh

loc_67FC:       ; CODE XREF: game_sub_6745+AEj
    add a, c
    cp  9
    jr  c, loc_6802
    ld  a, c

loc_6802:       ; CODE XREF: game_sub_6745+BAj
    ld  hl, byte_6917
    add a, a
    add a, a
    call  get_hl_a_ptr  ; DE=(HL+A)
    inc hl
    ld  c, (hl)
    inc hl
    ld  b, (hl)
    ld  a, (game_word_E316)
    and a
    call  nz, game_sub_6857
    ld  a, (game_byte_E318)
    cp  12h
    jr  c, loc_6821
    ld  hl, 80h ; ''
    add hl, de
    ex  de, hl

loc_6821:       ; CODE XREF: game_sub_6745+D5j
    ld  hl, (game_word_E314)
    ld  (hl), 1
    inc hl
    ld  (hl), e
    inc hl
    ld  (hl), d
    inc hl
    ld  e, c
    ld  d, b
    ld  a, (game_word_E316+1)
    and a
    call  nz, game_sub_6857
    ld  (hl), e
    inc hl
    ld  (hl), d
    inc hl
    inc hl
    ld  de, (game_word_E312)
    ld  a, e
    ld  (hl), a
    inc hl
    inc hl
    ld  (hl), d
    inc hl
    ld  (hl), 88h ; ''
    inc hl
    ld  (hl), 0Fh
    ld  a, (game_byte_E318)
    cp  5
    jr  z, loc_6852
    cp  9
    ret nz

loc_6852:       ; CODE XREF: game_sub_6745+108j
    ld  a, 89h ; ''
    jp  game_sub_79D8
; End of function game_sub_6745


; =============== S U B R O U T I N E =======================================


game_sub_6857:        ; CODE XREF: game_sub_6745+CDp
          ; game_sub_6745+ECp
    ld  a, e
    cpl
    ld  e, a
    ld  a, d
    cpl
    ld  d, a
    inc de
    ret
; End of function game_sub_6857

; ---------------------------------------------------------------------------
; START OF FUNCTION CHUNK FOR game_sub_6866

loc_685F:       ; CODE XREF: game_sub_6866+14j
    ld  a, 4
    call  get_hl_a_ptr  ; DE=(HL+A)
    jr  loc_688C
; END OF FUNCTION CHUNK FOR game_sub_6866

; =============== S U B R O U T I N E =======================================


game_sub_6866:        ; CODE XREF: game_sub_6745+3Cp

; FUNCTION CHUNK AT 685F SIZE 00000007 BYTES
; FUNCTION CHUNK AT 6891 SIZE 0000005B BYTES

    ld  hl, (game_word_E310)
    ld  a, (hl)
    ld  c, 0
    cp  9
    jr  z, loc_6891
    cp  0Ah
    jr  z, loc_689B
    cp  0Bh
    jr  z, loc_68BE
    cp  12h
    jr  nc, loc_685F
    cp  6
    jr  nz, game_sub_6882
    ld  c, 8
; End of function game_sub_6866


; =============== S U B R O U T I N E =======================================


game_sub_6882:        ; CODE XREF: game_sub_6866+18j
          ; game_sub_6866:loc_6891p ...
    ld  de, 9
    add hl, de
    ld  e, (hl)
    inc hl
    inc hl
    ld  a, (hl)
    add a, c
    ld  d, a

loc_688C:       ; CODE XREF: game_sub_6866-2j
          ; game_sub_6866+4Fj ...
    ld  (game_word_E312), de
    ret
; End of function game_sub_6882

; ---------------------------------------------------------------------------
; START OF FUNCTION CHUNK FOR game_sub_6866

loc_6891:       ; CODE XREF: game_sub_6866+8j
    call  game_sub_6882
    inc hl
    ld  a, (hl)
    cp  74h ; 't'
    ret z
    pop hl
    ret
; ---------------------------------------------------------------------------

loc_689B:       ; CODE XREF: game_sub_6866+Cj
    inc l
    inc l
    ld  a, (hl)
    dec l
    dec l
    and 3
    cp  3
    jr  z, loc_68B7
    rra
    jr  c, game_sub_6882
    rra
    jr  c, loc_68AE
    pop hl
    ret
; ---------------------------------------------------------------------------

loc_68AE:       ; CODE XREF: game_sub_6866+44j
          ; game_sub_6866+54j
    call  game_sub_6882
    ld  a, 40h ; '@'
    add a, d
    ld  d, a
    jr  loc_688C
; ---------------------------------------------------------------------------

loc_68B7:       ; CODE XREF: game_sub_6866+3Ej
    ld  a, r
    rra
    jr  c, loc_68AE
    jr  game_sub_6882
; ---------------------------------------------------------------------------

loc_68BE:       ; CODE XREF: game_sub_6866+10j
    ld  hl, (game_word_E310)
    inc l
    ld  a, (hl)
    dec l
    cp  13h
    jr  nz, game_sub_6882
    ld  a, r
    rra
    jr  c, loc_68DC
    ld  de, 0Bh
    add hl, de
    ld  a, (hl)
    inc l
    ld  e, (hl)
    inc l
    ld  d, (hl)
    cp  1
    jr  z, loc_688C
    pop de
    ret
; ---------------------------------------------------------------------------

loc_68DC:       ; CODE XREF: game_sub_6866+65j
    inc l
    inc l
    ld  a, (hl)
    inc l
    ld  e, (hl)
    inc l
    inc l
    inc l
    inc l
    ld  d, (hl)
    cp  1
    jr  z, loc_688C
    pop de
    ret
; END OF FUNCTION CHUNK FOR game_sub_6866

; =============== S U B R O U T I N E =======================================

; DE=(HL+A)

get_hl_a_ptr:       ; CODE XREF: game_sub_4773+C6p
          ; ROM:5507p ...
    call  add_a_to_hl ; HL=HL+A
    ld  e, (hl)
    inc hl
    ld  d, (hl)
    ret
; End of function get_hl_a_ptr

; ---------------------------------------------------------------------------
byte_68F3:  db 0FFh, 0FFh, 0, 0, 0, 0, 0FFh, 4, 3, 2, 2, 1, 8, 5, 4
          ; DATA XREF: game_sub_6745+9Eo
    db 4, 3, 3, 8, 6, 5, 4, 3, 3, 8, 6, 5, 5, 4, 4, 8, 7, 7
    db 5, 4, 4
byte_6917:  db 0, 0, 40h, 1, 3Eh, 0, 39h, 1, 7Ah, 0, 27h, 1, 0Ah, 1
          ; DATA XREF: game_sub_6745:loc_6802o
    db 0B1h, 0, 0E2h, 0, 0E2h, 0, 0B1h, 0, 0Ah, 1, 27h, 1
    db 7Ah, 0, 39h, 1, 3Eh, 0, 40h, 1, 0, 0

; =============== S U B R O U T I N E =======================================


game_sub_693B:        ; CODE XREF: game_sub_6A00+22p
          ; game_sub_6A34+1Ap ...
    exx
    ld  hl, game_word_E1C2
    xor a
    sub (hl)
    sub (hl)
    inc hl
    add a, (hl)
    inc hl
    sub (hl)
    sub (hl)
    inc hl
    add a, (hl)
    exx
    ld  i, a
    ld  a, d
    sub b
    exx
    ld  d, a
    xor a
    add a, (hl)
    dec hl
    sub (hl)
    dec hl
    dec hl
    sub (hl)
    ld  c, a
    add a, d
    ld  d, a
    ld  a, i
    cp  d
    exx
    ccf
    ret nc
    exx
    ld  d, a
    exx
    ld  a, e
    sub c
    exx
    add a, c
    cp  d
    exx
    ret
; End of function game_sub_693B


; =============== S U B R O U T I N E =======================================


game_sub_696A:        ; CODE XREF: game_sub_6A34p
          ; game_sub_6A9Cp
    ld  a, (game_byte_E1CF)
    and a
    ret nz
    ld  hl, 1003h
    ld  (game_word_E1C2), hl
    ld  hl, 1006h
    ld  (game_word_E1C4), hl
    ld  hl, player_spr_attr
    ld  c, (hl)
    inc hl
    ld  b, (hl)
    xor a
    ret
; End of function game_sub_696A

; ---------------------------------------------------------------------------
; START OF FUNCTION CHUNK FOR game_sub_69C9

loc_6983:       ; CODE XREF: game_sub_69C9+3j
    ld  hl, (game_word_E310)
    inc (hl)
    ld  a, (hl)
    push  af
    call  game_sub_788F
    ld  a, (game_byte_E1D6)
    ld  c, 14h
    dec a
    jr  z, loc_6996
    ld  c, 17h

loc_6996:       ; CODE XREF: game_sub_69C9-37j
    pop af
    cp  c
    ld  a, 0Ah
    jp  nz, game_sub_79D8
    ld  hl, game_byte_E143
    dec (hl)
    jr  nz, loc_69A6+1
    dec l
    dec l
    dec l

loc_69A6:       ; CODE XREF: game_sub_69C9-28j
    ld  (hl), 3
    ld  a, 50h ; 'P'
    call  game_sub_79D8
    ld  de, 1000h
    call  game_sub_424C
    ld  a, (game_byte_E143)
    and a
    ret nz
    ld  de, 5000h
    call  game_sub_424C
    ld  a, (game_byte_E1D6)
    dec a
    ret z
    ld  de, 5000h
    jp  game_sub_424C
; END OF FUNCTION CHUNK FOR game_sub_69C9

; =============== S U B R O U T I N E =======================================


game_sub_69C9:        ; CODE XREF: game_sub_6A00+25p

; FUNCTION CHUNK AT 6983 SIZE 00000046 BYTES

    call  game_sub_6C45
    jr  loc_6983
; End of function game_sub_69C9


; =============== S U B R O U T I N E =======================================


game_sub_69CE:        ; CODE XREF: update_game+66p
    ld  b, 3
    ld  hl, game_unk_E0B8
    xor a
    ld  (game_byte_E1CD), a

loc_69D7:       ; CODE XREF: game_sub_69CE+2Fj
    push  bc
    push  hl
    ld  c, (hl)
    ld  a, c
    cp  0C3h ; ''
    jr  nc, loc_69F3
    inc l
    ld  b, (hl)
    inc l
    ld  a, (hl)
    ld  de, 1007h
    cp  8
    jr  z, loc_69EC
    ld  e, 2

loc_69EC:       ; CODE XREF: game_sub_69CE+1Aj
    ld  (game_word_E1C2), de
    call  game_sub_6A00

loc_69F3:       ; CODE XREF: game_sub_69CE+Fj
    ld  hl, game_byte_E1CD
    inc (hl)
    pop hl
    pop bc
    inc l
    inc l
    inc l
    inc l
    djnz  loc_69D7
    ret
; End of function game_sub_69CE


; =============== S U B R O U T I N E =======================================


game_sub_6A00:        ; CODE XREF: game_sub_69CE+22p
    ld  hl, game_unk_E150
    exx
    ld  a, (game_byte_E1D6)
    ld  b, 4
    dec a
    jr  z, loc_6A0E
    ld  b, 2

loc_6A0E:       ; CODE XREF: game_sub_6A00+Aj
          ; game_sub_6A00+31j
    push  bc
    exx
    ld  (game_word_E310), hl
    ld  a, (hl)
    and a
    jr  z, loc_6A28
    cp  17h
    jr  z, loc_6A28
    inc l
    inc l
    inc l
    inc l
    ld  e, (hl)
    inc l
    ld  d, (hl)
    call  game_sub_693B
    call  c, game_sub_69C9

loc_6A28:       ; CODE XREF: game_sub_6A00+15j
          ; game_sub_6A00+19j
    ld  hl, (game_word_E310)
    ld  de, 8
    add hl, de
    exx
    pop bc
    djnz  loc_6A0E
    ret
; End of function game_sub_6A00


; =============== S U B R O U T I N E =======================================


game_sub_6A34:        ; CODE XREF: update_game+3Bp
    call  game_sub_696A
    ret nz
    ld  hl, game_unk_E270
    exx
    ld  b, 9

loc_6A3E:       ; CODE XREF: game_sub_6A34+27j
    exx
    ld  (game_word_E310), hl
    ld  a, (hl)
    and a
    jr  z, loc_6A53
    ld  a, 6
    add a, l
    ld  l, a
    ld  e, (hl)
    inc l
    inc l
    ld  d, (hl)
    call  game_sub_693B
    jr  c, loc_6A5E

loc_6A53:       ; CODE XREF: game_sub_6A34+10j
          ; game_sub_6A34+37j
    ld  hl, (game_word_E310)
    ld  de, 10h
    add hl, de
    exx
    djnz  loc_6A3E
    ret
; ---------------------------------------------------------------------------

loc_6A5E:       ; CODE XREF: game_sub_6A34+1Dj
    ld  hl, (game_word_E310)
    ld  a, (hl)
    inc a
    jr  nz, loc_6A6D
    ld  de, 0Ah
    add hl, de
    ld  a, (hl)
    and a
    jr  z, loc_6A53

loc_6A6D:       ; CODE XREF: game_sub_6A34+2Fj
    call  game_sub_662A
; End of function game_sub_6A34


; =============== S U B R O U T I N E =======================================


game_sub_6A70:        ; CODE XREF: game_sub_6A9C+5Bp
    ld  hl, (game_word_E310)
    ld  a, (hl)
    cp  10h
    ret z
    cp  11h
    jr  z, loc_6A8E
    ld  hl, game_byte_E1CF
    ld  (hl), 1
    inc hl
    ld  (hl), 80h ; ''
    ld  a, 5Ch ; '\'
    call  game_sub_79D8
    ld  a, 1
    ld  (game_byte_E1DD), a
    ret
; ---------------------------------------------------------------------------

loc_6A8E:       ; CODE XREF: game_sub_6A70+9j
    ld  hl, game_byte_E1D5
    ld  a, (hl)
    inc a
    cp  3
    ret nc
    ld  (hl), a
    ld  a, 8Fh ; ''
    jp  game_sub_79D8
; End of function game_sub_6A70


; =============== S U B R O U T I N E =======================================


game_sub_6A9C:        ; CODE XREF: update_game+38p
    call  game_sub_696A
    ret nz
    ld  hl, game_unk_E200
    exx
    ld  b, 7

loc_6AA6:       ; CODE XREF: game_sub_6A9C+46j
    push  bc
    exx
    push  bc
    ld  (game_word_E310), hl
    ld  a, (hl)
    add a, a
    ld  e, a
    jr  z, loc_6AD8
    inc hl
    ld  a, (hl)
    cp  13h
    jr  z, loc_6AE5
    cp  14h
    jr  z, loc_6AD8
    ld  a, e
    ld  de, 8
    add hl, de
    ld  e, (hl)
    inc l
    inc l
    ld  d, (hl)
    ld  hl,  loc_6BAF+2
    call  add_a_to_hl ; HL=HL+A
    ld  a, (hl)
    ld  (game_word_E1C4), a
    inc hl
    ld  a, (hl)
    ld  (game_word_E1C4+1), a
    call  game_sub_693B
    jr  c, loc_6AEE

loc_6AD8:       ; CODE XREF: game_sub_6A9C+13j
          ; game_sub_6A9C+1Dj ...
    ld  hl, (game_word_E310)
    ld  de, 10h
    add hl, de
    pop bc
    exx
    pop bc
    djnz  loc_6AA6
    ret
; ---------------------------------------------------------------------------

loc_6AE5:       ; CODE XREF: game_sub_6A9C+19j
    xor a
    ld  (game_byte_E1CE), a
    call  game_sub_6B85
    jr  loc_6AF1
; ---------------------------------------------------------------------------

loc_6AEE:       ; CODE XREF: game_sub_6A9C+3Aj
    call  game_sub_6BD5

loc_6AF1:       ; CODE XREF: game_sub_6A9C+50j
    ld  a, (game_byte_E1CE)
    and a
    jr  z, loc_6AD8
    call  game_sub_6A70
    jr  loc_6AD8
; End of function game_sub_6A9C


; =============== S U B R O U T I N E =======================================


game_sub_6AFC:        ; CODE XREF: update_game+3Ep
    ld  b, 3
    ld  hl, game_unk_E0B8
    xor a
    ld  (game_byte_E1CD), a

loc_6B05:       ; CODE XREF: game_sub_6AFC+2Fj
    push  bc
    push  hl
    ld  c, (hl)
    ld  a, c
    cp  0C3h ; ''
    jr  nc, loc_6B21
    inc l
    ld  b, (hl)
    inc l
    ld  a, (hl)
    ld  de, 1007h
    cp  8
    jr  z, loc_6B1A
    ld  e, 2

loc_6B1A:       ; CODE XREF: game_sub_6AFC+1Aj
    ld  (game_word_E1C2), de
    call  game_sub_6B2E

loc_6B21:       ; CODE XREF: game_sub_6AFC+Fj
    ld  hl, game_byte_E1CD
    inc (hl)
    pop hl
    pop bc
    inc l
    inc l
    inc l
    inc l
    djnz  loc_6B05
    ret
; End of function game_sub_6AFC


; =============== S U B R O U T I N E =======================================


game_sub_6B2E:        ; CODE XREF: game_sub_6AFC+22p
    ld  a, c
    cp  0E0h ; ''
    ret z
    ld  hl, game_unk_E200
    exx
    ld  b, 7

loc_6B38:       ; CODE XREF: game_sub_6B2E+4Fj
    push  bc
    exx
    push  bc
    ld  (game_word_E310), hl
    ld  a, (hl)
    sub 10h
    cp  2
    jr  c, loc_6B73
    inc hl
    ld  a, (hl)
    cp  13h
    jr  z, loc_6B80
    dec hl
    ld  a, (hl)
    add a, a
    jr  z, loc_6B73
    ld  de,  loc_6BAF+2
    call  add_a_to_de ; DE=DE+A
    ld  a, (de)
    inc de
    ld  (game_word_E1C4), a
    ld  a, (de)
    ld  (game_word_E1C4+1), a
    inc hl
    ld  a, (hl)
    cp  14h
    jr  z, loc_6B73
    ld  a, 8
    add a, l
    ld  l, a
    ld  e, (hl)
    inc hl
    inc hl
    ld  d, (hl)
    call  game_sub_693B
    call  c, game_sub_6BD5

loc_6B73:       ; CODE XREF: game_sub_6B2E+15j
          ; game_sub_6B2E+20j ...
    ld  hl, (game_word_E310)
    ld  a, 10h
    add a, l
    ld  l, a
    pop bc
    exx
    pop bc
    djnz  loc_6B38
    ret
; ---------------------------------------------------------------------------

loc_6B80:       ; CODE XREF: game_sub_6B2E+1Bj
    call  game_sub_6B85
    jr  loc_6B73
; End of function game_sub_6B2E


; =============== S U B R O U T I N E =======================================


game_sub_6B85:        ; CODE XREF: game_sub_6A9C+4Dp
          ; game_sub_6B2E:loc_6B80p

; FUNCTION CHUNK AT 6CD6 SIZE 00000016 BYTES

    ld  de, 0A00h
    ld  (game_word_E1C4), de
    inc l
    ld  a, (hl)
    rra
    jr  nc, loc_6B9E
    inc l
    ld  e, (hl)
    inc l
    inc l
    inc l
    inc l
    ld  d, (hl)
    call  game_sub_693B
    jp  c, loc_6CD6

loc_6B9E:       ; CODE XREF: game_sub_6B85+Aj
    ld  hl, (game_word_E310)
    ld  de, 0Bh
    add hl, de
    ld  a, (hl)
    rra
    ret nc
    inc l
    ld  e, (hl)
    inc l
    ld  d, (hl)
    call  game_sub_693B

loc_6BAF:       ; DATA XREF: game_sub_6A9C+28o
          ; game_sub_6B2E+22o
    jp  c, loc_6CE0
    ret
; End of function game_sub_6B85

; ---------------------------------------------------------------------------
    db 2, 10h, 2, 10h, 2, 10h, 1, 10h, 4, 10h, 1, 20h, 1, 10h
    db 1, 10h, 1, 10h, 1, 50h, 1, 10h, 1, 20h, 1, 10h, 1, 10h
    db 1, 10h, 1, 10h, 1, 10h

; =============== S U B R O U T I N E =======================================


game_sub_6BD5:        ; CODE XREF: game_sub_6A9C:loc_6AEEp
          ; game_sub_6B2E+42p

; FUNCTION CHUNK AT 6C52 SIZE 0000001C BYTES
; FUNCTION CHUNK AT 6CAF SIZE 00000027 BYTES
; FUNCTION CHUNK AT 6CEC SIZE 0000001C BYTES

    xor a
    ld  (game_byte_E1CE), a
    ld  hl, (game_word_E310)
    ld  a, (hl)
    cp  6
    jp  z, loc_6C68
    cp  0Ah
    jp  z, loc_6CAF
    cp  7
    jr  z, loc_6C52
    cp  9
    jr  z, loc_6C59
    inc hl
    cp  10h
    jr  nc, game_sub_6BF9
    cp  0Dh
    jp  nc, loc_6CEC
; End of function game_sub_6BD5


; =============== S U B R O U T I N E =======================================


game_sub_6BF9:        ; CODE XREF: game_sub_6BD5+1Dj
          ; game_sub_6BD5+91j ...
    ld  (hl), 14h

loc_6BFB:       ; CODE XREF: game_sub_6C6E+2Ej
          ; game_sub_6CA3+9j ...
    ld  a, l
    rra
    rra
    rra
    rra
    and 0Fh
    ld  hl, game_unk_E1C6
    call  add_a_to_hl ; HL=HL+A
    ld  (hl), 10h
    ld  hl, (game_word_E310)
    ld  a, (hl)
    cp  11h
    jr  z, loc_6C1D
    cp  10h
    ld  a, 0Ah
    jr  nz, loc_6C1A
    ld  a, 8Eh ; ''

loc_6C1A:       ; CODE XREF: game_sub_6BF9+1Dj
    call  game_sub_79D8

loc_6C1D:       ; CODE XREF: game_sub_6BF9+17j
    ld  hl, (game_word_E310)
    ld  a, (hl)
    inc l
    inc l
    ld  b, (hl)
    ld  c, 0
    cp  5
    jr  nz, loc_6C32
    djnz  loc_6C2D
    inc c

loc_6C2D:       ; CODE XREF: game_sub_6BF9+31j
    djnz  loc_6C31
    ld  c, 2

loc_6C31:       ; CODE XREF: game_sub_6BF9:loc_6C2Dj
    ld  (hl), c

loc_6C32:       ; CODE XREF: game_sub_6BF9+2Fj
    cp  12h
    jr  nc, loc_6C40
    add a, a
    ld  hl,  loc_6D5F+1
    call  get_hl_a_ptr  ; DE=(HL+A)
    call  game_sub_424C

loc_6C40:       ; CODE XREF: game_sub_6BF9+3Bj
          ; game_sub_6BD5+82j
    ld  a, 1
    ld  (game_byte_E1CE), a
; End of function game_sub_6BF9


; =============== S U B R O U T I N E =======================================


game_sub_6C45:        ; CODE XREF: game_sub_69C9p
    ld  hl, game_unk_E0B8
    ld  a, (game_byte_E1CD)
    add a, a
    add a, a
    add a, l
    ld  l, a
    ld  (hl), 0E0h ; ''
    ret
; End of function game_sub_6C45

; ---------------------------------------------------------------------------
; START OF FUNCTION CHUNK FOR game_sub_6BD5

loc_6C52:       ; CODE XREF: game_sub_6BD5+14j
          ; game_sub_6BD5+8Bj
    ld  a, 0Dh
    call  game_sub_79D8
    jr  loc_6C40
; ---------------------------------------------------------------------------

loc_6C59:       ; CODE XREF: game_sub_6BD5+18j
    ld  a, 0Ch
    add a, l
    ld  l, a
    ld  a, (hl)
    cp  74h ; 't'
    jr  nz, loc_6C52
    ld  hl, (game_word_E310)
    inc hl
    jr  game_sub_6BF9
; ---------------------------------------------------------------------------

loc_6C68:       ; CODE XREF: game_sub_6BD5+Aj
    exx
    ld  b, 10h
    ld  hl, 1000h
; END OF FUNCTION CHUNK FOR game_sub_6BD5

; =============== S U B R O U T I N E =======================================


game_sub_6C6E:        ; CODE XREF: game_sub_6BD5+E0p
    exx
    inc l
    inc l
    ld  a, (hl)
    exx
    ld  (game_word_E1C4), hl
    exx
    and 3
    ret z
    dec a
    jr  z, loc_6C9F
    dec a
    jr  z, loc_6C8A
    push  bc
    push  de
    call  game_sub_693B
    call  c, game_sub_6CA3
    pop de
    pop bc

loc_6C8A:       ; CODE XREF: game_sub_6C6E+10j
    exx
    ld  a, b
    exx
    add a, d
    ld  d, a
    call  game_sub_693B
    ret nc
    ld  hl, (game_word_E310)
    inc l
    inc l
    res 1, (hl)
    set 3, (hl)
    jp  loc_6BFB
; ---------------------------------------------------------------------------

loc_6C9F:       ; CODE XREF: game_sub_6C6E+Dj
    call  game_sub_693B
    ret nc
; End of function game_sub_6C6E


; =============== S U B R O U T I N E =======================================


game_sub_6CA3:        ; CODE XREF: game_sub_6C6E+17p
    ld  hl, (game_word_E310)
    inc l
    inc l
    res 0, (hl)
    set 2, (hl)
    jp  loc_6BFB
; End of function game_sub_6CA3

; ---------------------------------------------------------------------------
; START OF FUNCTION CHUNK FOR game_sub_6BD5

loc_6CAF:       ; CODE XREF: game_sub_6BD5+Fj
    exx
    ld  b, 40h ; '@'
    ld  hl, 1004h
    call  game_sub_6C6E
    ld  a, (game_byte_E1CE)
    and a
    ret z
    ld  a, (game_word_E310)
    and 0F0h ; ''
    push  af
    ld  hl, game_unk_E290
    add a, l
    ld  l, a
    ld  (hl), 0
    pop af
    ld  hl, game_unk_E114
    rra
    rra
    call  add_a_to_hl ; HL=HL+A
    ld  (hl), 0C3h ; ''
    ret
; END OF FUNCTION CHUNK FOR game_sub_6BD5
; ---------------------------------------------------------------------------
; START OF FUNCTION CHUNK FOR game_sub_6B85

loc_6CD6:       ; CODE XREF: game_sub_6B85+16j
    ld  hl, (game_word_E310)
    inc l
    inc l
    ld  (hl), 2
    jp  loc_6BFB
; ---------------------------------------------------------------------------

loc_6CE0:       ; CODE XREF: game_sub_6B85:loc_6BAFj
    ld  hl, (game_word_E310)
    ld  de, 0Bh
    add hl, de
    ld  (hl), 2
    jp  loc_6BFB
; END OF FUNCTION CHUNK FOR game_sub_6B85
; ---------------------------------------------------------------------------
; START OF FUNCTION CHUNK FOR game_sub_6BD5

loc_6CEC:       ; CODE XREF: game_sub_6BD5+21j
    call  game_sub_6BF9
    ld  hl, game_byte_E1DA
    inc (hl)
    ld  a, (game_byte_E191)
    and a
    ret nz
    ld  a, (hl)
    cp  5
    ret nz
    ld  de, 1000h
    call  game_sub_424C
    ld  hl, (game_word_E310)
    ld  (hl), 10h
    ret
; END OF FUNCTION CHUNK FOR game_sub_6BD5
; ---------------------------------------------------------------------------
; START OF FUNCTION CHUNK FOR game_sub_6D36

loc_6D08:       ; CODE XREF: game_sub_6D36+Dj
    inc l
    inc l
    ld  a, (hl)
    dec l
    dec l
    dec a
    jp  m, loc_6D45
    ld  b, a
    add a, a
    add a, a
    add a, b
    ld  de, byte_6D2C
    call  add_a_to_de ; DE=DE+A
    ld  a, (de)
    ld  (hl), a
    inc l
    inc de
    ld  (hl), 7
    ld  a, 0Bh
    add a, l
    ld  l, a
    ex  de, hl
    ld  bc, 4
    ldir
    ret
; ---------------------------------------------------------------------------
byte_6D2C:  db 10h      ; DATA XREF: game_sub_6D36-21o
    db 0A8h
    db 0Fh
    db 0ACh
    db 1
    db 11h
    db 0B0h
    db 1
    db 0B4h
    db 0Fh
; END OF FUNCTION CHUNK FOR game_sub_6D36

; =============== S U B R O U T I N E =======================================


game_sub_6D36:        ; CODE XREF: game_sub_499C:loc_4997p
          ; ROM:558Bj ...

; FUNCTION CHUNK AT 6D08 SIZE 0000002E BYTES

    ld  hl, (game_word_E310)
    ld  a, (hl)
    cp  0Ah
    push  af
    call  z, game_sub_4989
    pop af
    cp  5
    jr  z, loc_6D08

loc_6D45:       ; CODE XREF: game_sub_6D36-28j
    ld  (hl), 0
    ld  de, game_byte_E194
    ld  a, (de)
    dec a
    ld  (de), a
    ld  a, l
    rra
    and 78h ; 'x'
    ld  hl, game_unk_E0D4
    add a, l
    ld  l, a
    jr  nc, loc_6D59
    inc h

loc_6D59:       ; CODE XREF: game_sub_6D36+20j
    ld  (hl), 0C3h ; ''
    inc hl
    inc hl
    inc hl
    inc hl

loc_6D5F:       ; DATA XREF: game_sub_6BF9+3Eo
    ld  (hl), 0C3h ; ''
    ret
; ---------------------------------------------------------------------------
    db 50h
    db 0
    db 80h
    db 0
    db 80h
    db 0
    db 50h
    db 0
    db 20h
    db 0
    db 70h
    db 0
    db 0
    db 0
    db 0
    db 1
    db 0
    db 1
    db 50h
    db 0
    db 0
    db 1
    db 0
    db 0
    db 50h
    db 0
    db 80h
    db 0
    db 80h
    db 0
    db 0
    db 10h
    db 0
    db 0
; End of function game_sub_6D36


; =============== S U B R O U T I N E =======================================


load_game_pat_gen_col:      ; CODE XREF: state3_sub_41E5+18j
          ; init_demo+3p
    ld  de, byte_6DCA ; game pattern generator data
    ld  hl, 2200h
    call  uncompress2vram3blocks
    ld  de, byte_702B ; game color data
    ld  hl, 200h
    jp  uncompress2vram3blocks
; End of function load_game_pat_gen_col


; =============== S U B R O U T I N E =======================================


update_game_pat_gen:      ; CODE XREF: update_game:loc_45A0p
    ld  hl, game_byte_E1D9
    ld  a, (hl)
    and a
    jr  nz, loc_6DA5
    ld  a, (game_byte_E140)
    dec a
    ret nz
    ld  (hl), 1
    ret
; ---------------------------------------------------------------------------

loc_6DA5:       ; CODE XREF: update_game_pat_gen+5j
    dec a
    ret nz
    inc (hl)
    ld  de, byte_70DE ; pattern generator data
    ld  a, (game_byte_E1D6)
    dec a
    jr  z, loc_6DB4
    ld  de, byte_7323 ; pattern generator data

loc_6DB4:       ; CODE XREF: update_game_pat_gen+19j
    ld  hl, 2580h
    push  af
    call  uncompress2vram3blocks
    pop af
    ld  de, byte_7285 ; color data
    jr  z, loc_6DC4
    ld  de, byte_74A7 ; color data

loc_6DC4:       ; CODE XREF: update_game_pat_gen+29j
    ld  hl, 580h
    jp  uncompress2vram3blocks
; End of function update_game_pat_gen

; ---------------------------------------------------------------------------
byte_6DCA:  db 0FDh, 0, 0, 19h, 0Eh, 20h, 0C0h, 8, 4, 12h, 2, 4, 44h
          ; DATA XREF: load_game_pat_gen_colo
    db 0Ch, 8, 20h, 0, 8, 4Ch, 82h, 80h, 40h, 10h, 8, 0, 0 ; game pattern generator data
    db 42h, 0, 10h, 0, 2, 0, 8, 0, 0, 80h, 4, 4Bh, 3Eh, 0
    db 6, 0, 41h, 26h, 1Ch, 0, 20h, 90h, 10h, 0, 80h, 0E0h
    db 0E0h, 0F8h, 0FCh, 0FCh, 0FEh, 0FEh, 0FCh, 0FCh, 0F8h
    db 0E0h, 0E0h, 80h, 0, 0, 1, 7, 7, 1Fh, 3Fh, 3Fh, 7Fh
    db 7Fh, 3Fh, 3Fh, 1Fh, 7, 7, 1, 0, 0FFh, 7Fh, 7Fh, 3Fh
    db 3Fh, 0Fh, 1, 0, 0, 1, 1, 3, 1Fh, 3Fh, 7Fh, 7Fh, 0FFh
    db 0FEh, 0FCh, 0F0h, 0F0h, 0F0h, 0E0h, 0C0h, 0, 80h, 80h
    db 0C0h, 0F8h, 0FCh, 0FEh, 0FEh, 3, 7, 7, 0Fh, 0Fh, 3Fh
    db 7Fh, 0FFh, 3Fh, 1Fh, 7, 3, 1, 3, 0, 0D4h, 0FCh, 0F8h
    db 0E0h, 0C0h, 80h, 0, 0, 0, 80h, 0C0h, 0C0h, 0E0h, 0F8h
    db 0FCh, 0FEh, 0FFh, 0, 0, 18h, 4, 4Eh, 8Bh, 5, 0, 7Fh
    db 7Fh, 3Fh, 3Fh, 1Fh, 0Fh, 3, 3, 3, 7, 7, 0Fh, 0Fh, 3Fh
    db 7Fh, 0FFh, 80h, 80h, 0A8h, 40h, 80h, 80h, 80h, 40h
    db 0C0h, 0F8h, 1Ch, 36h, 2, 6, 2, 15h, 80h, 60h, 84h, 73h
    db 2Ch, 7, 2, 1, 0F0h, 0E0h, 0E0h, 0C0h, 0C0h, 80h, 80h
    db 0, 0FFh, 0FCh, 0E8h, 0C0h, 80h, 0C0h, 0C0h, 80h, 0
    db 80h, 0, 0, 4, 80h, 83h, 0FFh, 0F8h, 0C0h, 5, 0, 0B0h
    db 4, 2, 1, 0, 84h, 42h, 42h, 63h, 20h, 30h, 8, 0Ch, 6
    db 2, 1, 1, 4, 0Ah, 0Bh, 94h, 64h, 8Ah, 72h, 63h, 40h
    db 3Eh, 90h, 4Fh, 28h, 0AFh, 84h, 0D6h, 0F8h, 3, 1, 1
    db 1, 7, 1Dh, 2Ah, 3, 0Fh, 1Fh, 3Fh, 3Fh, 7Fh, 7Fh, 3Fh
    db 8, 1, 7, 0, 0B1h, 0FFh, 4Eh, 2Ah, 99h, 0Ah, 5, 2, 1
    db 40h, 2, 28h, 8, 40h, 0, 8, 2, 0, 40h, 44h, 10h, 10h
    db 2, 50h, 44h, 0, 0F6h, 0BCh, 78h, 0F1h, 0A0h, 0C4h, 80h
    db 0, 31h, 18h, 66h, 91h, 43h, 6Dh, 82h, 31h, 0, 0Ch, 40h
    db 3, 30h, 0, 66h, 0, 8, 0, 81h, 0E7h, 6, 21h, 2, 0E7h
    db 3, 21h, 1, 0E7h, 3, 0, 81h, 0FFh, 7, 0, 8, 80h, 98h
    db 0C0h, 0, 0, 6, 0, 0, 30h, 0, 80h, 0C0h, 60h, 0F0h, 98h
    db 0FCh, 66h, 0D9h, 1, 3, 6, 0Fh, 19h, 3Fh, 66h, 0BFh
    db 40h, 0, 40h, 0, 0A9h, 0FEh, 0FCh, 0F8h, 0F0h, 0E0h
    db 0C0h, 80h, 0, 0, 1, 3, 7, 0Fh, 1Fh, 3Fh, 7Fh, 0, 80h
    db 0C0h, 0E0h, 0F0h, 0F8h, 0FCh, 0FEh, 7Fh, 3Fh, 1Fh, 0Fh
    db 7, 3, 1, 0, 0, 18h, 3Ch, 16h, 3Eh, 1Ch, 0, 0, 78h, 6
    db 8, 92h, 78h, 0, 0FFh, 0, 0, 0, 0FFh, 0, 0, 0, 0FFh
    db 1, 1, 1, 0FFh, 0, 0, 1Eh, 16h, 2, 86h, 4Eh, 0, 0EEh
    db 22h, 22h, 0EEh, 4, 0, 81h, 6, 4, 0, 8Bh, 0C0h, 0, 0
    db 2, 2, 0, 0, 0, 40h, 40h, 0FFh, 0Fh, 80h, 81h, 0FFh
    db 7, 0, 81h, 0FFh, 0Fh, 1, 7, 0, 81h, 0FFh, 7, 1, 81h
    db 0FFh, 7, 80h, 0D8h, 7Fh, 0FFh, 0EEh, 22h, 22h, 0EEh
    db 0FFh, 0FFh, 0FFh, 0, 58h, 7Ch, 0D7h, 1, 0Ah, 45h, 3Eh
    db 0, 1, 1, 3, 1Fh, 3Fh, 7Fh, 7Fh, 0, 80h, 80h, 0C0h, 0F8h
    db 0FCh, 0FEh, 0F7h, 1, 3, 1Fh, 3Fh, 3Fh, 7Fh, 0FFh, 0FFh
    db 0, 1, 1, 3, 1Fh, 3Fh, 7Fh, 7Fh, 0, 80h, 80h, 0C0h, 0F8h
    db 0FCh, 0FEh, 0FEh, 0, 1, 1, 3, 1Fh, 3Fh, 7Fh, 7Fh, 0
    db 80h, 80h, 0C0h, 0F8h, 0FCh, 0FEh, 0FEh, 7Fh, 7Fh, 3Fh
    db 1Fh, 3, 1, 1, 0, 0FEh, 0FEh, 0FCh, 0F8h, 0C0h, 80h
    db 80h, 7, 0, 82h, 0Ch, 13h, 3, 1, 2, 3, 83h, 2, 16h, 1Bh
    db 3, 0, 3, 80h, 92h, 0D0h, 0B0h, 93h, 0A3h, 0C3h, 82h
    db 82h, 8Ah, 2, 1, 92h
byte_7023:  db 8Ah, 86h, 82h, 82h, 0A2h, 80h, 0, 0
byte_702B:  db 24h, 1Ch, 81h, 13h, 6, 1Ch, 81h, 13h, 4, 1Ch, 20h, 0BCh
          ; DATA XREF: load_game_pat_gen_col+9o
    db 20h, 0B5h, 28h, 89h, 10h, 68h, 88h, 98h, 0F8h, 98h ; game color data
    db 0F8h, 18h, 0F8h, 98h, 18h, 8, 96h, 5, 18h, 43h, 16h
    db 3, 96h, 5, 16h, 82h, 0F6h, 96h, 5, 86h, 81h, 8Fh, 10h
    db 0FAh, 88h, 0F9h, 0E9h, 0F9h, 0E9h, 0F9h, 0E9h, 0F9h
    db 0E9h, 8, 98h, 8, 0E9h, 90h, 98h, 0E8h, 98h, 98h, 0E8h
    db 98h, 0F8h, 0F8h, 0F9h, 0E9h, 0F9h, 0E9h, 0F9h, 0E9h
    db 0F9h, 0E9h, 10h, 96h, 81h, 0FBh, 6, 19h, 82h, 1Ah, 0FAh
    db 3, 19h, 4, 1Ah, 81h, 11h, 0Fh, 1Ah, 8, 0BAh, 8, 68h
    db 8, 69h, 30h, 0, 70h, 57h, 8, 0C5h, 81h, 75h, 7, 45h
    db 5, 75h, 3, 45h, 2, 75h, 6, 45h, 81h, 75h, 17h, 45h
    db 2, 75h, 6, 45h, 6, 67h, 3, 47h, 5, 0C7h, 2, 67h, 19h
    db 0F5h, 1Fh, 15h, 7, 0F5h, 83h, 1Fh, 0BEh, 0F5h, 3, 15h
    db 3, 0B5h, 4, 0CBh, 3, 1Ch, 81h, 1Bh, 10h, 95h, 8, 96h
    db 10h, 95h, 20h, 0A5h, 7, 0F5h, 83h, 75h, 40h, 40h, 0Eh
    db 0F0h, 6, 0F4h, 82h, 0F0h, 40h, 6, 0F4h, 2, 0F0h, 0
byte_70DE:  db 0D1h, 1, 3, 7, 0Fh, 1Fh, 3Fh, 7Fh, 0FFh, 0FFh, 7Fh
          ; DATA XREF: update_game_pat_gen+12o
    db 3Fh, 1Fh, 0Fh, 7, 3, 1, 3Ch, 76h, 0DFh, 0BDh, 2Bh, 0F5h ; pattern generator data
    db 5Ah, 3Ch, 80h, 0C0h, 0E0h, 0F0h, 0F8h, 0FCh, 0FEh, 0FFh
    db 0FFh, 0FEh, 0FCh, 0F8h, 0F0h, 0E0h, 0C0h, 80h, 0F5h
    db 0EAh, 0D4h, 0A8h, 50h, 0A0h, 40h, 80h, 80h, 40h, 0A0h
    db 50h, 0A8h, 0D4h, 0EAh, 0F5h, 1, 6, 0Ch, 18h, 30h, 60h
    db 0C0h, 80h, 80h, 40h, 60h, 30h, 38h, 1Ch, 0Eh, 7, 7
    db 0Eh, 1Ch, 38h, 30h, 60h, 40h, 80h, 0FFh, 7, 2, 6, 0E0h
    db 0BDh, 0FFh, 80h, 0AFh, 57h, 2Bh, 15h, 0Ah, 5, 2, 1
    db 1, 2, 5, 0Ah, 15h, 2Bh, 57h, 0AFh, 80h, 60h, 30h, 1Ch
    db 0Eh, 7, 3, 1, 1, 2, 6, 0Ch, 1Ch, 38h, 70h, 0E0h, 0E0h
    db 70h, 38h, 1Ch, 0Ch, 6, 2, 1, 1, 3, 7, 0Eh, 1Ch, 38h
    db 60h, 80h, 80h, 0C0h, 0E0h, 70h, 38h, 1Ch, 6, 1, 1, 3
    db 0FFh, 5, 83h, 4, 0C0h, 0E7h, 0, 0FFh, 0FBh, 0D5h, 3Fh
    db 68h, 0C8h, 0C4h, 0C4h, 0A2h, 0B1h, 8Fh, 0FCh, 26h, 83h
    db 81h, 87h, 0B8h, 0C0h, 0E0h, 81h, 82h, 84h, 98h, 0E1h
    db 0C2h, 64h, 3Fh, 0D8h, 0E4h, 0A3h, 0B1h, 11h, 11h, 12h
    db 0FCh, 3Fh, 64h, 0C2h, 81h, 0C1h, 0BFh, 87h, 86h, 0FCh
    db 12h, 21h, 21h, 0E1h, 0E6h, 0F4h, 0F8h, 8Fh, 97h, 0A7h
    db 0C3h, 82h, 84h, 44h, 3Fh, 0B0h, 50h, 0BCh, 0E3h, 41h
    db 21h, 12h, 0FCh, 3Fh, 64h, 83h, 8Fh, 0FFh, 9Dh, 9Fh
    db 0BEh, 0FCh, 12h, 0E1h, 0F1h, 0F9h, 0EBh, 0BEh, 0D4h
    db 0BFh, 0BDh, 0DFh, 9Dh, 8Fh, 8Bh, 48h, 3Fh, 0ACh, 48h
    db 0BCh, 6Fh, 0F9h, 0E1h, 42h, 0FCh, 7, 7, 0, 5, 7, 2
    db 0E0h, 81h, 0, 5, 0E0h, 3, 38h, 0Ah, 0FFh, 3, 38h, 5
    db 7, 83h, 0, 7, 7, 5, 0E0h, 83h, 0, 0E0h, 0E0h, 3, 1Ch
    db 0Ah, 80h, 3, 1Ch, 81h, 0FFh, 7, 0, 8, 80h, 0B4h, 7
    db 6, 5, 7, 6, 7, 87h, 0C0h, 0E0h, 0A0h, 40h, 0A0h, 0C0h
    db 0A0h, 0E0h, 0FFh, 0F7h, 0F7h, 5, 2, 5, 6, 3, 7, 0DFh
    db 0DFh, 40h, 0C0h, 40h, 0C0h, 40h, 0C0h, 3, 1, 0, 0, 0FFh
    db 0FFh, 5Fh, 37h, 57h, 3Bh, 57h, 0FFh, 0, 0, 1, 3, 0EBh
    db 0D5h, 0EBh, 3Fh, 4, 0C0h, 82h, 0E0h, 60h
byte_723E:  db 6, 20h, 82h, 80h, 0C0h, 6, 0E0h, 5, 83h, 2, 3, 81h
    db 1, 5, 20h, 83h, 1Fh, 7Fh, 0FFh, 5, 2, 2, 0FEh, 85h
    db 0FFh, 3Fh, 7Fh, 0F0h, 0E0h, 4, 0C0h, 88h, 0FCh, 0FEh
    db 7, 3, 1, 0, 7Eh, 0FCh, 5, 0C0h, 85h, 0E0h, 70h, 3Fh
    db 0E3h, 80h, 3, 0, 93h, 1, 2, 0FCh, 80h, 0C0h, 0E0h, 0F0h
    db 0F8h, 0FCh, 0FEh, 0FFh, 0FFh, 0FEh, 0FCh, 0F8h, 0F0h
    db 0E0h, 0C0h, 80h, 0
byte_7285:  db 10h, 0F5h, 4, 1Eh, 84h, 16h, 19h, 1Eh, 1Eh, 10h, 45h
          ; DATA XREF: update_game_pat_gen+26o
    db 38h, 0FEh, 7Fh, 1Eh, 10h, 1Eh, 81h, 19h, 5, 1Eh, 2 ; color data
    db 19h, 2, 1Eh, 81h, 19h, 6, 1Eh, 84h, 19h, 1Eh, 19h, 16h
    db 4, 1Eh, 3, 4Fh, 2, 0EFh, 81h, 1Fh, 5, 4Fh, 2, 0EFh
    db 83h, 1Fh, 4Fh, 4Fh, 3, 0E4h, 5, 0F1h, 5, 0F4h, 3, 0E4h
    db 83h, 4Fh, 41h, 0F1h, 3, 0E1h, 2, 41h, 83h, 4Fh, 41h
    db 0F1h, 3, 0E1h, 2, 41h, 3, 0E4h, 0Ah, 0F1h, 3, 0E4h
    db 10h, 0F1h, 81h, 0FEh, 6, 1Eh, 82h, 1Fh, 0FEh, 6, 1Eh
    db 81h, 0FEh, 10h, 1Eh, 5, 0FEh, 6, 1Eh, 5, 0FEh, 3, 1Eh
    db 81h, 0FEh, 4, 1Eh, 81h, 1Fh, 7, 1Eh, 2, 0FEh, 81h, 0F1h
    db 5, 0FEh, 6, 1Eh, 81h, 1Fh, 6, 1Eh, 83h, 0FEh, 1Eh, 1Eh
    db 6, 0FEh, 2, 1Fh, 2, 1Eh, 6, 16h, 2, 1Eh, 4, 16h, 2
    db 86h, 83h, 16h, 18h, 18h, 4, 19h, 81h, 1Eh, 5, 89h, 2
    db 19h, 81h, 1Eh, 10h, 14h, 0
byte_7323:  db 3, 0, 8Dh, 3, 0Fh, 1Fh, 3Fh, 7Fh, 0, 1, 3, 7, 0Fh, 0Fh
          ; DATA XREF: update_game_pat_gen+1Bo
    db 1Fh, 1Fh, 3, 3Fh, 4, 7Fh, 2, 0FFh, 4, 7Fh, 3, 3Fh, 81h ; pattern generator data
    db 0FFh, 4, 0FEh, 3, 0FCh, 2, 1Fh, 2, 0Fh, 89h, 7, 3, 1
    db 0, 7Fh, 3Fh, 1Fh, 0Fh, 3, 3, 0, 6, 0FFh, 0B2h, 1Fh
    db 1, 0, 3Ch, 18h, 81h, 99h, 81h, 5Ah, 42h, 42h, 5Ah, 81h
    db 99h, 81h, 18h, 3Ch, 0, 1Ch, 3, 40h, 6Ah, 6Ah, 40h, 3
    db 1Ch, 38h, 0C0h, 2, 56h, 56h, 2, 0C0h, 38h, 0, 0F0h
    db 0FEh, 0C0h, 0F0h, 0F8h, 0FCh, 0FEh, 0FEh, 80h, 0C0h
    db 0E0h, 0F0h, 0F0h, 0F8h, 0F8h, 3, 0FCh, 4, 0FEh, 7, 0FFh
    db 0C5h, 0F8h, 80h, 0F8h, 0F8h, 0F0h, 0F0h, 0E0h, 0C0h
    db 80h, 0FEh, 0FEh, 0FCh, 0F8h, 0F0h, 0C0h, 0FEh, 0F0h
    db 0, 1, 1Fh, 0FFh, 0F8h, 0C3h, 1Fh, 7Fh, 0FFh, 80h, 0F8h
    db 0FFh, 3Fh, 0EFh, 0FBh, 0FFh, 0FFh, 0FEh, 0FDh, 0F8h
    db 0F0h, 0E0h, 0C6h, 86h, 0E0h, 7Fh, 0BFh, 1Fh, 0Fh, 7
    db 63h, 61h, 7, 0E0h, 86h, 0C6h, 0E0h, 0F0h, 0F8h, 0FDh
    db 0FEh, 7, 61h, 63h, 7, 0Fh, 1Fh, 0BFh, 7Fh, 0FFh, 0FFh
    db 4Fh, 5, 0FFh, 98h, 0F7h, 0EFh, 0DFh, 0FFh, 1, 3, 7
    db 0Fh, 10h, 30h, 70h, 0F0h, 0F0h, 0E0h, 0C0h, 80h, 8
    db 0Ch, 0Eh, 0Fh, 0Fh, 7, 3, 1, 4, 0, 88h, 80h, 0C0h, 0E0h
    db 0F0h, 1Fh, 3Eh, 7Ch, 0F8h, 4, 0, 84h, 0F8h, 7Ch, 3Eh
byte_7400:  db 1Fh, 8, 0, 84h, 0F8h, 7Ch, 3Eh, 1Fh, 4, 0, 88h, 1Fh
          ; DATA XREF: ROM:55FEo  ROM:5602o
    db 3Eh, 7Ch, 0F8h, 0Fh, 7, 3, 1, 4, 0, 84h, 0F0h, 0E0h
    db 0C0h, 80h, 4, 0, 90h, 80h, 0C0h, 0E0h, 0F0h, 0F0h, 70h
    db 30h, 10h, 1, 3, 7, 0Fh, 0Fh, 0Eh, 0Ch, 8, 6, 0, 4, 0FFh
    db 81h, 0, 5, 0FFh, 2, 0F8h, 3, 0FFh, 85h, 0, 0FFh, 0FFh
    db 0, 0, 3, 0FFh, 81h, 0, 5, 0FFh, 2, 0FCh, 3, 0F8h, 85h
    db 0FCh, 0F8h, 0F0h, 0E0h, 80h, 6, 0, 8Bh, 80h, 0E0h, 0F0h
    db 0F8h, 0FCh, 0F0h
byte_7458:  db 0E0h, 0E0h, 0C0h, 0C0h, 80h, 4, 0, 8Eh, 80h, 0C0h, 0C0h
    db 0E0h, 0E0h, 0F0h, 3Ch, 76h, 0DFh, 0BDh, 0D3h, 0E9h
    db 52h, 3Ch, 8, 0FEh, 8, 7Fh, 81h, 0, 5, 0FFh, 3, 0, 7
    db 0FFh, 81h, 0, 7, 0FEh, 81h, 0C0h, 7, 1Fh, 81h, 3, 7
    db 0F8h, 3, 0FFh, 5, 0, 3, 0F8h, 4, 0FCh, 2, 0FEh, 4, 0FCh
    db 3, 0F8h, 81h, 0FFh, 7, 10h, 6, 0FFh, 2, 0, 81h, 0FFh
    db 5, 0, 4, 0FFh, 2, 0, 4, 0FFh, 0
byte_74A7:  db 20h, 15h, 8, 14h, 18h, 15h, 20h, 0EFh, 3, 45h, 5, 14h
          ; DATA XREF: update_game_pat_gen+2Bo
    db 81h, 45h, 1Eh, 14h, 81h, 45h, 5, 14h, 3, 45h, 3, 15h ; color data
    db 5, 1Fh, 3, 14h, 0Ch, 1Fh, 81h, 0EFh, 7, 1Fh, 2, 0EFh
    db 7, 1Fh, 81h, 0EFh, 13h, 1Fh, 5Ch, 61h, 81h, 59h, 7
    db 51h, 2, 41h, 6, 1Fh, 5, 45h, 3, 1Fh, 5, 45h, 6, 1Fh
    db 25h, 45h, 4, 1Fh, 84h, 16h, 18h, 1Fh, 1Fh, 10h, 19h
    db 6, 1Fh, 2, 15h, 8, 16h, 2, 8Fh, 2, 6Fh, 3, 8Fh, 85h
    db 9Fh, 0F6h, 18h, 16h, 16h, 3, 18h, 85h, 19h, 0F6h, 18h
    db 16h, 16h, 3, 18h, 81h, 19h, 8, 15h, 10h, 45h, 8, 61h
    db 8, 15h, 6, 91h, 2, 51h, 81h, 0F8h, 3, 86h, 84h, 68h
    db 86h, 86h, 9Fh, 0

; =============== S U B R O U T I N E =======================================


game_sub_7522:        ; CODE XREF: game_sub_45A6+44p
    ld  hl, (game_word_E1B8)
    jr  loc_752E
; ---------------------------------------------------------------------------

loc_7527:       ; CODE XREF: update_game+6Cj
    ld  hl, (game_word_E1B8)
    ld  a, l
    and 3Fh ; '?'
    ret nz

loc_752E:       ; CODE XREF: game_sub_7522+3j
    xor a
    ld  (game_byte_E1B0), a
    ld  (game_byte_E1C1), a
    ld  (game_byte_E1D2), a
    ld  a, l
    rr  h
    rra
    rr  h
    rra
    rr  h
    rra
    rr  h
    rra
    rr  h
    rra
    rr  h
    rra
    ld  hl, byte_757C
    call  add_a_to_hl ; HL=HL+A
    ld  a, (hl)
    ld  (game_byte_E320), a
    add a, a
    ld  b, a
    add a, a
    add a, b
    ld  de, byte_759C
    call  add_a_to_de ; DE=DE+A
    ld  b, 2
    ld  hl, game_byte_E321

loc_7564:       ; CODE XREF: game_sub_7522+57j
    ld  a, (de)
    ld  (hl), a
    inc l
    inc de
    ld  (hl), 0
    inc l
    ld  a, (de)
    ld  (hl), a
    inc l
    inc de
    ld  (hl), 0
    inc l
    ld  a, (de)
    ld  (hl), a
    inc l
    inc de
    ld  (hl), 0
    inc l
    djnz  loc_7564
    ret
; End of function game_sub_7522

; ---------------------------------------------------------------------------
byte_757C:  db 0, 2, 1, 5, 9, 6, 2, 16h, 7, 14h, 1, 0Bh, 4, 7, 8, 17h
          ; DATA XREF: game_sub_7522+29o
    db 0Ch, 0Ah, 15h, 12h, 0Eh, 0Dh, 9, 18h, 10h, 0Fh, 11h
    db 13h, 15h, 14h, 18h, 18h
byte_759C:  db 1, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 5, 6, 6, 0, 0, 0
          ; DATA XREF: game_sub_7522+37o
    db 3, 0, 0, 0, 0, 0, 9, 18h, 10h, 0, 0, 0, 4, 0Ah, 5, 0
    db 0, 0, 0Ah, 1Bh, 0Dh, 1, 0, 0, 3, 0, 1, 5, 6, 6, 4, 0Bh
    db 7, 0, 0, 0, 2, 2, 2, 0, 0, 0, 6, 0Fh, 7, 0, 0, 0, 2
    db 0, 0, 5, 6, 6, 3, 1, 2, 0, 0, 0, 7, 12h, 0Ah, 0, 0
    db 0, 1, 1, 1, 0, 0, 0, 2, 1, 1, 4, 7, 7, 0Bh, 1Eh, 2
    db 0, 0, 0, 8, 15h, 0Dh, 0, 0, 0, 4, 0Ah, 5, 5, 5, 5, 3
    db 2, 2, 5, 7, 7, 5, 5, 5, 0, 0, 0, 2, 1, 1, 5, 6, 6, 0Dh
    db 13h, 0Ch, 0, 0, 0, 0Eh, 13h, 0Ch, 0, 0, 0, 0Fh, 13h
    db 0Ch, 0, 0, 0

; =============== S U B R O U T I N E =======================================


game_sub_7632:        ; CODE XREF: game_sub_4773+Cp
    ld  b, 2
    ld  hl, game_byte_E321

loc_7637:       ; CODE XREF: game_sub_7632+11j
    ld  a, (hl)
    inc l
    and a
    jr  z, loc_763F
    dec (hl)
    jr  z, loc_7647

loc_763F:       ; CODE XREF: game_sub_7632+8j
    ld  de, 5
    add hl, de
    djnz  loc_7637
    scf
    ret
; ---------------------------------------------------------------------------

loc_7647:       ; CODE XREF: game_sub_7632+Bj
    ld  (game_byte_E1B0), a
    inc l
    ld  a, (game_byte_E1D3)
    add a, (hl)
    add a, a
    ld  de, off_767A
    call  add_a_to_de ; DE=DE+A
    inc l
    ld  a, (hl)
    inc (hl)
    push  hl
    ex  de, hl
    ld  e, (hl)
    inc hl
    ld  d, (hl)
    ex  de, hl
    ld  c, (hl)
    call  add_a_to_hl ; HL=HL+A
    ld  a, (hl)
    pop hl
    cp  0FFh
    jr  nz, loc_766C
    ld  a, c
    ld  (hl), 0

loc_766C:       ; CODE XREF: game_sub_7632+35j
    dec l
    dec l
    ld  (hl), a
    ld  hl, game_byte_E1B7
    ld  a, (game_byte_E1B0)
    call  game_sub_66F8
    xor a
    ret
; End of function game_sub_7632

; ---------------------------------------------------------------------------
off_767A: dw byte_76BC    ; DATA XREF: game_sub_7632+1Eo
    dw byte_76C1
    dw byte_76C7
    dw byte_76CD
    dw byte_76D3
    dw byte_76D9
    dw byte_76DB
    dw byte_76DD
    dw byte_76DF
    dw byte_76E1
    dw byte_76BC
    dw byte_76C1
    dw byte_76C7
    dw byte_76CD
    dw byte_76D3
    dw byte_76E3
    dw byte_76E8
    dw byte_76EE
    dw byte_76F4
    dw byte_76F4
    dw byte_76F4
    dw byte_76C7
    dw byte_76CD
    dw byte_76D3
    dw byte_76DD
    dw byte_76DF
    dw byte_76E1
    dw byte_76F6
    dw byte_76F9
    dw byte_76FC
    dw byte_76FF
    dw byte_7704
    dw byte_7709
byte_76BC:  db 18h, 18h, 18h, 60h, 0FFh ; DATA XREF: ROM:off_767Ao
          ; ROM:768Eo
byte_76C1:  db 14h, 14h, 14h, 14h, 58h, 0FFh ; DATA XREF: ROM:767Co
          ; ROM:7690o
byte_76C7:  db 10h, 10h, 10h, 10h, 50h, 0FFh ; DATA XREF: ROM:767Eo
          ; ROM:7692o ...
byte_76CD:  db 0Ch, 0Ch, 0Ch, 0Ch, 48h, 0FFh ; DATA XREF: ROM:7680o
          ; ROM:7694o ...
byte_76D3:  db 0Ah, 0Ah, 0Ah, 0Ah, 40h, 0FFh ; DATA XREF: ROM:7682o
          ; ROM:7696o ...
byte_76D9:  db 60h, 0FFh    ; DATA XREF: ROM:7684o
byte_76DB:  db 50h, 0FFh    ; DATA XREF: ROM:7686o
byte_76DD:  db 40h, 0FFh    ; DATA XREF: ROM:7688o  ROM:76AAo
byte_76DF:  db 38h, 0FFh    ; DATA XREF: ROM:768Ao  ROM:76ACo
byte_76E1:  db 30h, 0FFh    ; DATA XREF: ROM:768Co  ROM:76AEo
byte_76E3:  db 1Ch, 18h, 20h, 60h, 0FFh ; DATA XREF: ROM:7698o
byte_76E8:  db 18h, 18h, 18h, 18h, 50h, 0FFh ; DATA XREF: ROM:769Ao
byte_76EE:  db 16h, 16h, 16h, 16h, 30h, 0FFh ; DATA XREF: ROM:769Co
byte_76F4:  db 58h, 0FFh    ; DATA XREF: ROM:769Eo  ROM:76A0o ...
byte_76F6:  db 40h, 0C0h, 0FFh  ; DATA XREF: ROM:76B0o
byte_76F9:  db 38h, 80h, 0FFh ; DATA XREF: ROM:76B2o
byte_76FC:  db 30h, 60h, 0FFh ; DATA XREF: ROM:76B4o
byte_76FF:  db 18h, 20h, 20h, 60h, 0FFh ; DATA XREF: ROM:76B6o
byte_7704:  db 20h, 20h, 18h, 50h, 0FFh ; DATA XREF: ROM:76B8o
byte_7709:  db 18h, 20h, 28h, 20h, 40h, 0FFh ; DATA XREF: ROM:76BAo
byte_770F:  db 55, 119, 57, 119, 60, 119, 64, 119, 68, 119, 73, 119
          ; DATA XREF: game_sub_66F8+1Fo
    db 75, 119, 77, 119, 79, 119, 81, 119, 55, 119, 55, 119
    db 55, 119, 83, 119, 87, 119, 91, 119, 94, 119, 96, 119
    db 98, 119, 100, 119, 0, 255, 64, 72, 255, 56, 48, 44
    db 255, 32, 40, 48, 255, 32, 16, 24, 32, 255, 96, 255
    db 80, 255, 48, 255, 40, 255, 32, 255, 48, 40, 56, 255
    db 40, 32, 48, 255, 32, 24, 255, 26, 255, 22, 255, 16
    db 255, 254, 255

; =============== S U B R O U T I N E =======================================


game_sub_7766:        ; CODE XREF: update_game+41p
    ld  a, (frame_count)
    and 0Fh
    ret nz
    ld  hl, game_byte_E140
    ld  a, (hl)
    and 3
    dec a
    jp  z, loc_77F3
    dec a
    jp  z, loc_77FD
    dec a
    jp  z, loc_780B
    ld  a, (game_byte_E1D1)
    ld  c, 0
    cp  47h ; 'G'
    jr  nz, loc_7788
    inc c

loc_7788:       ; CODE XREF: game_sub_7766+1Fj
    cp  0E7h ; ''
    jr  nz, loc_778E
    ld  c, 2

loc_778E:       ; CODE XREF: game_sub_7766+24j
    ld  a, c
    and a
    ret z
    ld  (hl), 1
    ld  (game_byte_E1D6), a
    inc hl
    ld  (hl), 0
    inc hl
    ld  (hl), 0
    inc hl
    dec a
    ld  a, 4
    jr  z, loc_77A4
    ld  a, 2

loc_77A4:       ; CODE XREF: game_sub_7766+3Aj
    ld  (hl), a
    ld  hl, 2000h
    ld  (game_word_E1D7), hl
    ld  hl, game_unk_E150
    ld  a, c
    dec a
    ld  b, 4
    ld  de, byte_7828
    jr  z, loc_77BC
    ld  de, byte_7830
    ld  b, 2

loc_77BC:       ; CODE XREF: game_sub_7766+4Fj
    ld  a, c
    dec a
    ld  c, 20h ; ' '
    jr  z, loc_77C4
    ld  c, 14h

loc_77C4:       ; CODE XREF: game_sub_7766+5Aj
    ld  a, (game_byte_E1D3)
    add a, a
    add a, a
    sub c
    neg
    ld  (game_byte_E144), a
    ld  (game_byte_E1B1), a
    xor a
    ld  (game_byte_E1DE), a

loc_77D6:       ; CODE XREF: game_sub_7766+86j
    ld  (hl), 12h
    inc hl
    ld  (hl), 1
    inc hl
    ld  a, (de)
    ld  (hl), a
    inc de
    inc hl
    ld  a, (de)
    ld  (hl), a
    inc de
    inc hl
    inc hl
    inc hl
    ld  (hl), 0BCh ; ''
    inc hl
    ld  (hl), 6
    inc hl
    djnz  loc_77D6
    ld  a, 91h ; ''
    jp  game_sub_79D8
; ---------------------------------------------------------------------------

loc_77F3:       ; CODE XREF: game_sub_7766+Dj
    inc hl
    inc (hl)
    ld  a, (hl)
    cp  8
    ret c
    dec hl
    ld  (hl), 2
    ret
; ---------------------------------------------------------------------------

loc_77FD:       ; CODE XREF: game_sub_7766+11j
    ld  hl, music_channel2
    ld  a, (hl)
    cp  91h ; ''
    ret z
    ld  a, 88h ; ''
    cp  (hl)
    call  nz, game_sub_79D8
    ret
; ---------------------------------------------------------------------------

loc_780B:       ; CODE XREF: game_sub_7766+15j
    inc hl
    inc (hl)
    ld  a, (hl)
    cp  3Fh ; '?'
    jr  c, loc_7819
    dec hl
    xor a
    ld  (hl), a
    ld  (game_byte_E1D9), a
    ret
; ---------------------------------------------------------------------------

loc_7819:       ; CODE XREF: game_sub_7766+AAj
    cp  14h
    ret nz
    ld  hl, game_byte_E1DE
    ld  a, (hl)
    and a
    ret nz
    inc (hl)
    ld  a, 96h ; ''
    jp  game_sub_79D8
; End of function game_sub_7766

; ---------------------------------------------------------------------------
byte_7828:  db 0Bh, 4Ch, 0Bh, 64h, 23h, 4Ch, 23h, 64h ; DATA XREF: game_sub_7766+4Co
byte_7830:  db 1Bh, 24h, 1Bh, 94h ; DATA XREF: game_sub_7766+51o

; =============== S U B R O U T I N E =======================================


game_sub_7834:        ; CODE XREF: update_game+53p
          ; game_sub_45A6+5Bp
    call  game_sub_7909
    call  game_sub_78A0
    ld  hl, game_unk_E150
    ld  b, 4
    ld  a, (game_byte_E1D6)
    dec a
    jr  z, loc_7847
    ld  b, 2

loc_7847:       ; CODE XREF: game_sub_7834+Fj
    ld  a, (game_byte_E141)
    cp  20h ; ' '
    ret nc
    add a, a
    add a, a
    add a, a
    ld  c, a

loc_7851:       ; CODE XREF: game_sub_7834+39j
    ld  a, (hl)
    inc l
    inc l
    and a
    jr  z, loc_7862
    ld  a, (hl)
    add a, c
    sub 40h ; '@'
    ld  e, a
    sub 0C0h ; ''
    cp  20h ; ' '
    jr  nc, loc_7864

loc_7862:       ; CODE XREF: game_sub_7834+21j
    ld  e, 0C3h ; ''

loc_7864:       ; CODE XREF: game_sub_7834+2Cj
    inc l
    ld  a, (hl)
    inc l
    ld  (hl), e
    inc l
    ld  (hl), a
    inc l
    inc l
    inc l
    djnz  loc_7851
    ret
; End of function game_sub_7834


; =============== S U B R O U T I N E =======================================


game_sub_7870:        ; CODE XREF: update_game:loc_459Ap
          ; game_sub_45A6+5Ep
    ld  hl, game_unk_E154
    ld  de, game_unk_E0C4
    ld  b, 4
    ld  a, (game_byte_E1D6)
    dec a
    jr  z, loc_7880
    ld  b, 2

loc_7880:       ; CODE XREF: game_sub_7870+Cj
          ; game_sub_7870+1Cj
    push  bc
    ld  bc, 4
    ldir
    ld  a, 4
    call  add_a_to_hl ; HL=HL+A
    pop bc
    djnz  loc_7880
    ret
; End of function game_sub_7870


; =============== S U B R O U T I N E =======================================


game_sub_788F:        ; CODE XREF: game_sub_69C9-40p
    ld  a, l
    sub 50h ; 'P'
    and 0F8h ; ''
    rra
    rra
    rra
    ld  hl, game_unk_E145
    call  add_a_to_hl ; HL=HL+A
    ld  (hl), 10h
    ret
; End of function game_sub_788F


; =============== S U B R O U T I N E =======================================


game_sub_78A0:        ; CODE XREF: game_sub_7834+3p

; FUNCTION CHUNK AT 78ED SIZE 00000016 BYTES

    ld  hl, game_unk_E145
    ld  ix, game_unk_E150
    ld  de, 8
    ld  b, 4

loc_78AC:       ; CODE XREF: game_sub_78A0+26j
    ld  a, (hl)
    and a
    jr  z, loc_78C3
    dec a
    ld  (hl), a
    jr  z, loc_78ED
    cp  4
    ld  a, 94h ; ''
    jr  nc, loc_78BC
    ld  a, 9Ch ; ''

loc_78BC:       ; CODE XREF: game_sub_78A0+18j
    ld  (ix+6), a
    ld  (ix+7), 0Bh

loc_78C3:       ; CODE XREF: game_sub_78A0+Ej
          ; game_sub_78A0+2Cj ...
    inc hl
    add ix, de
    djnz  loc_78AC
    ret
; ---------------------------------------------------------------------------

loc_78C9:       ; CODE XREF: game_sub_78A0+5Bj
    call  game_sub_78CE
    jr  loc_78C3
; End of function game_sub_78A0


; =============== S U B R O U T I N E =======================================


game_sub_78CE:        ; CODE XREF: game_sub_78A0:loc_78C9p
          ; game_sub_7909+14p
    ld  a, (ix+0)
    sub 12h
    exx
    ld  hl, byte_7903
    call  add_a_to_hl ; HL=HL+A
    ld  a, (frame_count)
    bit 4, a
    ld  a, (hl)
    jr  z, loc_78E4
    ld  a, 1

loc_78E4:       ; CODE XREF: game_sub_78CE+12j
    exx
    ld  (ix+7), a
    ld  (ix+6), 0BCh ; ''
    ret
; End of function game_sub_78CE

; ---------------------------------------------------------------------------
; START OF FUNCTION CHUNK FOR game_sub_78A0

loc_78ED:       ; CODE XREF: game_sub_78A0+12j
    ld  a, (game_byte_E1D6)
    dec a
    ld  c, 14h
    jr  z, loc_78F7
    ld  c, 17h

loc_78F7:       ; CODE XREF: game_sub_78A0+53j
    ld  a, (ix+0)
    cp  c
    jr  c, loc_78C9
    ld  (ix+0), 0
    jr  loc_78C3
; END OF FUNCTION CHUNK FOR game_sub_78A0
; ---------------------------------------------------------------------------
byte_7903:  db 6, 0Ah, 0Bh, 7, 4, 0 ; DATA XREF: game_sub_78CE+6o

; =============== S U B R O U T I N E =======================================


game_sub_7909:        ; CODE XREF: game_sub_7834p
    ld  a, (game_byte_E1D6)
    ld  b, 4
    dec a
    jr  z, loc_7913
    ld  b, 2

loc_7913:       ; CODE XREF: game_sub_7909+6j
    ld  ix, game_unk_E150

loc_7917:       ; CODE XREF: game_sub_7909+1Cj
    ld  a, (ix+0)
    and a
    jr  z, loc_7920
    call  game_sub_78CE

loc_7920:       ; CODE XREF: game_sub_7909+12j
    ld  de, 8
    add ix, de
    djnz  loc_7917
    ret
; End of function game_sub_7909


; =============== S U B R O U T I N E =======================================


game_sub_7928:        ; CODE XREF: update_game+5Dp
    ld  hl, game_word_E1D7
    ld  a, (hl)
    inc hl
    dec (hl)
    ret nz
    ld  de, byte_793E
    call  add_a_to_de ; DE=DE+A
    ld  a, (de)
    ld  (hl), a
    dec hl
    ld  a, (hl)
    inc a
    and 3
    ld  (hl), a
    ret
; End of function game_sub_7928

; ---------------------------------------------------------------------------
byte_793E:  db 1Fh, 5Fh, 1Fh, 7Fh ; DATA XREF: game_sub_7928+7o

; =============== S U B R O U T I N E =======================================


game_sub_7942:        ; CODE XREF: update_game+60p
    ld  a, (game_byte_E1D6)
    ld  c, a
    ld  hl, game_word_E1D7
    ld  a, (hl)
    inc hl
    dec a
    jr  z, loc_7958
    cp  2
    ret nz
    ld  a, (hl)
    rra
    rra
    and 6
    jr  loc_7961
; ---------------------------------------------------------------------------

loc_7958:       ; CODE XREF: game_sub_7942+Aj
    ld  a, (hl)
    rra
    rra
    and 6
    sub 6
    neg

loc_7961:       ; CODE XREF: game_sub_7942+14j
    ld  hl, byte_7970
    dec c
    jr  z, loc_796A
    ld  hl, byte_79A0

loc_796A:       ; CODE XREF: game_sub_7942+23j
    call  get_hl_a_ptr  ; DE=(HL+A)
    jp  vpokes
; End of function game_sub_7942

; ---------------------------------------------------------------------------
byte_7970:  db 78h, 79h, 82h, 79h, 8Ch, 79h, 96h, 79h, 6Bh, 38h, 0C5h
          ; DATA XREF: game_sub_7942:loc_7961o
    db 0C6h, 0FEh, 8Bh, 38h, 0C7h, 0C8h, 0FFh, 6Bh, 38h, 0C9h
    db 0CAh, 0FEh, 8Bh, 38h, 0CBh, 0CCh, 0FFh, 6Bh, 38h, 0CDh
    db 0CEh, 0FEh, 8Bh, 38h, 0CFh, 0D0h, 0FFh, 6Bh, 38h, 0E7h
    db 0E8h, 0FEh, 8Bh, 38h, 0E9h, 0EAh, 0FFh
byte_79A0:  db 0A8h, 79h, 0B4h, 79h, 0C0h, 79h, 0CCh, 79h, 8Bh, 38h
          ; DATA XREF: game_sub_7942+25o
    db 0E2h, 0E9h, 0E2h, 0FEh, 0ABh, 38h, 0EBh, 0EBh, 0EBh
    db 0FFh, 8Bh, 38h, 0E2h, 0E3h, 0E2h, 0FEh, 0ABh, 38h, 0EBh
    db 0E1h, 0EBh, 0FFh, 8Bh, 38h, 0E5h, 0ECh, 0E4h, 0FEh
    db 0ABh, 38h, 0EBh, 0E1h, 0EBh, 0FFh, 8Bh, 38h, 0ECh, 0ECh
    db 0ECh, 0FEh, 0ABh, 38h, 0E1h, 0E1h, 0E1h, 0FFh

; =============== S U B R O U T I N E =======================================


game_sub_79D8:        ; CODE XREF: game_sub_424C+45p
          ; game_sub_46B4+3Cj ...
    ex  af, af'
    ld  a, (state_flags)
    and 40h ; '@'
    ret z
    ld  a, (game_byte_E1DD)
    and a
    ret nz
    ex  af, af'
; End of function game_sub_79D8


; =============== S U B R O U T I N E =======================================


music_sub_79E5:       ; CODE XREF: update_state3+2p
          ; update_state6+25p ...
    ld  c, a
    and 111111b
    ld  b, 2
    ld  hl, music_channel2
    cp  9
    jr  c, loc_7A06
    ld  hl, music_channel1
    cp  0Ch
    jr  c, loc_7A06
    cp  11h
    jr  z, loc_7A07
    ld  hl, music_channel0
    cp  13h
    jr  c, loc_7A06
    inc b
    jr  loc_7A07
; ---------------------------------------------------------------------------

loc_7A06:       ; CODE XREF: music_sub_79E5+Aj
          ; music_sub_79E5+11j ...
    dec b

loc_7A07:       ; CODE XREF: music_sub_79E5+15j
          ; music_sub_79E5+1Fj
    ld  a, (hl)
    and 3Fh ; '?'
    ld  e, a
    ld  a, c
    and 3Fh ; '?'
    cp  e
    ret c
    add a, a
    ld  de, word_7BED
    call  add_a_to_de ; DE=DE+A
    dec hl
    dec hl

loc_7A19:       ; CODE XREF: music_sub_79E5+47j
    ld  (hl), 1
    inc hl
    ld  (hl), 1
    inc hl
    ld  (hl), c
    inc hl
    ld  a, (de)
    ld  (hl), a
    inc hl
    inc de
    ld  a, (de)
    ld  (hl), a
    ld  a, 8
    add a, l
    ld  l, a
    inc de
    djnz  loc_7A19
    ret
; End of function music_sub_79E5


; =============== S U B R O U T I N E =======================================


music_sub_7A2F:       ; CODE XREF: music_sub_7A9C+1Bj
    inc hl
    ld  a, (ix+9)
    inc a
    cp  (hl)
    jp  z, loc_7B30
    jp  m, loc_7A3C
    dec a

loc_7A3C:       ; CODE XREF: music_sub_7A2F+9j
    ex  af, af'
    ld  a, (ix+2)
    push  bc
    ld  d, 1
    call  music_sub_79E5
    pop bc
    ex  af, af'
    ld  (ix+9), a
    ret
; End of function music_sub_7A2F


; =============== S U B R O U T I N E =======================================


music_sub_7A4C:       ; CODE XREF: music_sub_7A9C+4p
          ; music_sub_7A9C+5Ep ...
    ld  a, (psg_reg7)
    ld  e, a
    ld  a, c
    cp  1
    jr  z, loc_7A56
    dec a

loc_7A56:       ; CODE XREF: music_sub_7A4C+7j
    rlca
    rlca
    rlca
    dec d
    jr  z, loc_7A60
    cpl
    and e
    jr  loc_7A61
; ---------------------------------------------------------------------------

loc_7A60:       ; CODE XREF: music_sub_7A4C+Ej
    or  e

loc_7A61:       ; CODE XREF: music_sub_7A4C+12j
    set 2, a
    bit 5, a
    jr  z, write_psg_reg7
    res 2, a
    set 0, a
    bit 3, a
    jr  z, write_psg_reg7
    res 0, a
; End of function music_sub_7A4C


; =============== S U B R O U T I N E =======================================


write_psg_reg7:       ; CODE XREF: init+2p
          ; music_sub_7A4C+19j ...
    ld  (psg_reg7), a
    ld  e, a
    ld  a, 7
    jp  WRTPSG
; End of function write_psg_reg7


; =============== S U B R O U T I N E =======================================


update_music:       ; CODE XREF: isr+4p isr+1Fp ...
    ld  a, (psg_reg7)
    call  write_psg_reg7
    ld  c, 1
    ld  ix, music_channels
    exx
    ld  b, 3
    ld  de, 12

loc_7A8C:       ; CODE XREF: update_music+1Fj
    exx
    ld  a, (ix+2)
    or  a
    call  nz, music_sub_7A9C
    inc c
    inc c
    exx
    add ix, de
    djnz  loc_7A8C
    ret
; End of function update_music


; =============== S U B R O U T I N E =======================================


music_sub_7A9C:       ; CODE XREF: update_music+17p
    bit 6, a
    ld  d, 1
    call  z, music_sub_7A4C
    ld  a, (ix+2)
    or  a
    jp  m, loc_7B43
    dec (ix+0)
    ret nz

loc_7AAE:       ; CODE XREF: music_sub_7B23+23j
    ld  l, (ix+3)
    ld  h, (ix+4)
    ld  a, (hl)
    cp  0FEh ; ''
    jp  z, music_sub_7A2F
    jr  nc, loc_7B30
    bit 7, (ix+2)
    jp  nz, loc_7B5E
    and 0F0h ; ''
    cp  20h ; ' '
    ld  a, (hl)
    jr  nz, loc_7AD1
    and 0Fh
    ld  (ix+1), a
    inc hl
    ld  a, (hl)

loc_7AD1:       ; CODE XREF: music_sub_7A9C+2Cj
    ld  b, a
    and 0F0h ; ''
    cp  10h
    jr  nz, loc_7AFE
    ld  a, (hl)
    and 1Fh
    ld  e, a
    ld  a, c
    cp  3
    jr  z, loc_7AEC
    inc hl
    bit 4, (hl)
    ld  b, (hl)
    jr  nz, loc_7AEB
    ld  a, e
    sub 10h
    ld  e, a

loc_7AEB:       ; CODE XREF: music_sub_7A9C+49j
    dec hl

loc_7AEC:       ; CODE XREF: music_sub_7A9C+43j
    ld  a, 6
    call  WRTPSG
    ld  a, 0Dh
    ld  e, 0Fh
    call  WRTPSG
    ld  d, 0
    call  music_sub_7A4C
    inc hl

loc_7AFE:       ; CODE XREF: music_sub_7A9C+3Aj
    bit 6, (ix+2)
    jr  z, loc_7B10
    ld  a, c
    cp  3
    ld  a, (hl)
    jr  z, loc_7B10
    call  music_sub_7BDB
    ld  a, b
    jr  music_sub_7B23
; ---------------------------------------------------------------------------

loc_7B10:       ; CODE XREF: music_sub_7A9C+66j
          ; music_sub_7A9C+6Cj
    and 0F0h ; ''
    ld  b, a
    xor (hl)
    ld  d, a
    inc hl
    ld  e, (hl)
    call  music_sub_7BDB
    ex  de, hl
    call  music_sub_7BD0
    ld  a, b
    rrca
    rrca
    rrca
    rrca
; End of function music_sub_7A9C


; =============== S U B R O U T I N E =======================================


music_sub_7B23:       ; CODE XREF: music_sub_7A9C+72j
          ; music_sub_7B23+8Fp
    ld  h, a
    ld  a, (ix+1)
    ld  (ix+0), a
    ld  (ix+8), 2
    jr  loc_7B56
; ---------------------------------------------------------------------------

loc_7B30:       ; CODE XREF: music_sub_7A2F+6j
          ; music_sub_7A9C+1Ej
    xor a
    ld  (ix+9), a
    ld  (ix+0Bh), a
    ld  d, 1
    call  music_sub_7A4C
    xor a
    ld  (ix+2), a
    ld  h, a
    jr  loc_7B56
; ---------------------------------------------------------------------------

loc_7B43:       ; CODE XREF: music_sub_7A9C+Bj
    dec (ix+0)
    jp  z, loc_7AAE
    dec (ix+8)
    ret nz
    ld  a, (ix+7)
    dec a
    ret m
    ld  (ix+7), a
    ld  h, a

loc_7B56:       ; CODE XREF: music_sub_7B23+Bj
          ; music_sub_7B23+1Ej
    ld  a, c
    rrca
    add a, 88h ; ''
    ld  e, h
    jp  WRTPSG    ; Function : Writes data to PSG-register
          ; Input    : A  - PSG register number
          ;      E  - data write
; ---------------------------------------------------------------------------

loc_7B5E:       ; CODE XREF: music_sub_7A9C+24j
          ; music_sub_7B23+63j
    ld  a, (hl)
    and 0F0h ; ''
    cp  0D0h ; ''
    ld  a, (hl)
    jr  nz, loc_7B6D
    and 0Fh
    ld  (ix+0Ah), a
    inc hl
    ld  a, (hl)

loc_7B6D:       ; CODE XREF: music_sub_7B23+41j
    cp  0F0h ; ''
    jr  c, loc_7B78
    and 0Fh
    ld  (ix+6), a
    inc hl
    ld  a, (hl)

loc_7B78:       ; CODE XREF: music_sub_7B23+4Cj
    cp  0E0h ; ''
    jr  c, loc_7B8D
    and 0Fh
    bit 3, a
    jr  z, loc_7B88
    ld  (ix+0Bh), a
    inc hl
    jr  loc_7B5E
; ---------------------------------------------------------------------------

loc_7B88:       ; CODE XREF: music_sub_7B23+5Dj
    ld  (ix+5), a
    inc hl
    ld  a, (hl)

loc_7B8D:       ; CODE XREF: music_sub_7B23+57j
    and 0Fh
    ld  b, a
    ld  a, (ix+0Ah)
    jr  z, loc_7B9A

loc_7B95:       ; CODE XREF: music_sub_7B23+75j
    add a, (ix+0Ah)
    djnz  loc_7B95

loc_7B9A:       ; CODE XREF: music_sub_7B23+70j
    ld  (ix+1), a
    ld  a, (hl)
    call  music_sub_7BDB
    and 0F0h ; ''
    rrca
    rrca
    rrca
    rrca
    ld  b, a
    sub 0Ch
    jr  z, loc_7BAF
    ld  a, (ix+6)

loc_7BAF:       ; CODE XREF: music_sub_7B23+87j
    ld  (ix+7), a
    call  music_sub_7B23
    ld  a, b
    ld  hl, byte_7BE3
    call  add_a_to_hl ; HL=HL+A
    ld  l, (hl)
    ld  h, 0
    ld  a, (ix+5)
    or  a
    jr  z, music_sub_7BD0
    ld  b, a

loc_7BC6:       ; CODE XREF: music_sub_7B23+A4j
    add hl, hl
    djnz  loc_7BC6
    ld  a, (ix+0Bh)
    or  a
    jr  z, music_sub_7BD0
    inc hl
; End of function music_sub_7B23


; =============== S U B R O U T I N E =======================================


music_sub_7BD0:       ; CODE XREF: music_sub_7A9C+7Fp
          ; music_sub_7B23+A0j ...
    ld  a, c
    ld  e, h
    call  WRTPSG
    ld  a, c
    dec a
    ld  e, l
    jp  WRTPSG
; End of function music_sub_7BD0


; =============== S U B R O U T I N E =======================================


music_sub_7BDB:       ; CODE XREF: music_sub_7A9C+6Ep
          ; music_sub_7A9C+7Bp ...
    inc hl
    ld  (ix+3), l
    ld  (ix+4), h
    ret
; End of function music_sub_7BDB

; ---------------------------------------------------------------------------
byte_7BE3:  db 6Ah      ; DATA XREF: music_sub_7B23+93o
byte_7BE4:  db 64h, 5Fh, 59h, 54h, 50h, 4Bh, 47h, 43h, 3Fh
word_7BED:  dw 383Ch    ; DATA XREF: music_sub_79E5+2Co
    dw byte_7C4F
    dw byte_7CA8
    dw byte_7C6D
    dw byte_7C8B
    dw byte_7D85
    dw byte_7C57
    dw byte_7D6B
    dw byte_7FC0
    dw byte_7C30
    dw byte_7E1D
    dw byte_7D96
    dw byte_7C3D
    dw byte_7CE6
    dw byte_7CCE
    dw byte_7CF8
    dw byte_7DE6
    dw byte_7F74
    dw byte_7FB9
    dw byte_7E31
    dw byte_7E34
    dw byte_7E78
    dw unk_7EDC
    dw byte_7EDD
    dw byte_7EF1
    dw byte_7F0A
    dw byte_7F2D
    dw byte_7F50
    dw byte_7DB0
    dw byte_7C2D
    dw byte_7C2D
    dw byte_7C2D
byte_7C2D:  db 0FFh, 0FEh, 0FFh ; DATA XREF: ROM:7C27o  ROM:7C29o ...
byte_7C30:  db 0D1h, 0FDh, 0E2h, 50h, 0E1h, 90h, 0E2h, 20h, 0E1h, 90h
          ; DATA XREF: ROM:7BFFo
    db 0C0h, 0FEh, 2
byte_7C3D:  db 21h, 0D0h, 0C0h, 0C0h, 0D0h, 0C0h, 0E0h, 0C0h, 0F0h
          ; DATA XREF: ROM:7C05o
    db 0B1h, 0, 0B1h, 10h, 0B1h, 20h, 0B1h, 30h, 0FFh
byte_7C4F:  db 0D2h, 0FDh, 0E3h, 40h, 50h, 60h, 50h, 0FFh ; DATA XREF: ROM:7BEFo
byte_7C57:  db 22h, 0D0h, 70h, 21h, 0C0h, 72h, 0B0h, 70h, 0C0h, 50h
          ; DATA XREF: ROM:7BF9o
    db 22h, 0B0h, 52h, 0A0h, 50h, 0B0h, 50h, 0A0h, 52h, 90h
    db 50h, 0FFh
byte_7C6D:  db 21h, 80h, 0A0h, 90h, 98h, 0A0h, 90h, 0B0h, 88h, 22h
          ; DATA XREF: ROM:7BF3o
    db 0B0h, 88h, 0B0h, 78h, 0B0h, 70h, 0B0h, 78h, 0B0h
byte_7C80:  db 80h, 21h, 0B0h, 88h, 0A0h, 90h, 90h, 98h, 80h, 0A0h
          ; DATA XREF: ROM:55E9o  ROM:off_55FCo ...
    db 0FFh
byte_7C8B:  db 0D1h, 0FBh, 0E3h, 10h, 30h, 60h, 80h, 0A0h, 0FCh, 0E2h
          ; DATA XREF: ROM:7BF5o
    db 0, 20h, 40h, 60h, 80h, 90h, 0B0h, 70h, 50h, 30h, 10h
    db 0FBh, 0E3h, 0A0h, 80h, 60h, 30h, 10h, 0FFh
byte_7CA8:  db 23h, 0A0h, 40h, 0A0h, 44h, 0A0h, 48h, 0A0h, 4Bh, 0A0h
          ; DATA XREF: ROM:7BF1o
    db 50h, 0B0h, 55h, 0B0h, 5Ah, 0B0h, 60h, 0B0h, 68h, 0B0h
    db 70h, 0B0h, 78h, 0B0h, 80h, 0B0h, 88h, 0B0h, 90h, 0B0h
    db 98h, 0B0h, 0A0h, 0B0h, 0A8h, 0B0h, 0B0h, 0FFh
byte_7CCE:  db 0D1h, 0FDh, 0E1h, 0, 30h, 60h, 30h, 60h, 80h, 0A0h ; DATA XREF: ROM:7C09o
    db 0E0h, 0, 20h, 40h, 0C2h, 0E1h, 0B0h, 80h, 60h, 30h
    db 60h, 30h, 0, 0FFh
byte_7CE6:  db 21h, 0F0h, 1Ch, 80h, 1Ch, 80h, 1Ch, 0E0h, 1Ch, 0C0h
          ; DATA XREF: ROM:7C07o
    db 1Ch, 0B0h, 1Ch, 0A0h, 1Ch, 90h, 1Ch, 0FFh
byte_7CF8:  db 0D1h, 0FBh, 0E3h, 20h, 0, 30h, 10h, 40h, 20h, 50h, 30h
          ; DATA XREF: ROM:7C0Bo
    db 60h, 40h, 70h, 50h, 80h, 60h, 90h, 70h, 0A0h, 80h, 0B0h
    db 90h, 0FCh, 0E2h, 0, 0E3h, 0, 0E3h, 0A0h, 0E2h, 10h
    db 0E3h, 0B0h, 0E2h, 20h, 0, 30h, 10h, 40h, 20h, 50h, 30h
    db 60h, 40h, 70h, 50h, 80h, 60h, 90h, 70h, 0A0h, 80h, 0B0h
    db 90h, 0FDh, 0E1h, 0, 0E2h, 0A0h, 0E1h, 10h, 0E2h, 0B0h
    db 0E1h, 20h, 0, 30h, 10h, 40h, 20h, 50h, 30h, 60h, 40h
    db 70h, 50h, 80h, 60h, 90h, 70h, 0A0h, 80h, 0B0h, 90h
    db 0E0h, 0, 0E1h, 0A0h, 0E0h, 10h, 0E1h, 0B0h, 0E0h, 20h
    db 0, 30h, 10h, 40h, 20h, 50h, 30h, 60h, 40h, 70h, 50h
    db 80h, 60h, 90h, 70h, 0A0h, 80h, 0B0h, 90h, 0FFh
byte_7D6B:  db 21h, 1Fh, 0Ah, 1Bh, 1Ch, 17h, 0Eh, 13h, 1Ah, 22h, 0
          ; DATA XREF: ROM:7BFBo
    db 21h, 11h, 0Ah, 14h, 1Ch, 16h, 0Eh, 1Ah, 1Bh, 1Eh, 0Ah
    db 22h, 0, 0FEh, 2
byte_7D85:  db 0D1h, 0FDh, 0E2h, 70h, 0FCh, 40h, 0FBh, 0, 0FDh, 70h
          ; DATA XREF: ROM:7BF7o
    db 0FCh, 40h, 0FBh, 0, 0C0h, 0FEh, 6
byte_7D96:  db 22h, 0D0h, 5Fh, 0C0h, 61h, 0B0h, 5Fh, 0D0h, 4Bh, 0C0h
          ; DATA XREF: ROM:7C03o
    db 4Dh, 0B0h, 4Bh, 0D0h, 5Fh, 0C0h, 61h, 0B0h, 5Fh, 0D0h
    db 3Fh, 0C0h, 41h, 0B0h, 3Fh, 0FFh
byte_7DB0:  db 22h, 1Dh, 1Fh, 0Eh, 0Fh, 1Ch, 1Fh, 0Eh, 0Fh, 1Bh, 1Eh
          ; DATA XREF: ROM:7C25o
    db 0Dh, 0Eh, 1Ah, 1Eh, 0Dh, 0Eh, 19h, 1Dh, 0Ch, 0Dh, 18h
    db 1Ch, 0Bh, 0Ch, 19h, 1Bh, 0Ah, 0Bh, 1Ah, 1Ah, 9, 0Ah
    db 1Bh, 19h, 8, 9, 1Ch, 18h, 7, 8, 1Dh, 17h, 6, 5, 1Eh
    db 16h, 5, 6, 1Fh, 15h, 4, 5, 0FFh
byte_7DE6:  db 22h, 1Dh   ; DATA XREF: ROM:7C0Do
word_7DE8:  dw 0Fh, 1C0Eh, 0Fh, 1B0Eh, 0Eh, 1A0Dh, 0Eh, 190Dh, 0Dh
    dw 180Ch, 0Ch, 190Bh, 0Bh, 1A0Ah, 0Ah, 1B09h, 9, 1C08h
    dw 8, 1D07h, 7, 1E06h, 6, 1F05h, 5, 0FF04h
    db 0FFh
byte_7E1D:  db 22h, 0D0h, 0CAh, 0D0h, 0C8h, 0, 0, 0D0h, 0CAh, 0C0h
          ; DATA XREF: ROM:7C01o
    db 0C8h, 0, 0, 0B0h, 0CBh, 0B0h, 0CAh, 0A0h, 0C8h, 0FFh
byte_7E31:  db 0D3h, 0C0h, 0E8h ; DATA XREF: ROM:7C13o
byte_7E34:  db 0D6h, 0FCh, 0E2h, 0, 50h, 70h, 0E1h, 0, 0E2h, 70h, 50h
          ; DATA XREF: ROM:7C15o
    db 0, 50h, 70h, 0E1h, 0, 0E2h, 70h, 50h, 40h, 90h, 0B0h
    db 0E1h, 40h, 0E2h, 0B0h, 90h, 40h, 90h, 0B0h, 0E1h, 40h
    db 0E2h, 0B0h, 90h, 0, 50h, 70h, 0E1h, 0, 0E2h, 70h, 50h
    db 0, 50h, 70h, 0E1h, 0, 0E2h, 70h, 50h, 40h, 90h, 0B0h
    db 0E1h, 40h, 0E2h, 0B0h, 90h, 40h, 90h, 0B0h, 0E1h, 40h
    db 0E2h, 0B0h, 90h, 0FFh
byte_7E78:  db 0D3h, 0FCh, 0E3h, 0, 0C0h, 0, 0C0h, 0, 0C0h, 0, 0C0h
          ; DATA XREF: ROM:7C17o
    db 0, 0C0h, 0, 0C0h, 0, 0C0h, 0, 0C0h, 0, 0C0h, 0, 0C0h
    db 0, 0C0h, 0, 0C0h, 40h, 0C0h, 40h, 0C0h, 40h, 0C0h, 40h
    db 0C0h, 40h, 0C0h, 40h, 0C0h, 40h, 0C0h, 40h, 0C0h, 40h
    db 0C0h, 40h, 0C0h, 40h, 0C0h, 40h, 0C0h, 0, 0C0h, 0, 0C0h
    db 0, 0C0h, 0, 0C0h, 0, 0C0h, 0, 0C0h, 0, 0C0h, 0, 0C0h
    db 0, 0C0h, 0, 0C0h, 0, 0C0h, 0, 0C0h, 40h, 0C0h, 40h
    db 0C0h, 40h, 0C0h, 40h, 0C0h, 40h, 0C0h, 40h, 0C0h, 40h
    db 0C0h, 40h, 0C0h, 40h, 0C0h, 40h, 0C0h, 40h, 0C0h, 40h
    db 0C0h, 0FFh
unk_7EDC: db 0E8h ;     ; DATA XREF: ROM:7C19o
byte_7EDD:  db 0D4h, 0C2h, 0FCh, 0E1h, 26h, 0C0h, 46h, 0C0h, 56h, 0C0h
          ; DATA XREF: ROM:7C1Bo
    db 42h, 0C0h, 52h, 0C0h, 76h, 0C0h, 46h, 0C0h, 5Fh, 0FFh
byte_7EF1:  db 0D4h, 0C2h, 0FDh, 0E2h, 96h, 0C0h, 0B6h, 0C0h, 0E1h
          ; DATA XREF: ROM:7C1Do
    db 6, 0C0h, 0E2h, 0B2h, 0C0h, 0E1h, 2, 0C0h, 26h, 0C0h
    db 0E2h, 0B6h, 0C0h, 0E1h, 0Fh, 0FFh
byte_7F0A:  db 0D7h, 0C3h, 0FCh, 0E1h, 20h, 10h, 20h, 40h, 50h, 40h
          ; DATA XREF: ROM:7C1Fo
    db 20h, 10h, 20h, 50h, 40h, 70h, 50h, 40h, 20h, 10h, 0D8h
    db 21h, 0DAh, 0E2h, 91h, 0DBh, 71h, 0DCh, 0A1h, 0D6h, 20h
    db 90h, 0E1h, 25h, 0FFh
byte_7F2D:  db 0D7h, 0C3h, 0FCh, 0E3h, 21h, 91h, 90h, 70h, 50h, 40h
          ; DATA XREF: ROM:7C21o
    db 50h, 70h, 0A0h, 90h, 70h, 50h, 40h, 0E2h, 20h, 0D8h
    db 0E3h, 90h, 0E2h, 50h, 0DAh, 20h, 40h, 0DBh, 0E3h, 0A0h
    db 70h, 0DCh, 41h, 24h, 0FFh
byte_7F50:  db 0D7h, 0C3h, 0FBh, 0E2h, 90h, 70h, 90h, 0A0h, 0E1h, 0
          ; DATA XREF: ROM:7C23o
    db 0E2h, 0A0h, 90h, 70h, 90h, 0E1h, 0, 0E2h, 0A0h, 0E1h
    db 20h, 0, 0E2h, 0A0h, 90h, 70h, 0D8h, 91h, 0DAh, 51h
    db 0DBh, 41h, 0DCh, 71h, 54h, 0FFh
byte_7F74:  db 0D1h, 0FDh, 0E1h, 70h, 0C3h, 70h, 0C3h, 70h, 0C3h, 70h
          ; DATA XREF: ROM:7C0Fo
    db 0C3h, 70h, 0C3h, 70h, 0C3h, 70h, 0C3h, 70h, 0C3h, 0A0h
    db 0C3h, 0A0h, 0C3h, 0A0h, 0C3h, 0A0h, 0C3h, 0A0h, 0C3h
    db 0A0h, 0C3h, 0A0h, 0C3h, 0A0h, 0C3h, 60h, 0C3h, 60h
    db 0C3h, 60h, 0C3h, 60h, 0C3h, 60h, 0C3h, 60h, 0C3h, 60h
    db 0C3h, 60h, 0C3h, 60h, 0C3h, 60h, 0C3h, 60h, 0C3h, 60h
    db 0C3h, 60h, 0C3h, 60h, 0C3h, 60h, 0C3h, 60h, 0C3h, 0FEh
    db 2
byte_7FB9:  db 0D8h, 0FDh, 0E3h, 74h, 0A4h, 69h, 0FFh ; DATA XREF: ROM:7C11o
byte_7FC0:  db 0D4h, 0FDh, 0E3h, 52h, 72h, 82h, 0A2h, 0B2h, 0A2h, 82h
          ; DATA XREF: ROM:7BFDo
    db 72h, 0D2h, 0E2h, 50h, 0C0h, 50h, 0C0h, 50h, 0C0h, 70h
    db 0C0h, 70h, 0C0h, 70h, 0C0h, 80h, 0C0h, 80h, 0C0h, 80h
    db 0C0h, 0A0h, 0C0h, 0A0h, 0C0h, 0A0h, 0C0h, 0B0h, 0C0h
    db 0B0h, 0C0h, 0B0h, 0C0h, 0A0h, 0C0h, 0A0h, 0C0h, 0A0h
    db 0C0h, 80h, 0C0h, 80h, 0C0h, 80h, 0C0h, 70h, 0C0h, 70h
    db 0C0h, 70h, 0FFh, 0FFh, 0FFh, 0FFh